/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import twilightforest.entity.ai.goal.HoverBaseGoal;
import twilightforest.entity.boss.SnowQueen;

public class HoverSummonGoal
extends HoverBaseGoal<SnowQueen> {
    private static final int MAX_MINIONS_AT_ONCE = 4;
    private int seekTimer;
    private final int maxSeekTime;

    public HoverSummonGoal(SnowQueen snowQueen) {
        super(snowQueen, 6.0f, 6.0f);
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.maxSeekTime = 80;
    }

    public boolean canUse() {
        LivingEntity target = ((SnowQueen)this.attacker).getTarget();
        if (target == null) {
            return false;
        }
        if (!target.isAlive()) {
            return false;
        }
        if (((SnowQueen)this.attacker).getCurrentPhase() != SnowQueen.Phase.SUMMON) {
            return false;
        }
        return ((SnowQueen)this.attacker).getSensing().hasLineOfSight((Entity)target);
    }

    public boolean canContinueToUse() {
        LivingEntity target = ((SnowQueen)this.attacker).getTarget();
        if (target == null || !target.isAlive()) {
            return false;
        }
        if (((SnowQueen)this.attacker).getCurrentPhase() != SnowQueen.Phase.SUMMON) {
            return false;
        }
        if (this.seekTimer > this.maxSeekTime) {
            return false;
        }
        return ((SnowQueen)this.attacker).hasLineOfSight((Entity)target);
    }

    public void stop() {
    }

    public void tick() {
        ++this.seekTimer;
        LivingEntity target = ((SnowQueen)this.attacker).getTarget();
        if (target != null && ((SnowQueen)this.attacker).distanceToSqr(this.hoverPosX, this.hoverPosY, this.hoverPosZ) <= 3.0) {
            this.checkAndSummon();
            this.makeNewHoverSpot(target);
        }
        double offsetX = this.hoverPosX - ((SnowQueen)this.attacker).getX();
        double offsetY = this.hoverPosY - ((SnowQueen)this.attacker).getY();
        double offsetZ = this.hoverPosZ - ((SnowQueen)this.attacker).getZ();
        double distanceDesired = offsetX * offsetX + offsetY * offsetY + offsetZ * offsetZ;
        distanceDesired = Mth.sqrt((float)((float)distanceDesired));
        double velX = offsetX / distanceDesired * 0.05;
        double velY = offsetY / distanceDesired * 0.1;
        double velZ = offsetZ / distanceDesired * 0.05;
        ((SnowQueen)this.attacker).push(velX, velY += 0.05, velZ);
        if (target != null) {
            ((SnowQueen)this.attacker).lookAt((Entity)target, 30.0f, 30.0f);
            ((SnowQueen)this.attacker).getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
        }
    }

    @Override
    protected void makeNewHoverSpot(LivingEntity target) {
        super.makeNewHoverSpot(target);
        this.seekTimer = 0;
    }

    private void checkAndSummon() {
        if (((SnowQueen)this.attacker).getSummonsRemaining() > 0 && ((SnowQueen)this.attacker).countMyMinions() < 4) {
            ((SnowQueen)this.attacker).summonMinionAt(((SnowQueen)this.attacker).getTarget());
        }
    }
}

