/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai.goal;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import twilightforest.TwilightForestMod;

public abstract class HoverBaseGoal<T extends Mob>
extends Goal {
    protected final T attacker;
    protected final float hoverHeight;
    protected final float hoverRadius;
    protected double hoverPosX;
    protected double hoverPosY;
    protected double hoverPosZ;

    protected HoverBaseGoal(T snowQueen, float hoverHeight, float hoverRadius) {
        this.attacker = snowQueen;
        this.hoverHeight = hoverHeight;
        this.hoverRadius = hoverRadius;
    }

    public void start() {
        LivingEntity target = this.attacker.getTarget();
        if (target != null) {
            this.makeNewHoverSpot(target);
        }
    }

    protected void makeNewHoverSpot(LivingEntity target) {
        double hx = 0.0;
        double hy = 0.0;
        double hz = 0.0;
        boolean found = false;
        for (int i = 0; i < 100; ++i) {
            hx = target.getX() + (double)((this.attacker.getRandom().nextFloat() - this.attacker.getRandom().nextFloat()) * this.hoverRadius);
            if (this.isPositionOccupied(hx, hy = target.getY() + (double)this.hoverHeight, hz = target.getZ() + (double)((this.attacker.getRandom().nextFloat() - this.attacker.getRandom().nextFloat()) * this.hoverRadius)) || !this.attacker.hasLineOfSight((Entity)target)) continue;
            found = true;
            break;
        }
        if (!found) {
            TwilightForestMod.LOGGER.debug("Found no spots, giving up");
        }
        this.hoverPosX = hx;
        this.hoverPosY = hy;
        this.hoverPosZ = hz;
    }

    protected boolean isPositionOccupied(double hx, double hy, double hz) {
        float radius = this.attacker.getBbWidth() / 2.0f;
        AABB aabb = new AABB(hx - (double)radius, hy, hz - (double)radius, hx + (double)radius, hy + (double)this.attacker.getBbHeight(), hz + (double)radius);
        return !this.attacker.level().isUnobstructed(this.attacker, Shapes.create((AABB)aabb)) || !this.attacker.level().noCollision(this.attacker, aabb);
    }
}

