/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;
import twilightforest.entity.EnforcedHomePoint;

public class AttemptToGoHomeGoal<T extends PathfinderMob>
extends Goal {
    private final T mob;
    private double wantedX;
    private double wantedY;
    private double wantedZ;
    private final double speedModifier;

    public AttemptToGoHomeGoal(T mob, double speedModifier) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (((EnforcedHomePoint)this.mob).getRestrictionPoint() == null || ((EnforcedHomePoint)this.mob).isMobWithinHomeArea((Entity)this.mob)) {
            return false;
        }
        Vec3 vec3 = DefaultRandomPos.getPosTowards(this.mob, (int)16, (int)7, (Vec3)Vec3.atBottomCenterOf((Vec3i)((EnforcedHomePoint)this.mob).getRestrictionPoint().pos()), (double)1.5707963705062866);
        if (vec3 == null) {
            return false;
        }
        this.wantedX = vec3.x;
        this.wantedY = vec3.y;
        this.wantedZ = vec3.z;
        return true;
    }

    public boolean canContinueToUse() {
        return !this.mob.getNavigation().isDone();
    }

    public void start() {
        this.mob.getNavigation().stop();
        this.mob.getNavigation().moveTo(this.wantedX, this.wantedY, this.wantedZ, this.speedModifier);
    }
}

