/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.dispenser;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import twilightforest.item.TransformPowderItem;

public class TransformationDispenseBehavior
extends DefaultDispenseItemBehavior {
    boolean fired = false;

    protected ItemStack execute(BlockSource source, ItemStack stack) {
        ServerLevel level = source.level();
        BlockPos blockpos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING));
        if (!level.isClientSide()) {
            for (LivingEntity livingentity : level.getEntitiesOfClass(LivingEntity.class, new AABB(blockpos), EntitySelector.NO_SPECTATORS)) {
                if (!TransformPowderItem.transformEntityIfPossible(livingentity, stack, true)) continue;
                this.fired = true;
            }
        }
        return stack;
    }

    protected void playSound(BlockSource source) {
        if (this.fired) {
            super.playSound(source);
        } else {
            source.level().levelEvent(1001, source.pos(), 0);
        }
    }
}

