/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import twilightforest.data.helpers.TFLangProvider;
import twilightforest.data.tags.FluidTagGenerator;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.init.TFBiomes;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFEntities;
import twilightforest.init.TFGameRules;
import twilightforest.init.TFItems;
import twilightforest.init.TFKeyBinds;
import twilightforest.init.TFKeyBindsCategories;
import twilightforest.init.TFStructures;
import twilightforest.init.custom.TravellersModifiersManager;

public class LangGenerator
extends TFLangProvider {
    public static final Map<ResourceLocation, Pair<String, String>> MAGIC_PAINTING_HELPER = new HashMap<ResourceLocation, Pair<String, String>>();
    public static final Map<String, String> SUBTITLE_GENERATOR = new HashMap<String, String>();

    public LangGenerator(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    @Override
    protected void addTranslations(HolderLookup.Provider registries) {
        this.add("itemGroup.twilightforest.blocks", "Twilight Forest: Blocks");
        this.add("itemGroup.twilightforest.items", "Twilight Forest: Items");
        this.add("itemGroup.twilightforest.equipment", "Twilight Forest: Equipment");
        this.add("itemGroup.twilightforest.food", "Twilight Forest: Food");
        this.addBiome(TFBiomes.FOREST, "Twilight Forest");
        this.addBiome(TFBiomes.DENSE_FOREST, "Dense Forest");
        this.addBiome(TFBiomes.FIREFLY_FOREST, "Firefly Forest");
        this.addBiome(TFBiomes.CLEARING, "Twilight Clearing");
        this.addBiome(TFBiomes.OAK_SAVANNAH, "Oak Savanna");
        this.addBiome(TFBiomes.STREAM, "Twilight Stream");
        this.addBiome(TFBiomes.LAKE, "Twilight Lake");
        this.addBiome(TFBiomes.MUSHROOM_FOREST, "Mushroom Forest");
        this.addBiome(TFBiomes.DENSE_MUSHROOM_FOREST, "Dense Mushroom Forest");
        this.addBiome(TFBiomes.ENCHANTED_FOREST, "Enchanted Forest");
        this.addBiome(TFBiomes.SPOOKY_FOREST, "Spooky Forest");
        this.addBiome(TFBiomes.SWAMP, "Twilight Swamp");
        this.addBiome(TFBiomes.FIRE_SWAMP, "Fire Swamp");
        this.addBiome(TFBiomes.DARK_FOREST, "Dark Forest");
        this.addBiome(TFBiomes.DARK_FOREST_CENTER, "Dark Forest Center");
        this.addBiome(TFBiomes.SNOWY_FOREST, "Snowy Forest");
        this.addBiome(TFBiomes.GLACIER, "Twilight Glacier");
        this.addBiome(TFBiomes.HIGHLANDS, "Twilight Highlands");
        this.addBiome(TFBiomes.HIGHLANDS_UNDERGROUND, "Troll Caves");
        this.addBiome(TFBiomes.THORNLANDS, "Thornlands");
        this.addBiome(TFBiomes.FINAL_PLATEAU, "Final Plateau");
        this.addBiome(TFBiomes.UNDERGROUND, "Underground");
        this.add("dimension.twilightforest.twilight_forest", "Twilight Forest");
        this.addStructure(TFStructures.HEDGE_MAZE, "Hedge Maze");
        this.addStructure(TFStructures.HOLLOW_HILL_SMALL, "Small Hollow Hill");
        this.addStructure(TFStructures.HOLLOW_HILL_MEDIUM, "Medium Hollow Hill");
        this.addStructure(TFStructures.HOLLOW_HILL_LARGE, "Large Hollow Hill");
        this.addStructure(TFStructures.QUEST_GROVE, "Quest Grove");
        this.addStructure(TFStructures.MUSHROOM_TOWER, "Mushroom Castle");
        this.addStructure(TFStructures.NAGA_COURTYARD, "Naga Courtyard");
        this.addStructure(TFStructures.LICH_TOWER, "Lich Tower");
        this.addStructure(TFStructures.LABYRINTH, "Minotaur Labyrinth");
        this.addStructure(TFStructures.HYDRA_LAIR, "Hydra's Lair");
        this.addStructure(TFStructures.KNIGHT_STRONGHOLD, "Knight Stronghold");
        this.addStructure(TFStructures.DARK_TOWER, "Dark Tower");
        this.addStructure(TFStructures.YETI_CAVE, "Yeti Cave");
        this.addStructure(TFStructures.AURORA_PALACE, "Aurora Palace");
        this.addStructure(TFStructures.TROLL_CAVE, "Troll Cave");
        this.addStructure(TFStructures.FINAL_CASTLE, "Final Plateau Castle");
        this.addCommand("usage", "/%s <info | reactivate | conquer | center>");
        this.addCommand("not_player", "This command must be run by a valid player!");
        this.addCommand("none_nearby", "Couldn't find a feature nearby!");
        this.addCommand("nearest", "The nearest feature is: %s");
        this.addCommand("center", "Center of feature: %s");
        this.addCommand("chunk", "Located in feature chunk: %s");
        this.addCommand("structure.inside", "You are in a Landmark structure");
        this.addCommand("structure.outside", "You are not in a Landmark structure");
        this.addCommand("structure.required", "You are not in a structure");
        this.addCommand("structure.conquer.status", "Structure conquer flag: %s");
        this.addCommand("structure.conquer.update", "Structure conquer flag was %s, changing to %s");
        this.addCommand("structure.spawn_list", "Spawn list for this area is:");
        this.addCommand("structure.spawn_info", "%s, Weight %s");
        this.addCommand("structure.boundaries", "Structure boundaries: %s");
        this.addCommand("info.wip", "This command is still WIP, some things may still be broken.");
        this.addCommand("biomepng.progress", "%s%% Done mapping");
        this.addCommand("biomepng.counts_header", "Approximate biome-block counts within a %sx%s region");
        this.addCommand("biomepng.save_failed", "Could not save image! Please report this!");
        this.addCommand("biomepng.save_success", "Image saved!");
        this.addCommand("display_pieces.missing_key", "missing key");
        this.addCommand("generator_radius.center_chunk", "Structure start's center chunk");
        this.addCommand("generator_radius.radius", "Radius from center chunk: %s");
        this.addCommand("teleport.player_only", "Command must be run by a player.");
        this.addCommand("teleport.dimension_missing", "The Twilight Forest dimension is unavailable.");
        this.addCommand("teleport.success", "Teleported to The Twilight Forest at %s %s %s");
        this.addCommand("invalid_modifier", "%s is not a valid Traveller's Gear Modifier");
        this.addCommand("not_travellers_gear", "You are not holding a piece of Traveller's Gear");
        this.addCommand("too_many_modifiers", "This piece of Traveller's Gear already has the maximum amount of modifiers");
        this.addCommand("no_modifier", "%s is not applied to this piece of Traveller's Gear");
        this.addCommand("has_modifier", "This piece of Traveller's Gear already has %s");
        this.addCommand("wrong_modifier_slot", "%s is not allowed on this piece of Traveller's Gear");
        this.addCommand("ability_modifier", "Abilities cannot be added or removed from Traveller's Gear");
        this.addCommand("added_modifier", "Added %s to %s!");
        this.addCommand("removed_modifier", "Removed %s from %s!");
        this.addGameRule(TFGameRules.ENFORCED_PROGRESSION_RULE, "Twilight Forest: Enforced Progression");
        this.addGameRuleDescription(TFGameRules.ENFORCED_PROGRESSION_RULE, "Some Twilight Forest biomes are locked until you defeat certain bosses in the dimension. Check your advancements for the progression order.");
        this.addGameRule(TFGameRules.RULE_PLAYERS_TF_PORTAL_CREATIVE_DELAY, "Player's The Twilight Forest portal delay in creative mode");
        this.addGameRuleDescription(TFGameRules.RULE_PLAYERS_TF_PORTAL_CREATIVE_DELAY, "Time (in ticks) that a creative mode player needs to stand in The Twilight Forest portal before changing dimensions.");
        this.addGameRule(TFGameRules.RULE_PLAYERS_TF_PORTAL_DEFAULT_DELAY, "Player's The Twilight Forest portal delay in non-creative mode");
        this.addGameRuleDescription(TFGameRules.RULE_PLAYERS_TF_PORTAL_DEFAULT_DELAY, "Time (in ticks) that a non-creative mode player needs to stand in The Twilight Forest portal before changing dimensions.");
        this.add("effect.twilightforest.frosted", "Frosted");
        this.addEnchantment("chill_aura", "Chill Aura", "Adds a chance for the attacker to gain the frosted effect after hitting the wearer.");
        this.addEnchantment("fire_react", "Fire React", "Adds a chance for the attacker to be set on fire after hitting the wearer.");
        this.addEnchantment("destruction", "Destruction", "Allows the Block and Chain to break blocks with a higher mining tier.");
        this.addEnchantment("renewal", "Renewal", "Automatically recharges scepters when they run out if the holder has the recharge items in their inventory.");
        this.addAdvancement("root", "Twilight Forest", "Enter the mysterious, magical woodlands: the Twilight Forest");
        this.addAdvancement("kill_cicada", "Shut", "Kill a Cicada");
        this.addAdvancement("uncraft_uncrafting_table", "A Step too Far", "Uncraft an Uncrafting Table");
        this.addAdvancement("hedge", "Bug Stomper", "Defeat a spider in a Hedge Maze");
        this.addAdvancement("hill1", "The Boots Are Mine!", "Defeat a %s in a Small Hollow Hill");
        this.addAdvancement("hill2", "What Was That Noise?", "Defeat a %s in a Medium Hollow Hill");
        this.addAdvancement("hill3", "I See Right Through You", "Defeat a %s in a Large Hollow Hill");
        this.addAdvancement("quest_ram", "Consummate Baaahs", "Give the %s what it is missing");
        this.addAdvancement("magic_map_focus", "With Fire It Writes", "Craft the %s with a %s, %s, and %s");
        this.addAdvancement("magic_map", "I Can See Forever", "Craft the %s");
        this.addAdvancement("maze_map", "And Now, to Find the Exit", "Craft the %s after obtaining the focus from the labyrinth");
        this.addAdvancement("ore_map", "How Can That Be Worth It?", "Craft the %s");
        this.addAdvancement("twilight_hunter", "The Silence of the Forest", "Hunt some of the local wildlife");
        this.addAdvancement("kill_naga", "Time To Even The Scales", "Slay the %s in its forest courtyard and obtain a %s to overcome the barrier magic surrounding the Lich's tower");
        this.addAdvancement("naga_armors", "Naga Armorer", "Craft a %s and %s");
        this.addAdvancement("kill_lich", "Bring Out Your Dead", "Slay the %s at top of his tower and retrieve a scepter to clear poisonous mosquitoes from the Swamp, see through blinding darkness of the Dark Forest's curse, and resist the Snowy Forest's chill");
        this.addAdvancement("lich_scepters", "By Our Powers Combined!", "Acquire all four scepters of power");
        this.addAdvancement("full_mettle_alchemist", "Full Mettle Alchemist", "Drink three doses of Harming II from a potion flask in under 6 seconds and survive");
        this.addAdvancement("progress_labyrinth", "Mighty Stroganoff", "Eat the Meef Stroganoff to acclimatize your body to the dangerous heat of the Fire Swamp");
        this.addAdvancement("mazebreaker", "Breaking the Maze", "Find the %s pickaxe in the secret labyrinth vault");
        this.addAdvancement("kill_hydra", "Hydra Slayer", "Defeat the mighty %s and empower yourself");
        this.addAdvancement("hydra_chop", "Hydra Chop, Baby!", "Chow down on a %s when your hunger bar is depleted");
        this.addAdvancement("progress_trophy_pedestal", "Trophied Champion", "Claim your title by placing a trophy on the pedestal in the Dark Forest ruins");
        this.addAdvancement("progress_knights", "Carminite Acclimation", "Settle the restless phantoms in the knight's tomb and the carminite tower's devices will obey you");
        this.addAdvancement("ghast_trap", "Something Strange in Towerwood", "Slay the %ss around a %s and activate to wrench the %s from the sky!");
        this.addAdvancement("progress_ur_ghast", "Tears of Fire", "Touch the fiery red tears of the %s");
        this.addAdvancement("experiment_115", "Mystery Meat?", "It looks like cake, though...");
        this.addAdvancement("experiment_115_2", "Making a note: Huge Success!", "It's so delicious and moist!");
        this.addAdvancement("experiment_115_3", "Eating 115 Everyday, 115 Years, Forever", "eating experiment one-hundred-fifteen all day, forever, one-hundred-fifteen times experiment one-hundred-fifteen, experiment one-hundred-fifteen dot com, double-u double-u double-u dot experiment one-hundred-fifteen dot com, one-hundred-fifteen years, every minute experiment one-hundred-fifteen dot com, double-u double-u double-u dot one-hundred-fifteen times experiment one-hundred-fifteen dot com");
        this.addAdvancement("progress_yeti", "Alpha Fur", "Line your garments with the soft fur from the %s, keeping you safe from the Glacier's cold");
        this.addAdvancement("arctic_dyed", "Getting in Fashion", "Dye four unique pieces of Arctic armor");
        this.addAdvancement("progress_glacier", "Clear Skies", "Defeat the %s atop the Aurora Palace");
        this.addAdvancement("glass_sword", "One Hit Wonder", "Hope you made good use of that.");
        this.addAdvancement("fiery_set", "Gallons of Blood and Tears", "Wield a fiery tool or weapon while having at least one piece of fiery armor in your inventory");
        this.addAdvancement("progress_merge", "Ultimate Showdown", "Slay the %s, %s, and %s to clear the acid rain and embolden yourself for the Highlands");
        this.addAdvancement("troll", "We Do a Little Trolling", "Find and kill a %s");
        this.addAdvancement("beanstalk", "Jack and the Beanstalk", "Obtain some %s in the troll caves and use them on the glowing soil beneath the clouds");
        this.addAdvancement("giants", "I'm on Cloud Nine", "Kill a %s in the clouds, retrieve a %s, and return back to the troll caves");
        this.addAdvancement("progress_troll", "I Wish For More Burning", "Find the %s in the troll caves, and you can burn away the thorn barriers");
        this.addAdvancement("progression_end", "End of Progression", "Anything past this point in the Highlands is a work in progress. It will be finished in the future");
        this.addAdvancement("twilight_dining", "We Dine At Eternal Sundown", "Eat every edible item type exclusive to Twilight Forest");
        this.addAdvancement("arborist", "Maniacal Dendrologist", "Get your axes and shears ready. Search every nook and cranny and get anything and everything that comes from trees! Craft, loot, obtain every slab... sapling... leaves... more... everything. ALL OF IT!");
        this.add("advancement.twilightforest.chicken_jerky", "CHICKEN JERKEY!");
        this.addAdvancement("craft_travellers_gear", "Around the Forest in 80 Days", "Craft a piece of traveller's gear");
        this.addAdvancement("modify_travellers_gear", "Apparel Oft Proclaims the Man", "Add a modifier to a piece of traveller's gear");
        this.addMessage("advancement_hidden", "<Hidden Advancement>");
        this.addMessage("advancement_required", "Advancement Required:");
        this.addMessage("biome_locked", "Biome Locked!");
        this.addMessage("biome_locked_2", "Check your advancements");
        this.addMessage("core_disabled", "%s is disabled via config");
        this.addMessage("firefly_spawner_radius", "Firefly Particle Radius: %s Blocks");
        this.addMessage("magic_map_fail", "The Magic faltered. Perhaps it doesn't work here?");
        this.addMessage("ore_meter_separator", "-");
        this.addMessage("ore_meter_ratio", "(%s%%)");
        this.addMessage("ore_meter_header_block", "Block");
        this.addMessage("ore_meter_header_count", "Count");
        this.addMessage("ore_meter_header_ratio", "Ratio");
        this.addMessage("ore_meter_loading", "Loading");
        this.addMessage("ore_meter_new_range", "Range set to %s chunks");
        this.addMessage("ore_meter_no_blocks", "No blocks found nearby");
        this.addMessage("ore_meter_range", "Radius: %s, Origin: [%s, %s]");
        this.addMessage("ore_meter_set_block", "Targeted block set to %s");
        this.addMessage("ore_meter_targeted_block", "Targeted block: %s");
        this.addMessage("ore_meter_total", "Total blocks scanned: %s");
        this.addMessage("pedestal_ineligible", "You are unworthy.");
        this.addMessage("portal_unsafe", "It doesn't seem safe here...");
        this.addMessage("portal_unworthy", "The Portal pool is unresponsive. Perhaps something was neglected?");
        this.addMessage("wip", "This feature is a work in progress and may have bugs or unintended effects that may damage your world");
        this.addBlock((Supplier)TFBlocks.MASON_JAR, "Mason Jar");
        this.addBlock((Supplier)TFBlocks.CICADA, "Cicada");
        this.addBlock((Supplier)TFBlocks.CICADA_JAR, "Cicada Jar");
        this.addBlock((Supplier)TFBlocks.FIREFLY, "Firefly");
        this.addBlock((Supplier)TFBlocks.FIREFLY_JAR, "Firefly Jar");
        this.addBlock((Supplier)TFBlocks.MOONWORM, "Moonworm");
        this.addBlock((Supplier)TFBlocks.FIREFLY_SPAWNER, "Firefly Particle Spawner");
        this.addBlock((Supplier)TFBlocks.TWILIGHT_PORTAL, "Twilight Forest Portal");
        this.addBlock((Supplier)TFBlocks.TWILIGHT_PORTAL_MINIATURE_STRUCTURE, "Miniature Twilight Forest Portal");
        this.addBlock((Supplier)TFBlocks.NAGASTONE, "Nagastone");
        this.addBlock((Supplier)TFBlocks.NAGASTONE_HEAD, "Nagastone Head");
        this.addStoneVariants("etched_nagastone", "Etched Nagastone");
        this.addStoneVariants("nagastone_pillar", "Nagastone Pillar");
        this.addBlock((Supplier)TFBlocks.NAGASTONE_STAIRS_LEFT, "Nagastone Stairs (Left)");
        this.addBlock((Supplier)TFBlocks.NAGASTONE_STAIRS_RIGHT, "Nagastone Stairs (Right)");
        this.addBlock((Supplier)TFBlocks.CRACKED_NAGASTONE_STAIRS_LEFT, "Cracked Nagastone Stairs (Left)");
        this.addBlock((Supplier)TFBlocks.CRACKED_NAGASTONE_STAIRS_RIGHT, "Cracked Nagastone Stairs (Right)");
        this.addBlock((Supplier)TFBlocks.MOSSY_NAGASTONE_STAIRS_LEFT, "Mossy Nagastone Stairs (Left)");
        this.addBlock((Supplier)TFBlocks.MOSSY_NAGASTONE_STAIRS_RIGHT, "Mossy Nagastone Stairs (Right)");
        this.addBlock((Supplier)TFBlocks.SPIRAL_BRICKS, "Spiral Bricks");
        this.addBlock((Supplier)TFBlocks.NAGA_COURTYARD_MINIATURE_STRUCTURE, "Miniature Naga Courtyard");
        this.addBlock((Supplier)TFBlocks.TWISTED_STONE, "Twisted Stone");
        this.addBlock((Supplier)TFBlocks.TWISTED_STONE_PILLAR, "Twisted Stone Pillar");
        this.addBlock((Supplier)TFBlocks.BOLD_STONE_PILLAR, "Bold Stone Pillar");
        this.addBlock((Supplier)TFBlocks.CANDELABRA, "Candelabra");
        this.addBlock((Supplier)TFBlocks.WROUGHT_IRON_FENCE, "Wrought Iron Fence");
        this.add("block.twilightforest.wrought_iron_fence.cap", "Shift + right-click the same block to place finial");
        this.addBlock((Supplier)TFBlocks.TERRORCOTTA_ARCS, "Terrorcotta Arcs");
        this.addBlock((Supplier)TFBlocks.TERRORCOTTA_CURVES, "Terrorcotta Curves");
        this.addBlock((Supplier)TFBlocks.TERRORCOTTA_LINES, "Terrorcotta Lines");
        this.addBlock((Supplier)TFBlocks.CORONATION_CARPET, "Coronation Carpet");
        this.addBlock((Supplier)TFBlocks.SKULL_CHEST, "Skull Chest");
        this.addBlock((Supplier)TFBlocks.KEEPSAKE_CASKET, "Keepsake Casket");
        this.add("block.twilightforest.chipped_keepsake_casket", "Chipped Keepsake Casket");
        this.add("block.twilightforest.damaged_keepsake_casket", "Damaged Keepsake Casket");
        this.add("block.twilightforest.casket.locked", "This Casket can only be opened by %s!");
        this.addBlock((Supplier)TFBlocks.LICH_TOWER_MINIATURE_STRUCTURE, "Miniature Lich Tower");
        this.addBlock((Supplier)TFBlocks.HUGE_LILY_PAD, "Huge Lily Pad");
        this.addBlock((Supplier)TFBlocks.HUGE_WATER_LILY, "Huge Water Lily");
        this.addBlock((Supplier)TFBlocks.MAZESTONE, "Mazestone");
        this.addBlock((Supplier)TFBlocks.MAZESTONE_BRICK, "Mazestone Brick");
        this.addBlock((Supplier)TFBlocks.CRACKED_MAZESTONE, "Cracked Mazestone Brick");
        this.addBlock((Supplier)TFBlocks.MOSSY_MAZESTONE, "Mossy Mazestone Brick");
        this.addBlock((Supplier)TFBlocks.CUT_MAZESTONE, "Cut Mazestone");
        this.addBlock((Supplier)TFBlocks.DECORATIVE_MAZESTONE, "Decorative Mazestone Brick");
        this.addBlock((Supplier)TFBlocks.MAZESTONE_MOSAIC, "Mazestone Mosaic");
        this.addBlock((Supplier)TFBlocks.MAZESTONE_BORDER, "Mazestone Border");
        this.addBlock((Supplier)TFBlocks.RED_THREAD, "Red Thread");
        this.addBlock((Supplier)TFBlocks.MAZE_SLIME_BLOCK, "Maze Slime Block");
        this.addBlock((Supplier)TFBlocks.SMOKER, "Smoker");
        this.addBlock((Supplier)TFBlocks.FIRE_JET, "Fire Jet");
        this.addBlock((Supplier)TFBlocks.ENCASED_SMOKER, "Encased Smoker");
        this.addBlock((Supplier)TFBlocks.ENCASED_FIRE_JET, "Encased Fire Jet");
        this.addBlock((Supplier)TFBlocks.TROPHY_PEDESTAL, "Trophy Pedestal");
        this.addBlock((Supplier)TFBlocks.STRONGHOLD_SHIELD, "Stronghold Shield");
        this.addBlock((Supplier)TFBlocks.UNDERBRICK, "Underbrick");
        this.addBlock((Supplier)TFBlocks.CRACKED_UNDERBRICK, "Cracked Underbrick");
        this.addBlock((Supplier)TFBlocks.MOSSY_UNDERBRICK, "Mossy Underbrick");
        this.addBlock((Supplier)TFBlocks.UNDERBRICK_FLOOR, "Underbrick Floor");
        this.addBlock((Supplier)TFBlocks.TOWERWOOD, "Towerwood Planks");
        this.addBlock((Supplier)TFBlocks.CRACKED_TOWERWOOD, "Cracked Towerwood Planks");
        this.addBlock((Supplier)TFBlocks.MOSSY_TOWERWOOD, "Mossy Towerwood Planks");
        this.addBlock((Supplier)TFBlocks.INFESTED_TOWERWOOD, "Infested Towerwood Planks");
        this.addBlock((Supplier)TFBlocks.ENCASED_TOWERWOOD, "Encased Towerwood Planks");
        this.addBlock((Supplier)TFBlocks.UNBREAKABLE_VANISHING_BLOCK, "Vanishing Block");
        this.addBlock((Supplier)TFBlocks.VANISHING_BLOCK, "Vanishing Block");
        this.addBlock((Supplier)TFBlocks.REAPPEARING_BLOCK, "Reappearing Block");
        this.addBlock((Supplier)TFBlocks.LOCKED_VANISHING_BLOCK, "Locked Vanishing Block");
        this.addBlock((Supplier)TFBlocks.CARMINITE_BUILDER, "Carminite Builder");
        this.addBlock((Supplier)TFBlocks.BUILT_BLOCK, "Built Block");
        this.addBlock((Supplier)TFBlocks.ANTIBUILDER, "Antibuilder");
        this.addBlock((Supplier)TFBlocks.ANTIBUILT_BLOCK, "Antibuilt Block");
        this.addBlock((Supplier)TFBlocks.GHAST_TRAP, "Ghast Trap");
        this.addBlock((Supplier)TFBlocks.CARMINITE_REACTOR, "Carminite Reactor");
        this.addBlock((Supplier)TFBlocks.REACTOR_DEBRIS, "Reactor Debris");
        this.addBlock((Supplier)TFBlocks.FAKE_DIAMOND, "Diamond Block");
        this.addBlock((Supplier)TFBlocks.FAKE_GOLD, "Gold Block");
        this.addBlock((Supplier)TFBlocks.EXPERIMENT_115, "Experiment 115");
        this.addBlock((Supplier)TFBlocks.AURORA_BLOCK, "Aurora Block");
        this.addBlock((Supplier)TFBlocks.AURORA_SLAB, "Aurora Slab");
        this.addBlock((Supplier)TFBlocks.AURORA_PILLAR, "Aurora Pillar");
        this.addBlock((Supplier)TFBlocks.AURORALIZED_GLASS, "Auroralized Glass");
        this.addBlock((Supplier)TFBlocks.HUGE_MUSHGLOOM, "Huge Mushgloom Block");
        this.addBlock((Supplier)TFBlocks.HUGE_MUSHGLOOM_STEM, "Huge Mushgloom Stem");
        this.addBlock((Supplier)TFBlocks.HUGE_STALK, "Huge Stalk");
        this.addBlock((Supplier)TFBlocks.BEANSTALK_LEAVES, "Beanstalk Leaves");
        this.addBlock((Supplier)TFBlocks.UBEROUS_SOIL, "Uberous Soil");
        this.addBlock((Supplier)TFBlocks.TROLLVIDR, "Trollvidr");
        this.addBlock((Supplier)TFBlocks.UNRIPE_TROLLBER, "Unripe Trollber");
        this.addBlock((Supplier)TFBlocks.TROLLBER, "Trollber");
        this.addBlock((Supplier)TFBlocks.TROLLSTEINN, "Trollsteinn");
        this.addBlock((Supplier)TFBlocks.FLUFFY_CLOUD, "Fluffy Cloud");
        this.addBlock((Supplier)TFBlocks.RAINY_CLOUD, "Rainy Cloud");
        this.addBlock((Supplier)TFBlocks.SNOWY_CLOUD, "Snowy Cloud");
        this.addBlock((Supplier)TFBlocks.WISPY_CLOUD, "Wispy Cloud");
        this.addBlock((Supplier)TFBlocks.GIANT_LEAVES, "Giant Leaves");
        this.addBlock((Supplier)TFBlocks.GIANT_LOG, "Giant Log");
        this.addBlock((Supplier)TFBlocks.GIANT_COBBLESTONE, "Giant Cobblestone");
        this.addBlock((Supplier)TFBlocks.GIANT_OBSIDIAN, "Giant Obsidian");
        this.addBlock((Supplier)TFBlocks.BROWN_THORNS, "Thorns");
        this.addBlock((Supplier)TFBlocks.GREEN_THORNS, "Green Thorns");
        this.addBlock((Supplier)TFBlocks.BURNT_THORNS, "Burnt Thorns");
        this.addBlock((Supplier)TFBlocks.THORN_ROSE, "Thorn Rose");
        this.addBlock((Supplier)TFBlocks.THORN_LEAVES, "Thorn Leaves");
        this.addBlock((Supplier)TFBlocks.DEADROCK, "Deadrock");
        this.addBlock((Supplier)TFBlocks.CRACKED_DEADROCK, "Cracked Deadrock");
        this.addBlock((Supplier)TFBlocks.WEATHERED_DEADROCK, "Weathered Deadrock");
        this.addStoneVariants("castle_brick", "Castle Brick");
        this.addStoneVariants("castle_brick_stairs", "Castle Brick Stairs");
        this.add((Block)TFBlocks.WORN_CASTLE_BRICK.get(), "Worn Castle Brick");
        this.add((Block)TFBlocks.THICK_CASTLE_BRICK.get(), "Thick Castle Brick");
        this.add((Block)TFBlocks.CASTLE_ROOF_TILE.get(), "Castle Roof Tile");
        this.add((Block)TFBlocks.ENCASED_CASTLE_BRICK_PILLAR.get(), "Encased Castle Brick Pillar");
        this.add((Block)TFBlocks.ENCASED_CASTLE_BRICK_TILE.get(), "Encased Castle Brick Tile");
        this.add((Block)TFBlocks.BOLD_CASTLE_BRICK_PILLAR.get(), "Bold Castle Brick Pillar");
        this.add((Block)TFBlocks.BOLD_CASTLE_BRICK_TILE.get(), "Bold Castle Brick Tile");
        this.add((Block)TFBlocks.WORN_CASTLE_BRICK_STAIRS.get(), "Worn Castle Brick Stairs");
        this.add((Block)TFBlocks.ENCASED_CASTLE_BRICK_STAIRS.get(), "Encased Castle Brick Stairs");
        this.add((Block)TFBlocks.BOLD_CASTLE_BRICK_STAIRS.get(), "Bold Castle Brick Stairs");
        this.add((Block)TFBlocks.PINK_CASTLE_RUNE_BRICK.get(), "Magenta Castle Rune Brick");
        this.add((Block)TFBlocks.YELLOW_CASTLE_RUNE_BRICK.get(), "Yellow Castle Rune Brick");
        this.add((Block)TFBlocks.BLUE_CASTLE_RUNE_BRICK.get(), "Blue Castle Rune Brick");
        this.add((Block)TFBlocks.VIOLET_CASTLE_RUNE_BRICK.get(), "Violet Castle Rune Brick");
        this.add((Block)TFBlocks.PINK_CASTLE_DOOR.get(), "Magenta Castle Door");
        this.add((Block)TFBlocks.YELLOW_CASTLE_DOOR.get(), "Yellow Castle Door");
        this.add((Block)TFBlocks.BLUE_CASTLE_DOOR.get(), "Blue Castle Door");
        this.add((Block)TFBlocks.VIOLET_CASTLE_DOOR.get(), "Violet Castle Door");
        this.add((Block)TFBlocks.PINK_FORCE_FIELD.get(), "Magenta Force Field");
        this.add((Block)TFBlocks.ORANGE_FORCE_FIELD.get(), "Orange Force Field");
        this.add((Block)TFBlocks.GREEN_FORCE_FIELD.get(), "Green Force Field");
        this.add((Block)TFBlocks.BLUE_FORCE_FIELD.get(), "Blue Force Field");
        this.add((Block)TFBlocks.VIOLET_FORCE_FIELD.get(), "Violet Force Field");
        this.addBlock((Supplier)TFBlocks.IRONWOOD_BLOCK, "Block of Ironwood");
        this.addBlock((Supplier)TFBlocks.STEELEAF_BLOCK, "Block of Steeleaf");
        this.addBlock((Supplier)TFBlocks.KNIGHTMETAL_BLOCK, "Block of Knightmetal");
        this.add("block.twilightforest.knightmetal_block.desc", "Deals strong contact damage");
        this.addBlock((Supplier)TFBlocks.ARCTIC_FUR_BLOCK, "Block of Arctic Fur");
        this.add("block.twilightforest.arctic_fur_block.desc", "Reduces fall damage by 90%");
        this.addBlock((Supplier)TFBlocks.FIERY_BLOCK, "Block of Fiery Metal");
        this.addBlock((Supplier)TFBlocks.CARMINITE_BLOCK, "Block of Carminite");
        this.addBlock((Supplier)TFBlocks.CINDER_FURNACE, "Cinder Furnace");
        this.addBlock((Supplier)TFBlocks.CINDER_LOG, "Cinder Log");
        this.addBlock((Supplier)TFBlocks.CINDER_WOOD, "Cinder Wood");
        this.addBlock((Supplier)TFBlocks.IRON_LADDER, "Iron Ladder");
        this.addBlock((Supplier)TFBlocks.ROPE, "Rope");
        this.addBlock((Supplier)TFBlocks.CANOPY_WINDOW, "Canopy Window");
        this.addBlock((Supplier)TFBlocks.CANOPY_WINDOW_PANE, "Canopy Window Pane");
        this.addBlock((Supplier)TFBlocks.SLIDER, "Slide Trap");
        this.addBlock((Supplier)TFBlocks.BRAZIER, "Brazier");
        this.addBlock((Supplier)TFBlocks.IRON_OREBERRY, "Iron Oreberry Bush");
        this.addBlock((Supplier)TFBlocks.GOLD_OREBERRY, "Gold Oreberry Bush");
        this.addBlock((Supplier)TFBlocks.COPPER_OREBERRY, "Copper Oreberry Bush");
        this.addBlock((Supplier)TFBlocks.ESSENCE_OREBERRY, "Essence Berry Bush");
        this.addBlock((Supplier)TFBlocks.RASPBERRY_BUSH, "Raspberry Bush");
        this.addBlock((Supplier)TFBlocks.BLUEBERRY_BUSH, "Blueberry Bush");
        this.addBlock((Supplier)TFBlocks.BLACKBERRY_BUSH, "Blackberry Bush");
        this.addBlock((Supplier)TFBlocks.MALOBERRY_BUSH, "Maloberry Bush");
        this.addBlock((Supplier)TFBlocks.BLIGHTBERRY_BUSH, "Blightberry Bush");
        this.addBlock((Supplier)TFBlocks.DUSKBERRY_BUSH, "Duskberry Bush");
        this.addBlock((Supplier)TFBlocks.SKYBERRY_BUSH, "Skyberry Bush");
        this.addBlock((Supplier)TFBlocks.STINGBERRY_BUSH, "Stingberry Bush");
        this.addBlock((Supplier)TFBlocks.TWILIGHT_OAK_LEAVES, "Twilight Oak Leaves");
        this.addSapling("twilight_oak", "Sickly Twilight Oak Sapling");
        this.createLogs("twilight_oak", "Twilight Oak");
        this.createWoodSet("twilight_oak", "Twilight Oak");
        this.addBlock((Supplier)TFBlocks.CANOPY_LEAVES, "Canopy Tree Leaves");
        this.addSapling("canopy", "Canopy Tree Sapling");
        this.createLogs("canopy", "Canopy Tree");
        this.createWoodSet("canopy", "Canopy");
        this.addBlock((Supplier)TFBlocks.CANOPY_BOOKSHELF, "Canopy Bookshelf");
        this.addBlock((Supplier)TFBlocks.CHISELED_CANOPY_BOOKSHELF, "Chiseled Canopy Bookshelf");
        this.addBlock((Supplier)TFBlocks.MANGROVE_LEAVES, "Mangrove Leaves");
        this.addSapling("mangrove", "Mangrove Sapling");
        this.createLogs("mangrove", "Mangrove");
        this.createWoodSet("mangrove", "Mangrove");
        this.addBlock((Supplier)TFBlocks.DARK_LEAVES, "Darkwood Leaves");
        this.addBlock((Supplier)TFBlocks.HARDENED_DARK_LEAVES, "Thick Darkwood Leaves");
        this.addSapling("darkwood", "Darkwood Sapling");
        this.createLogs("dark", "Darkwood");
        this.createWoodSet("dark", "Darkwood");
        this.addBlock((Supplier)TFBlocks.TIME_LOG_CORE, "Timewood Clock");
        this.addBlock((Supplier)TFBlocks.TIME_LEAVES, "Timewood Leaves");
        this.addSapling("time", "Tree of Time Sapling");
        this.createLogs("time", "Timewood");
        this.createWoodSet("time", "Timewood");
        this.addBlock((Supplier)TFBlocks.TRANSFORMATION_LOG_CORE, "Heart of Transformation");
        this.addBlock((Supplier)TFBlocks.TRANSFORMATION_LEAVES, "Leaves of Transformation");
        this.addSapling("transformation", "Tree of Transformation Sapling");
        this.createLogs("transformation", "Transwood");
        this.createWoodSet("transformation", "Transwood");
        this.addBlock((Supplier)TFBlocks.MINING_LOG_CORE, "Minewood Core");
        this.addBlock((Supplier)TFBlocks.MINING_LEAVES, "Miner's Leaves");
        this.addSapling("mining", "Miner's Tree Sapling");
        this.createLogs("mining", "Minewood");
        this.createWoodSet("mining", "Minewood");
        this.addBlock((Supplier)TFBlocks.SORTING_LOG_CORE, "Sortingwood Engine");
        this.addBlock((Supplier)TFBlocks.SORTING_LEAVES, "Sorting Leaves");
        this.addSapling("sorting", "Sorting Tree Sapling");
        this.createLogs("sorting", "Sortingwood");
        this.createWoodSet("sorting", "Sortingwood");
        this.addBlock((Supplier)TFBlocks.RAINBOW_OAK_LEAVES, "Rainbow Oak Leaves");
        this.addSapling("rainbow_oak", "Rainbow Oak Sapling");
        this.addSapling("hollow_oak", "Robust Twilight Oak Sapling");
        this.addBlock((Supplier)TFBlocks.OAK_BANISTER, "Oak Banister");
        this.addBlock((Supplier)TFBlocks.SPRUCE_BANISTER, "Spruce Banister");
        this.addBlock((Supplier)TFBlocks.BIRCH_BANISTER, "Birch Banister");
        this.addBlock((Supplier)TFBlocks.JUNGLE_BANISTER, "Jungle Banister");
        this.addBlock((Supplier)TFBlocks.ACACIA_BANISTER, "Acacia Banister");
        this.addBlock((Supplier)TFBlocks.DARK_OAK_BANISTER, "Dark Oak Banister");
        this.addBlock((Supplier)TFBlocks.CRIMSON_BANISTER, "Crimson Banister");
        this.addBlock((Supplier)TFBlocks.WARPED_BANISTER, "Warped Banister");
        this.addBlock((Supplier)TFBlocks.VANGROVE_BANISTER, "Mangrove Banister");
        this.addBlock((Supplier)TFBlocks.BAMBOO_BANISTER, "Bamboo Banister");
        this.addBlock((Supplier)TFBlocks.CHERRY_BANISTER, "Cherry Banister");
        this.addBlock((Supplier)TFBlocks.OAK_DRYING_RACK, "Oak Drying Rack");
        this.addBlock((Supplier)TFBlocks.SPRUCE_DRYING_RACK, "Spruce Drying Rack");
        this.addBlock((Supplier)TFBlocks.BIRCH_DRYING_RACK, "Birch Drying Rack");
        this.addBlock((Supplier)TFBlocks.JUNGLE_DRYING_RACK, "Jungle Drying Rack");
        this.addBlock((Supplier)TFBlocks.ACACIA_DRYING_RACK, "Acacia Drying Rack");
        this.addBlock((Supplier)TFBlocks.DARK_OAK_DRYING_RACK, "Dark Oak Drying Rack");
        this.addBlock((Supplier)TFBlocks.CRIMSON_DRYING_RACK, "Crimson Drying Rack");
        this.addBlock((Supplier)TFBlocks.WARPED_DRYING_RACK, "Warped Drying Rack");
        this.addBlock((Supplier)TFBlocks.VANGROVE_DRYING_RACK, "Mangrove Drying Rack");
        this.addBlock((Supplier)TFBlocks.BAMBOO_DRYING_RACK, "Bamboo Drying Rack");
        this.addBlock((Supplier)TFBlocks.CHERRY_DRYING_RACK, "Cherry Drying Rack");
        this.createHollowLogs("oak", "Oak", false);
        this.createHollowLogs("spruce", "Spruce", false);
        this.createHollowLogs("birch", "Birch", false);
        this.createHollowLogs("jungle", "Jungle", false);
        this.createHollowLogs("acacia", "Acacia", false);
        this.createHollowLogs("dark_oak", "Dark Oak", false);
        this.createHollowLogs("crimson", "Crimson", true);
        this.createHollowLogs("warped", "Warped", true);
        this.createHollowLogs("vangrove", "Mangrove", false);
        this.createHollowLogs("cherry", "Cherry", false);
        this.add("block.twilightforest.banister.cycle", "Right-click with axe to cycle");
        this.addBlock((Supplier)TFBlocks.MOSS_PATCH, "Moss Patch");
        this.addBlock((Supplier)TFBlocks.CLOVER_PATCH, "Clover Patch");
        this.addBlock((Supplier)TFBlocks.TORCHBERRY_PLANT, "Torchberry Plant");
        this.addBlock((Supplier)TFBlocks.ROOT_STRAND, "Root Strands");
        this.addBlock((Supplier)TFBlocks.FALLEN_LEAVES, "Fallen Leaves");
        this.addBlock((Supplier)TFBlocks.MAYAPPLE, "Mayapple");
        this.addBlock((Supplier)TFBlocks.POTTED_MAYAPPLE, "Potted Mayapple");
        this.addBlock((Supplier)TFBlocks.FIDDLEHEAD, "Fiddlehead Fern");
        this.addBlock((Supplier)TFBlocks.POTTED_FIDDLEHEAD, "Potted Fiddlehead");
        this.addBlock((Supplier)TFBlocks.MUSHGLOOM, "Mushgloom");
        this.addBlock((Supplier)TFBlocks.POTTED_MUSHGLOOM, "Potted Mushgloom");
        this.addBlock((Supplier)TFBlocks.POTTED_THORN, "Potted Thorn");
        this.addBlock((Supplier)TFBlocks.POTTED_GREEN_THORN, "Potted Green Thorn");
        this.addBlock((Supplier)TFBlocks.POTTED_DEAD_THORN, "Potted Burnt Thorn");
        this.addBlock((Supplier)TFBlocks.HEDGE, "Hedge");
        this.addBlock((Supplier)TFBlocks.ROOT_BLOCK, "Roots");
        this.addBlock((Supplier)TFBlocks.LIVEROOT_BLOCK, "Liveroots");
        this.addBlock((Supplier)TFBlocks.MANGROVE_ROOT, "Mangrove Roots");
        this.addBlock((Supplier)TFBlocks.NAGA_TROPHY, "Naga Trophy");
        this.addBlock((Supplier)TFBlocks.LICH_TROPHY, "Twilight Lich Trophy");
        this.addBlock((Supplier)TFBlocks.MINOSHROOM_TROPHY, "Minoshroom Trophy");
        this.addBlock((Supplier)TFBlocks.HYDRA_TROPHY, "Hydra Trophy");
        this.addBlock((Supplier)TFBlocks.KNIGHT_PHANTOM_TROPHY, "Knight Phantom Trophy");
        this.addBlock((Supplier)TFBlocks.UR_GHAST_TROPHY, "Ur-Ghast Trophy");
        this.addBlock((Supplier)TFBlocks.ALPHA_YETI_TROPHY, "Alpha Yeti Trophy");
        this.addBlock((Supplier)TFBlocks.SNOW_QUEEN_TROPHY, "Snow Queen Trophy");
        this.addBlock((Supplier)TFBlocks.QUEST_RAM_TROPHY, "Questing Ram Trophy");
        this.addBlock((Supplier)TFBlocks.NAGA_BOSS_SPAWNER, "Naga Boss Spawner");
        this.addBlock((Supplier)TFBlocks.LICH_BOSS_SPAWNER, "Lich Boss Spawner");
        this.addBlock((Supplier)TFBlocks.MINOSHROOM_BOSS_SPAWNER, "Minoshroom Boss Spawner");
        this.addBlock((Supplier)TFBlocks.HYDRA_BOSS_SPAWNER, "Hydra Boss Spawner");
        this.addBlock((Supplier)TFBlocks.KNIGHT_PHANTOM_BOSS_SPAWNER, "Knight Phantoms Boss Spawner");
        this.addBlock((Supplier)TFBlocks.UR_GHAST_BOSS_SPAWNER, "Ur-Ghast Boss Spawner");
        this.addBlock((Supplier)TFBlocks.ALPHA_YETI_BOSS_SPAWNER, "Alpha Yeti Boss Spawner");
        this.addBlock((Supplier)TFBlocks.SNOW_QUEEN_BOSS_SPAWNER, "Snow Queen Boss Spawner");
        this.addBlock((Supplier)TFBlocks.FINAL_BOSS_BOSS_SPAWNER, "Final Boss Boss Spawner");
        this.addBannerPattern("naga", "Naga Scales");
        this.addBannerPattern("lich", "Lich Crown");
        this.addBannerPattern("minoshroom", "Minoshroom Axes");
        this.addBannerPattern("hydra", "Hydra Flame");
        this.addBannerPattern("knight_phantom", "Knight Helmet");
        this.addBannerPattern("ur_ghast", "Carminite Border");
        this.addBannerPattern("alpha_yeti", "Alpha Yeti Face");
        this.addBannerPattern("snow_queen", "Snowflake");
        this.addBannerPattern("quest_ram", "Questing Ram Swirls");
        this.addBlock((Supplier)TFBlocks.ZOMBIE_SKULL_CANDLE, "Zombie Skull Candle");
        this.addBlock((Supplier)TFBlocks.ZOMBIE_WALL_SKULL_CANDLE, "Zombie Wall Skull Candle");
        this.addBlock((Supplier)TFBlocks.SKELETON_SKULL_CANDLE, "Skeleton Skull Candle");
        this.addBlock((Supplier)TFBlocks.SKELETON_WALL_SKULL_CANDLE, "Skeleton Wall Skull Candle");
        this.addBlock((Supplier)TFBlocks.WITHER_SKELE_SKULL_CANDLE, "Wither Skeleton Skull Candle");
        this.addBlock((Supplier)TFBlocks.WITHER_SKELE_WALL_SKULL_CANDLE, "Wither Skeleton Wall Skull Candle");
        this.addBlock((Supplier)TFBlocks.CREEPER_SKULL_CANDLE, "Creeper Skull Candle");
        this.addBlock((Supplier)TFBlocks.CREEPER_WALL_SKULL_CANDLE, "Creeper Wall Skull Candle");
        this.addBlock((Supplier)TFBlocks.PLAYER_SKULL_CANDLE, "Player Skull Candle");
        this.add("block.twilightforest.player_skull_candle.named", "%s's Head with Candles");
        this.addBlock((Supplier)TFBlocks.PLAYER_WALL_SKULL_CANDLE, "Player Wall Skull Candle");
        this.addBlock((Supplier)TFBlocks.PIGLIN_SKULL_CANDLE, "Piglin Skull Candle");
        this.addBlock((Supplier)TFBlocks.PIGLIN_WALL_SKULL_CANDLE, "Piglin Wall Skull Candle");
        this.addBlock((Supplier)TFBlocks.UNCRAFTING_TABLE, "Uncrafting Table");
        this.add("block.twilightforest.uncrafting_table.disabled", "This block has been disabled.");
        this.add("container.twilightforest.uncrafting_table", "Uncrafting Table");
        this.add("container.twilightforest.uncrafting_table.disabled_item", "Uncrafting this item is disabled.");
        this.add("container.twilightforest.uncrafting_table.uncrafting_disabled", "Uncrafting is disabled via config");
        this.add("container.twilightforest.uncrafting_table.cycle_next_recipe", "Next Crafting Recipe");
        this.add("container.twilightforest.uncrafting_table.cycle_back_recipe", "Previous Crafting Recipe");
        this.add("container.twilightforest.uncrafting_table.cycle_next_ingredient", "Next Uncrafting Ingredients");
        this.add("container.twilightforest.uncrafting_table.cycle_back_ingredient", "Previous Uncrafting Ingredients");
        this.add("container.twilightforest.uncrafting_table.cycle_next_uncraft", "Next Uncrafting Recipe");
        this.add("container.twilightforest.uncrafting_table.cycle_back_uncraft", "Previous Uncrafting Recipe");
        this.addBlock((Supplier)TFBlocks.SINISTER_SPAWNER, "Sinister Spawner");
        this.add("item.twilightforest.boarkchop", "Raw Boarkchop");
        this.addItem((Supplier)TFItems.NAGA_SCALE, "Naga Scale");
        this.addItem((Supplier)TFItems.NAGA_CHESTPLATE, "Naga Scale Tunic");
        this.addItem((Supplier)TFItems.NAGA_LEGGINGS, "Naga Scale Leggings");
        this.addItem((Supplier)TFItems.FORTIFICATION_SCEPTER, "Scepter of Fortification");
        this.addItem((Supplier)TFItems.LIFEDRAIN_SCEPTER, "Scepter of Life Draining");
        this.addItem((Supplier)TFItems.TWILIGHT_SCEPTER, "Scepter of Twilight");
        this.addItem((Supplier)TFItems.ZOMBIE_SCEPTER, "Zombie Scepter");
        this.add("item.twilightforest.scepter.desc", "%s charges left");
        this.addItem((Supplier)TFItems.EXANIMATE_ESSENCE, "Exanimate Essence");
        this.addBlock((Supplier)TFBlocks.OMINOUS_FIRE, "Ominous Fire");
        this.addBlock((Supplier)TFBlocks.OMINOUS_CANDLE, "Ominous Candle");
        this.addBlock((Supplier)TFBlocks.OMINOUS_WHITE_CANDLE, "Ominous White Candle");
        this.addBlock((Supplier)TFBlocks.OMINOUS_ORANGE_CANDLE, "Ominous Orange Candle");
        this.addBlock((Supplier)TFBlocks.OMINOUS_MAGENTA_CANDLE, "Ominous Magenta Candle");
        this.addBlock((Supplier)TFBlocks.OMINOUS_LIGHT_BLUE_CANDLE, "Ominous Light Blue Candle");
        this.addBlock((Supplier)TFBlocks.OMINOUS_YELLOW_CANDLE, "Ominous Yellow Candle");
        this.addBlock((Supplier)TFBlocks.OMINOUS_LIME_CANDLE, "Ominous Lime Candle");
        this.addBlock((Supplier)TFBlocks.OMINOUS_PINK_CANDLE, "Ominous Pink Candle");
        this.addBlock((Supplier)TFBlocks.OMINOUS_GRAY_CANDLE, "Ominous Gray Candle");
        this.addBlock((Supplier)TFBlocks.OMINOUS_LIGHT_GRAY_CANDLE, "Ominous Light Gray Candle");
        this.addBlock((Supplier)TFBlocks.OMINOUS_CYAN_CANDLE, "Ominous Cyan Candle");
        this.addBlock((Supplier)TFBlocks.OMINOUS_PURPLE_CANDLE, "Ominous Purple Candle");
        this.addBlock((Supplier)TFBlocks.OMINOUS_BLUE_CANDLE, "Ominous Blue Candle");
        this.addBlock((Supplier)TFBlocks.OMINOUS_BROWN_CANDLE, "Ominous Brown Candle");
        this.addBlock((Supplier)TFBlocks.OMINOUS_GREEN_CANDLE, "Ominous Green Candle");
        this.addBlock((Supplier)TFBlocks.OMINOUS_RED_CANDLE, "Ominous Red Candle");
        this.addBlock((Supplier)TFBlocks.OMINOUS_BLACK_CANDLE, "Ominous Black Candle");
        this.addItem((Supplier)TFItems.WROUGHT_IRON_BAR, "Wrought Iron Bar");
        this.addItem((Supplier)TFItems.BRITTLE_FLASK, "Brittle Potion Flask");
        this.addItem((Supplier)TFItems.GREATER_FLASK, "Greater Potion Flask");
        this.add("item.twilightforest.flask.empty", "Empty");
        this.add("item.twilightforest.flask.empty_description", "Can hold multiple potion doses");
        this.add("item.twilightforest.flask.no_refill", "Cannot be refilled");
        this.addItem((Supplier)TFItems.MAGIC_PAINTING, "Magic Painting");
        this.addItem((Supplier)TFItems.ORE_METER, "Ore Meter");
        this.addItem((Supplier)TFItems.FILLED_MAGIC_MAP, "Magic Map");
        this.addItem((Supplier)TFItems.FILLED_MAZE_MAP, "Maze Map");
        this.add("item.twilightforest.maze_map.y_level", "Y level %s");
        this.addItem((Supplier)TFItems.FILLED_ORE_MAP, "Maze/Ore Map");
        this.addItem((Supplier)TFItems.MAGIC_MAP, "Blank Magic Map");
        this.addItem((Supplier)TFItems.MAZE_MAP, "Blank Maze Map");
        this.addItem((Supplier)TFItems.ORE_MAP, "Blank Maze/Ore Map");
        this.addItem((Supplier)TFItems.RAVEN_FEATHER, "Raven Feather");
        this.addItem((Supplier)TFItems.MAGIC_MAP_FOCUS, "Magic Map Focus");
        this.addItem((Supplier)TFItems.MAZE_MAP_FOCUS, "Maze Map Focus");
        this.addItem((Supplier)TFItems.MAZE_SLIME_BALL, "Maze Slimeball");
        this.addItem((Supplier)TFItems.LIVEROOT, "Liveroot");
        this.addItem((Supplier)TFItems.RAW_IRONWOOD, "Raw Ironwood");
        this.addItem((Supplier)TFItems.IRONWOOD_INGOT, "Ironwood Ingot");
        this.addArmor("ironwood", "Ironwood");
        this.addTools("ironwood", "Ironwood");
        this.addItem((Supplier)TFItems.STEELEAF_INGOT, "Steeleaf");
        this.addArmor("steeleaf", "Steeleaf");
        this.addTools("steeleaf", "Steeleaf");
        this.addItem((Supplier)TFItems.ARMOR_SHARD, "Armor Shard");
        this.addItem((Supplier)TFItems.ARMOR_SHARD_CLUSTER, "Armor Shard Cluster");
        this.addItem((Supplier)TFItems.KNIGHTMETAL_INGOT, "Knightmetal Ingot");
        this.addItem((Supplier)TFItems.KNIGHTMETAL_HELMET, "Knightmetal Helmet");
        this.addItem((Supplier)TFItems.KNIGHTMETAL_CHESTPLATE, "Knightmetal Chestplate");
        this.addItem((Supplier)TFItems.KNIGHTMETAL_LEGGINGS, "Knightmetal Greaves");
        this.addItem((Supplier)TFItems.KNIGHTMETAL_BOOTS, "Knightmetal Boots");
        this.addItem((Supplier)TFItems.KNIGHTMETAL_SWORD, "Knightmetal Sword");
        this.add("item.twilightforest.knightmetal_sword.desc", "Extra damage to armored targets");
        this.addItem((Supplier)TFItems.KNIGHTMETAL_PICKAXE, "Knightmetal Pickaxe");
        this.add("item.twilightforest.knightmetal_pickaxe.desc", "Extra damage to armored targets");
        this.addItem((Supplier)TFItems.KNIGHTMETAL_AXE, "Knightmetal Axe");
        this.add("item.twilightforest.knightmetal_axe.desc", "Extra damage to unarmored targets");
        this.addItem((Supplier)TFItems.KNIGHTMETAL_RING, "Knightmetal Loop");
        this.addItem((Supplier)TFItems.KNIGHTMETAL_SHIELD, "Knightmetal Shield");
        this.addItem((Supplier)TFItems.BLOCK_AND_CHAIN, "Block and Chain");
        this.addItem((Supplier)TFItems.PHANTOM_HELMET, "Phantom Helmet");
        this.addItem((Supplier)TFItems.PHANTOM_CHESTPLATE, "Phantom Chestplate");
        this.add("item.twilightforest.phantom_armor.desc", "Is never lost on death");
        this.addItem((Supplier)TFItems.TANNIN, "Tannin");
        this.addItem((Supplier)TFItems.FIERY_BLOOD, "Fiery Blood");
        this.addItem((Supplier)TFItems.FIERY_TEARS, "Fiery Tears");
        this.addItem((Supplier)TFItems.FIERY_INGOT, "Fiery Ingot");
        this.addArmor("fiery", "Fiery");
        this.add("item.twilightforest.fiery_armor.desc", "Burns attackers");
        this.addItem((Supplier)TFItems.FIERY_SWORD, "Fiery Sword");
        this.add("item.twilightforest.fiery_sword.desc", "Burns targets");
        this.addItem((Supplier)TFItems.FIERY_PICKAXE, "Fiery Pickaxe");
        this.add("item.twilightforest.fiery_pickaxe.desc", "Auto-smelting");
        this.addItem((Supplier)TFItems.ARCTIC_FUR, "Arctic Fur");
        this.addItem((Supplier)TFItems.ARCTIC_HELMET, "Arctic Hood");
        this.addItem((Supplier)TFItems.ARCTIC_CHESTPLATE, "Arctic Jacket");
        this.addItem((Supplier)TFItems.ARCTIC_LEGGINGS, "Arctic Leggings");
        this.addItem((Supplier)TFItems.ARCTIC_BOOTS, "Arctic Boots");
        this.add("item.twilightforest.arctic_armor.desc", "Dyeable");
        this.addItem((Supplier)TFItems.ALPHA_YETI_FUR, "Alpha Yeti Fur");
        this.addItem((Supplier)TFItems.YETI_HELMET, "Yeti Horned Helm");
        this.addItem((Supplier)TFItems.YETI_CHESTPLATE, "Yeti Jacket");
        this.addItem((Supplier)TFItems.YETI_LEGGINGS, "Yeti Leggings");
        this.addItem((Supplier)TFItems.YETI_BOOTS, "Yeti Boots");
        this.add("item.twilightforest.yeti_armor.desc", "Chills attackers");
        this.addItem((Supplier)TFItems.DIAMOND_MINOTAUR_AXE, "Diamond Minotaur Axe");
        this.addItem((Supplier)TFItems.GOLDEN_MINOTAUR_AXE, "Golden Minotaur Axe");
        this.add("item.twilightforest.minotaur_axe.desc", "Extra damage while charging");
        this.addItem((Supplier)TFItems.MAZEBREAKER_PICKAXE, "Mazebreaker");
        this.addItem((Supplier)TFItems.ICE_SWORD, "Ice Sword");
        this.addItem((Supplier)TFItems.ICE_BOMB, "Ice Bomb");
        this.addItem((Supplier)TFItems.GLASS_SWORD, "Glass Sword");
        this.add("item.twilightforest.glass_sword.desc", "Creative Mode-only");
        this.addItem((Supplier)TFItems.TRIPLE_BOW, "Tri-Bow");
        this.addItem((Supplier)TFItems.SEEKER_BOW, "Seeker Bow");
        this.addItem((Supplier)TFItems.ICE_BOW, "Ice Bow");
        this.addItem((Supplier)TFItems.ENDER_BOW, "Ender Bow");
        this.addItem((Supplier)TFItems.GIANT_SWORD, "Giant's Sword");
        this.addItem((Supplier)TFItems.GIANT_PICKAXE, "Giant's Pickaxe");
        this.add("item.twilightforest.giant_pickaxe.desc", "Breaks giant blocks");
        this.addItem((Supplier)TFItems.LAMP_OF_CINDERS, "Lamp of Cinders");
        this.addItem((Supplier)TFItems.CUBE_OF_ANNIHILATION, "Cube of Annihilation");
        this.addItem((Supplier)TFItems.TRAVELLERS_GOGGLES, "Traveller's Goggles");
        this.addItem((Supplier)TFItems.TRAVELLERS_VEST, "Traveller's Vest");
        this.addItem((Supplier)TFItems.TRAVELLERS_GLOVES, "Traveller's Gloves");
        this.addItem((Supplier)TFItems.TRAVELLERS_BELT, "Traveller's Belt");
        this.addItem((Supplier)TFItems.TRAVELLERS_WINGS, "Traveller's Wings");
        this.addItem((Supplier)TFItems.TRAVELLERS_BOOTS, "Traveller's Boots");
        this.addItem((Supplier)TFItems.MOON_DIAL, "Moon Dial");
        this.add("item.twilightforest.moon_dial.phase_0", "Full Moon");
        this.add("item.twilightforest.moon_dial.phase_1", "Waning Gibbous");
        this.add("item.twilightforest.moon_dial.phase_2", "Third Quarter");
        this.add("item.twilightforest.moon_dial.phase_3", "Waning Crescent");
        this.add("item.twilightforest.moon_dial.phase_4", "New Moon");
        this.add("item.twilightforest.moon_dial.phase_5", "Waxing Crescent");
        this.add("item.twilightforest.moon_dial.phase_6", "First Quarter");
        this.add("item.twilightforest.moon_dial.phase_7", "Waxing Gibbous");
        this.add("item.twilightforest.moon_dial.phase_unknown", "Moon phase indeterminate");
        this.add("item.twilightforest.moon_dial.phase_unknown_fools", "404 moon not found");
        this.addItem((Supplier)TFItems.POCKET_WATCH, "Rabbit's Pocket Watch");
        this.add("item.twilightforest.pocket_watch.desc", "It seems to always be running late");
        this.addItem((Supplier)TFItems.EMPERORS_CLOTH, "Emperor's Cloth");
        this.add("item.twilightforest.emperors_cloth.desc", "Shrouded");
        this.addItem((Supplier)TFItems.FOUR_LEAF_CLOVER, "Four-Leaf Clover");
        this.addItem((Supplier)TFItems.CROWN_SPLINTER, "Crown Splinter");
        this.addItem((Supplier)TFItems.MYSTIC_CROWN, "Mystic Crown");
        this.addItem((Supplier)TFItems.ORE_MAGNET, "Ore Magnet");
        this.addItem((Supplier)TFItems.CRUMBLE_HORN, "Crumble Horn");
        this.addItem((Supplier)TFItems.MOONWORM_QUEEN, "Moonworm Queen");
        this.addItem((Supplier)TFItems.PEACOCK_FEATHER_FAN, "Peacock Feather Fan");
        this.addItem((Supplier)TFItems.TRANSFORMATION_POWDER, "Transformation Powder");
        this.addItem((Supplier)TFItems.TOWER_KEY, "Tower Key");
        this.addItem((Supplier)TFItems.BORER_ESSENCE, "Borer Essence");
        this.addItem((Supplier)TFItems.CARMINITE, "Carminite");
        this.addItem((Supplier)TFItems.MAGIC_BEANS, "Magic Beans");
        this.addItem((Supplier)TFItems.CUBE_TALISMAN, "Talisman of the Cube");
        this.add("item.twilightforest.skull_candle.desc", "Has: %s %s Candle");
        this.add("item.twilightforest.skull_candle.desc.multiple", "Has: %s %s Candles");
        this.addItem((Supplier)TFItems.TORCHBERRIES, "Torchberries");
        this.addItem((Supplier)TFItems.RASPBERRY, "Raspberry");
        this.addItem((Supplier)TFItems.BLUEBERRY, "Blueberry");
        this.addItem((Supplier)TFItems.BLACKBERRY, "Blackberry");
        this.addItem((Supplier)TFItems.MALOBERRY, "Maloberry");
        this.addItem((Supplier)TFItems.BLIGHTBERRY, "Blightberry");
        this.addItem((Supplier)TFItems.DUSKBERRY, "Duskberry");
        this.addItem((Supplier)TFItems.SKYBERRY, "Skyberry");
        this.addItem((Supplier)TFItems.STINGBERRY, "Stingberry");
        this.addItem((Supplier)TFItems.BERRY_MEDLEY, "Berry Medley");
        this.addItem((Supplier)TFItems.RAW_VENISON, "Raw Venison");
        this.addItem((Supplier)TFItems.COOKED_VENISON, "Venison Steak");
        this.addItem((Supplier)TFItems.MAZE_WAFER, "Maze Wafer");
        this.addItem((Supplier)TFItems.RAW_MEEF, "Raw Meef");
        this.addItem((Supplier)TFItems.COOKED_MEEF, "Meef Steak");
        this.addItem((Supplier)TFItems.MEEF_STROGANOFF, "Meef Stroganoff");
        this.addItem((Supplier)TFItems.HYDRA_CHOP, "Hydra Chop");
        this.addItem((Supplier)TFItems.MOSS_SOUP, "Moss Soup");
        this.addItem((Supplier)TFItems.MONSTER_JERKY, "Monster Jerky");
        this.addItem((Supplier)TFItems.BEEF_JERKY, "Beef Jerky");
        this.addItem((Supplier)TFItems.CHICKEN_JERKY, "Chicken Jerky");
        this.addItem((Supplier)TFItems.PORK_JERKY, "Pork Jerky");
        this.addItem((Supplier)TFItems.MUTTON_JERKY, "Mutton Jerky");
        this.addItem((Supplier)TFItems.RABBIT_JERKY, "Rabbit Jerky");
        this.addItem((Supplier)TFItems.COD_JERKY, "Cod Jerky");
        this.addItem((Supplier)TFItems.SALMON_JERKY, "Salmon Jerky");
        this.addItem((Supplier)TFItems.TROPICAL_FISH_JERKY, "Tropical Fish Jerky");
        this.addItem((Supplier)TFItems.FUGU_JERKY, "Fugu Jerky");
        this.addItem((Supplier)TFItems.VENISON_JERKY, "Venison Jerky");
        this.addItem((Supplier)TFItems.MEEF_JERKY, "Meef Jerky");
        this.addItem((Supplier)TFItems.GELATINOUS_SLIME_DROP, "Gelatinous Slime Drop");
        this.addItem((Supplier)TFItems.GELATINOUS_MAZE_SLIME_DROP, "Gelatinous Maze Slime Drop");
        this.addItem((Supplier)TFItems.TREATED_LEATHER, "Treated Leather");
        this.addItem((Supplier)TFItems.TANNED_LEATHER, "Tanned Leather");
        this.addItem((Supplier)TFItems.STALE_BREAD, "Stale Bread");
        this.addItem((Supplier)TFItems.COPPER_NUGGET, "Copper Nugget");
        this.addItem((Supplier)TFItems.IRON_BERRY, "Iron Oreberry");
        this.addItem((Supplier)TFItems.GOLD_BERRY, "Gold Oreberry");
        this.addItem((Supplier)TFItems.COPPER_BERRY, "Copper Oreberry");
        this.addItem((Supplier)TFItems.ESSENCE_BERRY, "Concentrated Essence Berry");
        this.addItem((Supplier)TFItems.CHARM_OF_LIFE_1, "Charm of Life I");
        this.addItem((Supplier)TFItems.CHARM_OF_LIFE_2, "Charm of Life II");
        this.addItem((Supplier)TFItems.CHARM_OF_KEEPING_1, "Charm of Keeping I");
        this.addItem((Supplier)TFItems.CHARM_OF_KEEPING_2, "Charm of Keeping II");
        this.addItem((Supplier)TFItems.CHARM_OF_KEEPING_3, "Charm of Keeping III");
        this.addMusicDisc(TFItems.MUSIC_DISC_RADIANCE, "Rotch Gwylt - Radiance");
        this.addMusicDisc(TFItems.MUSIC_DISC_STEPS, "Rotch Gwylt - Steps");
        this.addMusicDisc(TFItems.MUSIC_DISC_SUPERSTITIOUS, "Rotch Gwylt - Superstitious");
        this.addMusicDisc(TFItems.MUSIC_DISC_HOME, "MrCompost - Home");
        this.addMusicDisc(TFItems.MUSIC_DISC_WAYFARER, "MrCompost - Wayfarer");
        this.addMusicDisc(TFItems.MUSIC_DISC_FINDINGS, "MrCompost - Findings");
        this.addMusicDisc(TFItems.MUSIC_DISC_MAKER, "MrCompost - Maker");
        this.addMusicDisc(TFItems.MUSIC_DISC_THREAD, "MrCompost - Thread");
        this.addMusicDisc(TFItems.MUSIC_DISC_MOTION, "MrCompost - Motion");
        this.add("item.twilightforest.lower_goblin_knight_spawn_egg", "Goblin Knight Spawn Egg");
        this.addEntityAndEgg(TFEntities.ADHERENT, "Adherent");
        this.addEntityAndEgg(TFEntities.ALPHA_YETI, "Alpha Yeti");
        this.addEntityAndEgg(TFEntities.ARMORED_GIANT, "Armored Giant");
        this.addEntityAndEgg(TFEntities.BIGHORN_SHEEP, "Bighorn Sheep");
        this.addEntityAndEgg(TFEntities.BLOCKCHAIN_GOBLIN, "Block and Chain Goblin");
        this.addEntityAndEgg(TFEntities.BOAR, "Boar");
        this.addEntityAndEgg(TFEntities.CARMINITE_BROODLING, "Carminite Broodling");
        this.addEntityAndEgg(TFEntities.CARMINITE_GHASTGUARD, "Carminite Ghastguard");
        this.addEntityAndEgg(TFEntities.CARMINITE_GHASTLING, "Carminite Ghastling");
        this.addEntityAndEgg(TFEntities.CARMINITE_GOLEM, "Carminite Golem");
        this.addEntityAndEgg(TFEntities.DEATH_TOME, "Death Tome");
        this.addEntityAndEgg(TFEntities.DEER, "Deer");
        this.addEntityAndEgg(TFEntities.DWARF_RABBIT, "Dwarf Rabbit");
        this.addEntityAndEgg(TFEntities.FIRE_BEETLE, "Fire Beetle");
        this.addEntityAndEgg(TFEntities.GIANT_MINER, "Giant Miner");
        this.addEntityAndEgg(TFEntities.HARBINGER_CUBE, "Harbinger Cube");
        this.addEntityAndEgg(TFEntities.HEDGE_SPIDER, "Hedge Spider");
        this.addEntityAndEgg(TFEntities.HELMET_CRAB, "Helmet Crab");
        this.addEntityAndEgg(TFEntities.HOSTILE_WOLF, "Hostile Wolf");
        this.addEntityAndEgg(TFEntities.HYDRA, "Hydra");
        this.addEntityAndEgg(TFEntities.ICE_CRYSTAL, "Ice Crystal");
        this.addEntityAndEgg(TFEntities.KING_SPIDER, "King Spider");
        this.addEntityAndEgg(TFEntities.KNIGHT_PHANTOM, "Knight Phantom");
        this.add("entity.twilightforest.knight_phantom.plural", "Knight Phantoms");
        this.addEntityAndEgg(TFEntities.KOBOLD, "Kobold");
        this.addEntityAndEgg(TFEntities.LICH, "Twilight Lich");
        this.addEntityAndEgg(TFEntities.MAZE_SLIME, "Maze Slime");
        this.addEntityAndEgg(TFEntities.MINOSHROOM, "Minoshroom");
        this.addEntityAndEgg(TFEntities.MINOTAUR, "Minotaur");
        this.addEntityAndEgg(TFEntities.MIST_WOLF, "Mist Wolf");
        this.addEntityAndEgg(TFEntities.MOSQUITO_SWARM, "Mosquito Swarm");
        this.addEntityAndEgg(TFEntities.NAGA, "Naga");
        this.addEntityAndEgg(TFEntities.PENGUIN, "Penguin");
        this.addEntityAndEgg(TFEntities.PINCH_BEETLE, "Pinch Beetle");
        this.addEntityAndEgg(TFEntities.QUEST_RAM, "Questing Ram");
        this.addEntityAndEgg(TFEntities.RAVEN, "Raven");
        this.addEntityAndEgg(TFEntities.REDCAP, "Redcap");
        this.addEntityAndEgg(TFEntities.REDCAP_SAPPER, "Redcap Sapper");
        this.addEntityAndEgg(TFEntities.SKELETON_DRUID, "Skeleton Druid");
        this.addEntityAndEgg(TFEntities.SLIME_BEETLE, "Slime Beetle");
        this.addEntityAndEgg(TFEntities.SNOW_GUARDIAN, "Snow Guardian");
        this.addEntityAndEgg(TFEntities.SNOW_QUEEN, "Snow Queen");
        this.addEntityAndEgg(TFEntities.SQUIRREL, "Squirrel");
        this.addEntityAndEgg(TFEntities.STABLE_ICE_CORE, "Stable Ice Core");
        this.addEntityAndEgg(TFEntities.SWARM_SPIDER, "Swarm Spider");
        this.addEntityAndEgg(TFEntities.TINY_BIRD, "Tiny Bird");
        this.addEntityAndEgg(TFEntities.TOWERWOOD_BORER, "Towerwood Borer");
        this.addEntityAndEgg(TFEntities.TROLL, "Troll");
        this.addEntityAndEgg(TFEntities.UNSTABLE_ICE_CORE, "Unstable Ice Core");
        this.addEntityAndEgg(TFEntities.UR_GHAST, "Ur-Ghast");
        this.addEntityAndEgg(TFEntities.WINTER_WOLF, "Winter Wolf");
        this.addEntityAndEgg(TFEntities.WRAITH, "Wraith");
        this.addEntityAndEgg(TFEntities.YETI, "Yeti");
        this.addEntityType((Supplier)TFEntities.LICH_MINION, "Lich Minion");
        this.addEntityType((Supplier)TFEntities.LOYAL_ZOMBIE, "Loyal Zombie");
        this.addEntityType((Supplier)TFEntities.LOWER_GOBLIN_KNIGHT, "Lower Goblin Knight");
        this.addEntityType((Supplier)TFEntities.RISING_ZOMBIE, "Zombie");
        this.addEntityType((Supplier)TFEntities.ROVING_CUBE, "Roving Cube");
        this.addEntityType((Supplier)TFEntities.UPPER_GOBLIN_KNIGHT, "Upper Goblin Knight");
        this.addEntityType((Supplier)TFEntities.ICE_SNOWBALL, "Ice Snowball");
        this.addEntityType((Supplier)TFEntities.ICE_ARROW, "Ice Arrow");
        this.addEntityType((Supplier)TFEntities.THROWN_ICE, "Ice Bomb");
        this.addEntityType((Supplier)TFEntities.SEEKER_ARROW, "Seeker Arrow");
        this.addEntityType((Supplier)TFEntities.MOONWORM_SHOT, "Moonworm");
        this.addEntityType((Supplier)TFEntities.NATURE_BOLT, "Nature Bolt");
        this.addEntityType((Supplier)TFEntities.SLIME_BLOB, "Slime Blob");
        this.addEntityType((Supplier)TFEntities.TOME_BOLT, "Death Tome Bolt");
        this.addEntityType((Supplier)TFEntities.WAND_BOLT, "Twilight Scepter Bolt");
        this.addEntityType((Supplier)TFEntities.LICH_BOLT, "Lich Bolt");
        this.addEntityType((Supplier)TFEntities.LICH_BOMB, "Explosive Lich Bolt");
        this.addEntityType((Supplier)TFEntities.HYDRA_MORTAR, "Hydra Mortar");
        this.addEntityType((Supplier)TFEntities.FALLING_ICE, "Falling Ice");
        this.addEntityType((Supplier)TFEntities.THROWN_WEP, "Thrown Weapon");
        this.addEntityType((Supplier)TFEntities.CHARM_EFFECT, "Charm Effect");
        this.addEntityType((Supplier)TFEntities.CHAIN_BLOCK, "Block and Chain");
        this.addEntityType((Supplier)TFEntities.CUBE_OF_ANNIHILATION, "Cube of Annihilation");
        this.addEntityType((Supplier)TFEntities.THROWN_BLOCK, "Thrown Block");
        this.addEntityType((Supplier)TFEntities.SLIDER, "Moving Slide Trap");
        this.addEntityType((Supplier)TFEntities.PROTECTION_BOX, "Progression Protection Box");
        this.addEntityType((Supplier)TFEntities.MAGIC_PAINTING, "Magic Painting");
        SUBTITLE_GENERATOR.forEach(this::add);
        this.addDeathMessage("ghastTear", "%1$s was scalded by fiery tears");
        this.addDeathMessage("ghastTear.player", "%1$s was scalded by fiery tears while escaping %2$s");
        this.addDeathMessage("hydraFire", "%1$s was roasted alive by the Hydra");
        this.addDeathMessage("hydraFire.player", "%1$s was roasted alive by the Hydra while escaping %2$s");
        this.addDeathMessage("hydraBite", "%1$s's skin was ripped off by the Hydra");
        this.addDeathMessage("hydraBite.player", "%1$s's skin was ripped off by the Hydra while escaping %2$s");
        this.addDeathMessage("lichBolt", "The Lich's aim was better than %1$s");
        this.addDeathMessage("lichBolt.player", "The Lich and %2$s had better aim than %1$s");
        this.addDeathMessage("lichBomb", "%1$s succumbed to the Lich's explosive magic");
        this.addDeathMessage("lichBomb.player", "%1$s succumbed to the Lich's explosive magic while escaping %2$s");
        this.addDeathMessage("chillingBreath", "%1$s was frozen to death by the Snow Queen");
        this.addDeathMessage("chillingBreath.player", "%1$s was frozen to death by the Snow Queen while escaping %2$s");
        this.addDeathMessage("squish", "%1$s was squashed by the Snow Queen");
        this.addDeathMessage("squish.player", "%1$s was squashed by the Snow Queen while escaping %2$s");
        this.addDeathMessage("thrownAxe", "%1$s was decapitated by a thrown axe");
        this.addDeathMessage("thrownAxe.player", "%1$s was decapitated by a thrown axe while escaping %2$s");
        this.addDeathMessage("thrownPickaxe", "%1$s was decapitated by a thrown pickaxe");
        this.addDeathMessage("thrownPickaxe.player", "%1$s was decapitated by a thrown pickaxe while escaping %2$s");
        this.addDeathMessage("fireJet", "%1$s accidentally walked into a Fire Jet");
        this.addDeathMessage("fireJet.player", "%1$s accidentally walked into a Fire Jet while escaping %2$s");
        this.addDeathMessage("reactor", "%1$s stood too close to a Carminite Reactor");
        this.addDeathMessage("reactor.player", "%1$s stood too close to a Carminite Reactor while escaping %2$s");
        this.addDeathMessage("slider", "%1$s was sliced up by a Sliding Trap");
        this.addDeathMessage("slider.player", "%1$s was sliced up by a Sliding Trap while escaping %2$s");
        this.addDeathMessage("thorns", "%1$s walked into some thorns");
        this.addDeathMessage("thorns.player", "%1$s walked into some thorns while escaping %2$s");
        this.addDeathMessage("knightmetal", "%1$s was skewered by a Knightmetal block");
        this.addDeathMessage("knightmetal.player", "%1$s was skewered by a Knightmetal block while escaping %2$s");
        this.addDeathMessage("fiery", "%1$s walked onto a Fiery block");
        this.addDeathMessage("fiery.player", "%1$s walked onto a Fiery block while escaping %2$s");
        this.addDeathMessage("thrownBlock", "%1$s was squashed by a thrown block");
        this.addDeathMessage("thrownBlock.player", "%1$s was squashed by a thrown block while escaping %2$s");
        this.addDeathMessage("expired", "%1$s's life expired");
        this.addDeathMessage("expired.player", "%1$s's life expired");
        this.addDeathMessage("ominousFire.zombified_player", "%1$s was killed by the zombified remains of %2$s");
        this.addDeathMessage("ominousFire.zombified_player.self", "%1$s was killed by the zombified remains of themselves");
        this.addDeathMessage("oreberry", "%1$s was stabbed to death by an oreberry bush");
        this.addDeathMessage("oreberry.player", "%1$s was stabbed to death by an oreberry bush while escaping %2$s");
        this.addDeathMessage("axing", "%1$s was chopped up by %2$s");
        this.addDeathMessage("axing.item", "%1$s was chopped up by %2$s using %3$s");
        this.addDeathMessage("moonworm", "%1$s was shot by Moonworm");
        this.addDeathMessage("ant", "%1$s was squashed like an ant by %2$s");
        this.addDeathMessage("ant.item", "%1$s was squashed like an ant by %2$s holding %3$s");
        this.addDeathMessage("haunt", "%1$s joined the %2$s's haunt");
        this.addDeathMessage("haunt.item", "%1$s joined the %2$s's haunt after being killed by %3$s");
        this.addDeathMessage("clamped", "%1$s was squeezed to death by %2$s");
        this.addDeathMessage("clamped.item", "%1$s was squeezed to death by %2$s using %3$s");
        this.addDeathMessage("scorched", "%1$s was scorched by %2$s");
        this.addDeathMessage("scorched.item", "%1$s was scorched by %2$s using %3$s");
        this.addDeathMessage("frozen", "%1$s was frozen by %2$s using an Ice Bomb");
        this.addDeathMessage("frozen.item", "%1$s was frozen by %2$s using %3$s");
        this.addDeathMessage("spiked", "%1$s was skewered by %2$s");
        this.addDeathMessage("spiked.item", "%1$s was skewered by %2$s using %3$s");
        this.addDeathMessage("leafBrain", "%1$s's brain was turned into leaves by %2$s");
        this.addDeathMessage("leafBrain.item", "%1$s's brain was turned into leaves by %2$s using %3$s");
        this.addDeathMessage("lostWords", "%1$s was at a loss for words after being killed by %2$s");
        this.addDeathMessage("lostWords.item", "%1$s was at a loss for words after being killed by %2$s using %3$s");
        this.addDeathMessage("schooled", "%1$s was schooled by %2$s");
        this.addDeathMessage("schooled.item", "%1$s was schooled by %2$s using %3$s");
        this.addDeathMessage("snowballFight", "%1$s lost a snowball fight to %2$s");
        this.addDeathMessage("snowballFight.item", "%1$s lost a snowball fight to %2$s using %3$s");
        this.addDeathMessage("lifedrain", "%1$s's life was drained by %2$s");
        this.addDeathMessage("lifedrain.item", "%1$s's life was drained by %2$s using %3$s");
        this.addDeathMessage("yeeted", "%1$s was yeeted for the last time");
        this.addDeathMessage("yeeted.entity", "%1$s was yeeted for the last time by %2$s");
        this.addDeathMessage("yeeted.item", "%1$s was yeeted for the last time by %2$s while somehow holding %3$s");
        this.addDeathMessage("acid_rain", "%1$s went dancing in the acid rain");
        this.addDeathMessage("ominous", "%1$s was subsumed by ominous fire");
        this.addDeathMessage("failedChallenge", "%1$s failed to show their mettle and drank themselves to death");
        this.addDeathMessage("stale_sandwich", "%1$s was turned into a stale sandwich by %2$s");
        this.addStat("blocks_crumbled", "Blocks Crumbled");
        this.addStat("bugs_squished", "Bugs Squashed");
        this.addStat("e115_slices_eaten", "Experiment 115 Slices Eaten");
        this.addStat("keeping_charms_activated", "Charms of Keeping Used");
        this.addStat("life_charms_activated", "Charms of Life Used");
        this.addStat("skull_candles_made", "Skull Candles Created");
        this.addStat("tf_shields_broken", "Fortification Shields Broken");
        this.addStat("torchberries_harvested", "Torchberries Harvested");
        this.addStat("trophy_pedestals_activated", "Trophy Pedestals Activated");
        this.addStat("uncrafting_table_interactions", "Interactions with Uncrafting Table");
        this.add("config.jade.plugin_twilightforest.quest_ram_wool", "Questing Ram Wool");
        this.add("config.jade.plugin_twilightforest.chiseled_bookshelf_spawner", "Chiseled Canopy Bookshelf Spawns");
        this.add("config.jade.plugin_twilightforest.drying_rack", "Drying Rack Time");
        this.add("jade.drying_rack.remaining", "%s remaining");
        this.add("twilightforest.book.author", "a forgotten explorer");
        this.addBookAndContents("lichtower", "Notes on a Pointy Tower", "\u00a78[An explorer's notebook, gnawed on by monsters]\u00a70\n\nI have begun examining the strange aura surrounding this tower. The bricks of the tower are protected by a curse, stronger than any I've seen before. The magic from the curse is boiling off into the", "surrounding area.\n\nIn my homeland I would have many options for dealing with this magic, but here my supplies are limited. I shall have to research...", "\u00a78[[Many entries later]]\u00a70\n\nA breakthrough! In my journeys I sighted a huge snake-like monster in a decorated courtyard. Nearby, I picked up a worn down, discarded green scale.\n\nThe magic in the scale seems to have the curse-breaking", "properties I need, but the magic is too dim. I may need to acquire a fresher specimen, directly from the creature.");
        this.addBookAndContents("labyrinth", "Notes on a Swampy Labyrinth", "\u00a78[[An explorer's notebook, written on waterproof paper]]\u00a70\n\nThe mosquitoes in this swamp are vexing, but strange. The vast majority of them seem to have no natural source, nor do they seem to have a role in the local ecology. I have begun to suspect that they are", "some kind of magical curse.\n\n\u00a78[[Next entry]]\u00a70\n\nNow that I have encountered a protection spell on the ruined labyrinth here, I consider my suspicions confirmed. Both the protection spell and the mosquitoes are a", "curse. This curse seems to have a different source from the others I have encountered. I will have to research further...\n\n\u00a78[[Next entry]]\u00a70\n\nThe curse seems to be of a type too powerful for one being alone to", "produce. Several wizards working in combination would be necessary.\n\nIf one of the wizards stopped contributing, the whole of the curse over the entire swamp would fall. Strangely, my divinations do not show signs of any nearby living wizards.", "I did see something interesting in one of the nearby pointy-roofed towers though...");
        this.addBookAndContents("hydralair", "Notes on the Fire Swamp", "\u00a78[[An explorer's notebook, written on fireproof paper]]\u00a70\n\nFire is a trivial obstacle for a master explorer such as myself. I have traversed seas of fire, and swam through oceans of lava. The burning air here is an interesting variation, but", "ultimately no hindrance.\n\nWhat does stop me though is that I have encountered another protection spell, this time surrounding a mighty creature that must be king of this fire swamp. This is not the first protection spell I have encountered, and I am", "beginning to unravel the mysteries of how they work.\n\nIf this spell is like the others, it will be sustained by a powerful creature nearby. Surrounding the fire swamp are several wet swamps, and under those swamps are labyrinths full of minotaurs.", "The logical choice to bind such a spell to would be some sort of powerful minotaur, different in some way from the others that surround it...");
        this.addBookAndContents("tfstronghold", "Notes on a Stronghold", "\u00a78[[An explorer's notebook, written on faintly glowing paper]]\u00a70\n\nThe tendrils of darkness surrounding this area are just a manifestation of a protective spell over the entire dark forest. The spell causes blindness, which is quite vexing. I have seen several", "interesting things in the area and would like to keep exploring.\n\n\u00a78[[Next entry]]\u00a70\n\nI have found ruins in the dark forest. They belong to a stronghold, of a type usually inhabited by knights. Rather than knights though, this stronghold is full of", "goblins. They wear knightly armor, but their behavior is most un-knightly.\n\n\u00a78[[Next entry]]\u00a70\n\nDeep in the ruins, I have found a pedestal. The pedestal seems to be of a type that knights would place trophies on to prove their strength.", "Obtaining a powerful scepter would seem to weaken the curse on the dark forest, and placing a trophy associated with a powerful creature on the pedestal would likely grant access into the main part of the stronghold.");
        this.addBookAndContents("darktower", "Notes on a Wooden Tower", "\u00a78[[An explorer's notebook that seems to have survived an explosion]]\u00a70\n\nThis tower clearly has mechanisms that are not responding to me. Their magic almost yearns to acknowledge my touch, but it cannot. It is if the devices of the tower are being", "suppressed by a powerful group of beings nearby.\n\n\u00a78[[Next entry]]\u00a70\n\nThe magic seems to emanate from deep within the strongholds nearby. It can't come from the goblins, as their magic is charming, but unfocused. There", "must still be some force still active in the strongholds.\n\n\u00a78[[Next entry]]\u00a70\n\nMy analysis indicates that it comes from several sources, operating as a group. I will head back to the stronghold after I resupply...");
        this.addBookAndContents("yeticave", "Notes on an Icy Cave", "\u00a78[[An explorer's notebook, covered in frost]]\u00a70\n\nThe blizzard surrounding these snowy lands is unceasing. This is no ordinary snowfall--this is a magical phenomenon. I will have to conduct experiments to find what is capable of", "causing such an effect.\n\n\u00a78[[Next entry]]\u00a70\n\nThe curse seems to be of a type too powerful for one being alone to produce. Several wizards working in combination would be necessary. If one of the wizards stopped", "contributing, the blizzard would calm. Strangely, my divinations do not show signs of any nearby living wizards. I did see something interesting in one of the nearby pointy-roofed towers though...");
        this.addBookAndContents("icetower", "Notes on Auroral Fortification", "\u00a78[[An explorer's notebook, caked in ice]]\u00a70\n\nI overcame one blizzard, only to run into this terrible ice storm atop the glacier. My explorations have shown me the splendor of an ice palace, shining with the colors of the", "polar aurora. It all seems protected by some sort of curse.\n\n\u00a78[[Next entry]]\u00a70\n\nI am no novice. This curse is fed by the power of a creature nearby. The cause of the curse surrounding the fire swamp was built off the power of the", "leader of the minotaurs nearby.\n\nSurrounding this glacier, there are masses of yetis. Perhaps the yetis have some sort of leader...");
        this.addBookAndContents("trollcave", "Notes on the Highlands", "\u00a78[[An explorer's notebook, damaged by acid]]\u00a70\n\nThere seems to be no way to protect myself from the toxic rainstorm surrounding this area. In my brief excursions, I have also encountered another protection spell, similar to the others I have", "witnessed. The spell must be connected to the toxic storm in some way. Further research to follow...\n\n\u00a78[[Next entry]]\u00a70\n\nSuch supreme weather magic must be the result of multiple undefeated great evils in this world. My studies contain", "several clues pointing at a searing swamp, a forest coated in deep darkness, and a realm coated in snow.");
        this.addBookAndContents("unknown", "Notes on the Unexplained", "\u00a78[[This book shows signs of having been copied many times]]\u00a70\n\nI cannot explain the field surrounding this structure, but the magic is powerful. If this curse is like the others, then the answer to unlocking it lies elsewhere. Perhaps there is something I have left", "undone, or some monster I have yet to defeat. I will have to turn back. I will return to this place later, to see if anything has changed.");
        this.addScreenMessage("optifine.title", "WARNING: OPTIFINE DETECTED");
        this.addScreenMessage("optifine.message", "Before proceeding, please note that Optifine is known to cause crashes, multipart entity visual bugs and many other issues.\n\nBefore reporting a bug, please remove Optifine first and check again to see if the bug is still present.\n\nOptifine-related issues are not solvable on Twilight Forest's end!\n\nThis screen may be disabled in the Client Config.");
        this.addScreenMessage("optifine.suggestions", "Here's a selection of mods that we recommend using instead.");
        this.addScreenMessage("progression_end.message", "This is the end of progression for now. The Final Castle that awaits on the plateau is still unfinished and a work in progress. If you would like to keep up with the mod's development you can join our %s.");
        this.addScreenMessage("progression_end.discord", "Discord Server");
        this.addScreenMessage("drying_jei", "Drying Rack");
        this.addScreenMessage("drying_time", "%sm %ss");
        this.addScreenMessage("drying_minutes", "%s Minutes");
        this.addScreenMessage("drying_minute", "%s Minute");
        this.addScreenMessage("drying_seconds", "%s Seconds");
        this.addScreenMessage("drying_second", "%s Second");
        this.addScreenMessage("drying_ticks", "%s ticks");
        this.addScreenMessage("crumble_horn_jei", "Crumble Horn");
        this.addScreenMessage("transformation_jei", "Transformation Powder");
        this.addScreenMessage("ominous_fire_jei", "Ominous Fire");
        this.addScreenMessage("uncrafting_jei", "Uncrafting");
        this.addScreenMessage("moonworm_queen_jei", "Moonworm Queen Repairing");
        this.add("item.twilightforest.moonworm_queen.jei_info_message", "Torchberries restore 64 durability each");
        this.addTrim("carminite", "Carminite");
        this.addTrim("fiery", "Fiery");
        this.addTrim("ironwood", "Ironwood");
        this.addTrim("knightmetal", "Knightmetal");
        this.addTrim("naga_scale", "Naga Scale");
        this.addTrim("steeleaf", "Steeleaf");
        this.add("museumcurator.animalhusbandry.twilightforest.bugs", "Bugs");
        this.add("museumcurator.architecture.twilightforest.aurorablocks", "Aurora Blocks");
        this.add("museumcurator.architecture.twilightforest.banisters", "Banisters");
        this.add("museumcurator.architecture.twilightforest.castlebrick", "Castle Brick");
        this.add("museumcurator.architecture.twilightforest.giantblocks", "Giant Blocks");
        this.add("museumcurator.botany.twilightforest.beanstalk", "Beanstalk");
        this.add("museumcurator.botany.twilightforest.canopytree", "Canopy Tree");
        this.add("museumcurator.botany.twilightforest.darkwoodtree", "Darkwood Tree");
        this.add("museumcurator.botany.twilightforest.miningtree", "Minewood Tree");
        this.add("museumcurator.botany.twilightforest.sortingtree", "Sortingwood Tree");
        this.add("museumcurator.botany.twilightforest.mangrovetree", "Mangrove Tree");
        this.add("museumcurator.botany.twilightforest.timetree", "Timewood Tree");
        this.add("museumcurator.botany.twilightforest.transformationtree", "Transwood Tree");
        this.add("museumcurator.botany.twilightforest.twilightoaktree", "Twilight Oak Tree");
        this.add("museumcurator.equipment.twilightforest.scepters", "Scepters of Power");
        this.add("museumcurator.lithology.twilightforest.deadrock", "Deadrock");
        this.add("museumcurator.lithology.twilightforest.mazestone", "Mazestone");
        this.add("museumcurator.lithology.twilightforest.nagastone", "Nagastone");
        this.add("museumcurator.machinery.twilightforest.carminitemachines", "Carminite Mechanisms");
        this.add("museumcurator.metallurgy.twilightforest.fiery", "Fiery Metal");
        this.add("museumcurator.metallurgy.twilightforest.ironwood", "Ironwood");
        this.add("museumcurator.metallurgy.twilightforest.knightmetal", "Knightmetal");
        MAGIC_PAINTING_HELPER.forEach((location, stringStringPair) -> {
            this.add(location.toLanguageKey("magic_painting", "title"), (String)stringStringPair.getFirst());
            this.add(location.toLanguageKey("magic_painting", "author"), (String)stringStringPair.getSecond());
        });
        this.createTip("alpha_yeti", "The Alpha Yeti's rampage causes blocks to become dislodged from the ceiling. Watch out for falling icicles!");
        this.createTip("anvil_squashing", "Bugs can be squashed by Anvils.");
        this.createTip("arctic_armor", "Arctic Armor can be dyed any color.");
        this.createTip("baby_jockey", "Baby Skeleton Druids can be found riding Swarm Spiders.");
        this.createTip("banister_shape", "Banisters can be right-clicked with an axe to change their height.");
        this.createTip("block_and_chain", "Enchanting a Block and Chain with Destruction allows it to break blocks.");
        this.createTip("boggard", "What the heck is a Boggard?");
        this.createTip("bugs_on_head", "Bugs will happily sit on your head.");
        this.createTip("burnt_thorns", "Burnt Thorns will disintegrate when stepped on.");
        this.createTip("carminite_builder", "Carminite Builders place temporary blocks in the direction you're looking.");
        this.createTip("charm_of_keeping", "A Charm of Keeping will return parts of your inventory after death.");
        this.createTip("charm_of_life", "A Charm of Life can save you from a fatal blow.");
        this.createTip("clouds", "Rainy and Snowy Clouds can be used to simulate weather effects!");
        this.createTip("crumble_horn", "The Crumble Horn will deteriorate nearby blocks when used.");
        this.createTip("druid_hut", "Druid huts sometimes have hidden basements.");
        this.createTip("e115_pickup", "Sneak + right-click placed Experiment 115 to pick it back up.");
        this.createTip("e115_sprinkle", "Redstone can be sprinkled on top of Experiment 115.");
        this.createTip("emperors_cloth", "Emperor's Cloth will prevent armor from rendering when crafted with it.");
        this.createTip("experiment_115", "Does anyone know what Experiment 115 really is?");
        this.createTip("feather_fan", "The Peacock Feather Fan can be used to push mobs away, or yourself into the air if used while jumping. It also works well with the Elytra and Mace!");
        this.createTip("fiery_pickaxe", "A Fiery Pickaxe will smelt any blocks it breaks.");
        this.createTip("ghast_trap", "Killing Carminite Ghastlings near a Ghast Trap will charge it.");
        this.createTip("giant_block", "Mining a 4x4x4 area of the same block with a Giant's Pickaxe will drop 1 giant block instead.");
        this.createTip("glass_sword", "Glass Swords break after a single hit.");
        this.createTip("hollow_log", "Various things can be placed inside Hollow Logs such as snow, moss, or ladders.");
        this.createTip("hollow_oak_sapling", "Saplings that grow into giant hollow trees can be found in Druid Huts.");
        this.createTip("hollow_oak_tree", "Hollow Oak trees sometimes have dungeon-like rooms with unique loot in their leaves.");
        this.createTip("hydra_chop", "Hydra Chops fill up your hunger bar completely when eaten.");
        this.createTip("hydra_heads", "For each head slain, the Hydra will regrow two in its place!");
        this.createTip("hydra_mortars", "You can deflect the Hydra's mortar attack.");
        this.createTip("ice_core", "Ice Cores and Snow Guardians melt in hot biomes.");
        this.createTip("jars", "Fireflies and Cicadas can be put into jars.");
        this.createTip("key_biomes", "Progression biomes generate in clusters of 4 minibosses surrounding a normal boss.");
        this.createTip("key_biome_locations", "Progression biome clusters generate roughly 600 blocks away from each other, meaning the next boss is never too far away.");
        this.createTip("kobold", "Kobold");
        this.createTip("labyrinth_vault", "The Labyrinth contains a secret room.");
        this.createTip("lich_scepters", "The Lich drops a variety of magic-based scepters.");
        this.createTip("liveroot", "Liveroot is found under most trees.");
        this.createTip("magic_beans", "Planting Magic Beans on Uberous Soil sprouts a mighty beanstalk.");
        this.createTip("magic_leaves", "Magic Tree Leaves won't drop saplings when broken.");
        this.createTip("magic_map", "Magic Maps are used to easily locate structures.");
        this.createTip("magic_saplings", "Special magic saplings can be found inside Hollow Oak trees.");
        this.createTip("maze_map_focus", "Minotaurs can occasionally drop Maze Map Focuses, which can be used to make Maze Maps.");
        this.createTip("mazebreaker", "The Mazebreaker can break Mazestone blocks 16 times faster and doesn't take extra durability damage.");
        this.createTip("mining_tree", "The Miner's Tree will pull ores up to the surface.");
        this.createTip("minoshroom", "The Minoshroom will perform a slam attack if a player lingers too close to it.");
        this.createTip("moon_dial", "The Moon Dial shows the current phase of the moon.");
        this.createTip("moonworm_queen", "The Moonworm Queen can be fed Torchberries.");
        this.createTip("mushglooms", "Mushglooms cannot be bonemealed into giant mushrooms. However, placing them on Uberous Soil will make them grow.");
        this.createTip("music_disc", "Music Discs are found outside of dungeons.");
        this.createTip("naga", "The Naga can be stunned by making it ram something hard!");
        this.createTip("netherite_axe", "There will never be a Netherite Minotaur Axe.");
        this.createTip("ore_magnet", "The Ore Magnet can pull ore veins up to the surface.");
        this.createTip("ore_meter", "The Ore Meter will display all nearby ores when turned on. It can also target certain blocks by shift-right clicking them, and will then only show a count of those blocks nearby. ");
        this.createTip("parrying", "A well-timed shield block can parry a projectile back at a mob.");
        this.createTip("peacock_feather_fan", "The Peacock Feather Fan can be used to extinguish Candles.");
        this.createTip("phantom_armor", "Phantom Armor is automatically kept on death.");
        this.createTip("phantoms", "Knight Phantoms take a lot less damage if they're invisible. Try to target the visible one when fighting them!");
        this.createTip("pocket_watch", "The Rabbit's Pocket Watch will grants additional speed while in the hotbar, and will increase mining speed when held.");
        this.createTip("quest_ram", "The Questing Ram will reward anyone who gives it what it's missing.");
        this.createTip("red_thread", "Red Thread can be seen through walls.");
        this.createTip("redcap", "Redcaps can place and light TNT.");
        this.createTip("skull_candle", "Candles can be placed on top of mob heads to create a fancy light source.");
        this.createTip("sorting_tree", "The Sorting Tree will sort chests next to it into other chests nearby.");
        this.createTip("spooky_forest", "The Spooky Forest is not Halloween themed.");
        this.createTip("structure_conquering", "Killing a boss will make mobs stop spawning in that structure.");
        this.createTip("structure_spawning", "Structures spawn in a grid-like pattern.");
        this.createTip("the_lore", "The story is all here, you just need to figure it out yourself!");
        this.createTip("time_tree", "The Tree of Time will accelerate the growth of nearby crops.");
        this.createTip("torchberries", "We did glow berries first!");
        this.createTip("towerwood", "Towerwood Planks are very resistant, but not immune, to fire.");
        this.createTip("transformation_tree", "The Tree of Transformation will convert the area around it into an Enchanted Forest.");
        this.createTip("trollber_ripening", "Killing a Troll will ripen nearby Trollber.");
        this.createTip("trophy_pedestal", "Trophy Pedestals can only be mined after they have been activated.");
        this.createTip("twilight_portal", "Throw a diamond into a pool of water surrounded by flowers.");
        this.createTip("uncrafting_table", "The Uncrafting Table isn't just used to uncraft items. It can also recraft items into other ones, repair tools and armor, and transfer enchantments across gear!");
        this.createTip("ur_ghast", "The Ur-Ghast can be pulled down from the sky using Ghast Traps.");
        this.createTip("vanishing_block", "Vanishing Blocks will disappear forever when activated.");
        this.createTip("worldgen_features", "The forest is filled with many ruins. Some may even contain unique items.");
        this.createTip("yeti", "Yetis love throwing things.");
        this.createTip("zombie_healing", "Zombies summoned with a Zombie Scepter can be healed with Rotten Flesh.");
        this.createTip("mystic_crown", "The Mystic Crown slightly buffs scepters when worn.");
        this.createTip("potion_flask", "Potion Flasks can hold up to 3 doses of the same potion.");
        this.createTip("minion_buff", "If the Twilight Lich hits one of his minions with a projectile, it will make the minion stronger and faster. ");
        this.createTip("ominous_fire", "Ominous fire can turn creatures undead.");
        this.createTip("the_walls", "The Death Tomes are in your walls. They're in your walls.");
        this.createTip("lich_deflection", "The Twilight Lich will deflect Scepter of Twilight bolts after his shields are down.");
        this.createTip("candelabra", "Using Redstone Dust on a Candelabra will make its flames turn red and emit a redstone signal.");
        this.createTip("wrought_iron", "Wrought Iron Bars cannot be obtained normally. They can only be obtained by uncrafting blocks made of them.");
        this.createTip("essence_charge", "Exanimate Essence will fully charge any scepter it is crafted with.");
        this.createTip("casket_usage", "The Keepsake Casket acts as a limited use gravestone. If in your inventory on death, it will place itself and hold all your items inside.");
        this.createTip("casket_logging", "The Keepsake Casket can be waterlogged, lavalogged, and encased in a block if it falls victim to a fluid interaction.");
        this.createTip("renewal", "Scepters enchanted with Renewal will automatically recharge themselves using the required items in the player's inventory.");
        this.createTip("jerky", "Meat can be dried into jerky using Drying Racks.");
        this.createTip("berry_bushes", "Berry bushes can be found all over the Twilight Forest.");
        this.createTip("oreberries", "Metal berry bushes rarely generate underground.");
        this.createTip("craft_travellers_gear", "Traveller's gear can be crafted from drying Treated Leather and turning it into Tanned Leather.");
        this.createTip("modify_travellers_gear", "Each piece of traveller's gear has 1 built-in ability, and up to 3 more can be added per piece.");
        this.createTip("nether_bushes", "Along with other foreign objects and materials, strange plantlife has made itself native to the Dark Tower.");
        this.translateTag(ItemTagGenerator.CARMINITE_GEMS, "Carminite Gems");
        this.translateTag(ItemTagGenerator.FIERY_INGOTS, "Fiery Ingots");
        this.translateTag(ItemTagGenerator.IRONWOOD_INGOTS, "Ironwood Ingots");
        this.translateTag(ItemTagGenerator.KNIGHTMETAL_INGOTS, "Knightmetal Ingots");
        this.translateTag(ItemTagGenerator.STEELEAF_INGOTS, "Steeleaf Ingots");
        this.translateTag(ItemTagGenerator.WROUGHT_IRON_INGOTS, "Wrought Iron Ingots");
        this.translateTag(ItemTagGenerator.PAPER, "Papers");
        this.translateTag(ItemTagGenerator.RAW_MATERIALS_IRONWOOD, "Raw Ironwood");
        this.translateTag(ItemTagGenerator.RAW_MATERIALS_KNIGHTMETAL, "Raw Knightmetal");
        this.translateTag(ItemTagGenerator.STORAGE_BLOCKS_ARCTIC_FUR, "Arctic Fur Storage Blocks");
        this.translateTag(ItemTagGenerator.STORAGE_BLOCKS_CARMINITE, "Carminite Storage Blocks");
        this.translateTag(ItemTagGenerator.STORAGE_BLOCKS_FIERY, "Fiery Storage Blocks");
        this.translateTag(ItemTagGenerator.STORAGE_BLOCKS_IRONWOOD, "Ironwood Storage Blocks");
        this.translateTag(ItemTagGenerator.STORAGE_BLOCKS_KNIGHTMETAL, "Knightmetal Storage Blocks");
        this.translateTag(ItemTagGenerator.STORAGE_BLOCKS_STEELEAF, "Steeleaf Storage Blocks");
        this.translateTag(ItemTagGenerator.ARCTIC_FUR, "Arctic Fur");
        this.translateTag(ItemTagGenerator.BANNED_UNCRAFTABLES, "Can't be Uncrafted");
        this.translateTag(ItemTagGenerator.BANNED_UNCRAFTING_INGREDIENTS, "Banned Uncrafting Ingredients");
        this.translateTag(ItemTagGenerator.BANISTERS, "Banisters");
        this.translateTag(ItemTagGenerator.CANOPY_LOGS, "Canopy Logs");
        this.translateTag(ItemTagGenerator.DARKWOOD_LOGS, "Darkwood Logs");
        this.translateTag(ItemTagGenerator.FIERY_VIAL, "Fiery Vials");
        this.translateTag(ItemTagGenerator.KEPT_ON_DEATH, "Kept on Death");
        this.translateTag(ItemTagGenerator.BLOCK_AND_CHAIN_ENCHANTABLE, "Block and Chain Enchantable");
        this.translateTag(ItemTagGenerator.KOBOLD_PACIFICATION_BREADS, "Kobold Pacification Items");
        this.translateTag(ItemTagGenerator.BOAR_TEMPT_ITEMS, "Boar Temptables");
        this.translateTag(ItemTagGenerator.DEER_TEMPT_ITEMS, "Deer Temptables");
        this.translateTag(ItemTagGenerator.DWARF_RABBIT_TEMPT_ITEMS, "Dwarf Rabbit Temptables");
        this.translateTag(ItemTagGenerator.PENGUIN_TEMPT_ITEMS, "Penguin Temptables");
        this.translateTag(ItemTagGenerator.RAVEN_TEMPT_ITEMS, "Raven Temptables");
        this.translateTag(ItemTagGenerator.SQUIRREL_TEMPT_ITEMS, "Squirrel Temptables");
        this.translateTag(ItemTagGenerator.TINY_BIRD_TEMPT_ITEMS, "Tiny Bird Temptables");
        this.translateTag(ItemTagGenerator.TWILIGHT_LOGS, "Twilight Forest Logs");
        this.translateTag(ItemTagGenerator.MANGROVE_LOGS, "Mangrove Logs");
        this.translateTag(ItemTagGenerator.MINING_LOGS, "Miningwood Logs");
        this.translateTag(ItemTagGenerator.PORTAL_ACTIVATOR, "Twilight Forest Portal Activators");
        this.translateTag(ItemTagGenerator.REPAIRS_FIERY_TOOLS, "Repairs Fiery Tools");
        this.translateTag(ItemTagGenerator.REPAIRS_GIANT_TOOLS, "Repairs Giant Tools");
        this.translateTag(ItemTagGenerator.REPAIRS_ICE_TOOLS, "Repairs Ice Tools");
        this.translateTag(ItemTagGenerator.REPAIRS_IRONWOOD_TOOLS, "Repairs Ironwood Tools");
        this.translateTag(ItemTagGenerator.REPAIRS_KNIGHTMETAL_TOOLS, "Repairs Knightmetal Tools");
        this.translateTag(ItemTagGenerator.REPAIRS_STEELEAF_TOOLS, "Repairs Steeleaf Tools");
        this.translateTag(ItemTagGenerator.SORTING_LOGS, "Sortingwood Logs");
        this.translateTag(ItemTagGenerator.TIME_LOGS, "Timewood Logs");
        this.translateTag(ItemTagGenerator.TOWERWOOD, "Towerwood Blocks");
        this.translateTag(ItemTagGenerator.TRANSFORMATION_LOGS, "Transformation Logs");
        this.translateTag(ItemTagGenerator.TWILIGHT_OAK_LOGS, "Twilight Oak Logs");
        this.translateTag(ItemTagGenerator.UNCRAFTING_IGNORES_COST, "Uncrafting Table Ignores Cost");
        this.translateTag(ItemTagGenerator.WIP, "Work In Progress Items");
        this.translateTag(ItemTagGenerator.IMMUNE_TO_THORNS, "Immune to Thorns");
        this.translateTag(ItemTagGenerator.SCEPTERS, "Scepters");
        this.translateTag(FluidTagGenerator.FIRE_JET_FUEL, "Fire Jet Fuel");
        this.add("twilightforest.configuration.title", "Twilight Forest Config");
        this.add("twilightforest.configuration.section.twilightforest.client.toml", "Client Settings");
        this.add("twilightforest.configuration.section.twilightforest.client.toml.title", "Client Settings");
        this.add("twilightforest.configuration.section.twilightforest.common.toml", "Common Settings");
        this.add("twilightforest.configuration.section.twilightforest.common.toml.title", "Common Settings");
        this.configEntry("silent_cicadas", "Silent Cicadas", "Makes Cicadas silent for those having sound library problems or finding them annoying.");
        this.configEntry("silent_cicadas_on_head", "Silent Cicadas on Head", "Makes Cicadas silent when one is on your head. If the above option is set to true, this won't have any effect.");
        this.configEntry("screen_shake", "Beanstalk Screen Shake", "Controls whether the screen shakes when a Magic Bean is in the process of growing.");
        this.configEntry("animate_trophies", "Animate Trophies", "Rotate Trophy heads on item model. Has no performance impact at all. For those who don't like fun.");
        this.configEntry("optifine", "Optifine Screen", "Disable the nag screen when OptiFine is installed.");
        this.configEntry("locked_toasts", "Disable Locked Biome Toasts", "Disables the toasts that appear when entering a locked biome. Not recommended if you're unfamiliar with progression.");
        this.configEntry("ram_indicator", "Questing Ram Wool Indicator", "Renders a check mark or X above your crosshair while holding wool when hovering over the Questing Ram depending on if that color of wool has been fed to it already.");
        this.configEntry("shield_indicator", "Fortification Shield Indicator", "Renders how many fortification shields are currently active on your player above your armor bar.\n\"Turn this off if other mods render over/under it.");
        this.configEntry("shield_indicator_creative", "Fortification Shield Indicator (creative)", "Enables the fortification shield indicator in creative for debugging.");
        this.configEntry("giant_skin_uuid_list", "Giant Skins", "List of player UUIDs whose skins the Giants should use. Leave the list empty to use the skin of the player viewing them.", "Edit Skins");
        this.configEntry("aurora_biomes", "Aurora Shader Biomes", "Defines which biomes the aurora shader effect will appear in. Leave the list empty to disable the effect.", "Edit Biomes");
        this.configEntry("prettify_ore_meter_gui", "Prettify Ore Meter GUI", "Lines up the dashes and percentages in the Ore Meter GUI.");
        this.configEntry("totem_charm_animation", "Totem of Undying Charm Animation", "Makes Charms when triggered display like the Totem of Undying instead of our own effects.");
        this.configEntry("manual_travellers_wings_gradual_glide", "Manual Gradually Gliding", "When this option is off, slow falling is the default. Holding the sneak key makes you fall at normal speed. When this option is on, normal falling is the default. Holding the sneak key activates slow falling.");
        this.configCategory("item_display", "Item Display Modifier Settings", "Controls where various elements render when using the Item Display Modifier on Traveller's Gear.");
        this.configEntry("screen_offset_x", "Display X Offset", "Defines the starting Y offset for all display modifiers on the screen.");
        this.configEntry("screen_offset_y", "Display Y Offset", "Defines the starting Y offset for all display modifiers on the screen.");
        this.configEntry("screen_scale", "Display Scale", "Defines the scale of all display modifiers on the screen.");
        this.configEntry("twenty_four_hour_format", "24-Hour Format", "If ON, the clock upgrade displays time in 24-hour format instead of 12-hour format.");
        this.configCategory("dim_settings", "Dimension Settings", "Settings that are not reversible without consequences.");
        this.configEntry("spawn_in_tf", "Spawn in Twilight Forest", "If true, players spawning for the first time will spawn in the Twilight Forest.");
        this.configEntry("portal_for_new_player", "Create Return Portal for Players", "If true, the return portal will spawn for new players that were sent to the TF if `newPlayersSpawnInTF` is true.");
        this.configCategory("portal_settings", "Portal Settings", "All settings regarding the Twilight Forest Portal are found here");
        this.configEntry("origin_dimension", "Origin Dimension", "The dimension you can always travel to the Twilight Forest from, as well as the dimension you will return to. Defaults to the overworld. (domain:regname).");
        this.configEntry("portals_in_other_dimensions", "Create Portals in Other Dimensions", "Allow portals to the Twilight Forest to be made outside of the 'origin' dimension. May be considered an exploit.");
        this.configEntry("portal_permission", "Portal Creation Permission", "Allows people with the specified permission or higher to create portals. This is based off of Vanilla's permission system.\nYou can read about them here: https://minecraft.wiki/w/Permission_level");
        this.configEntry("disable_portal", "Disable Portal Creation", "Disable Twilight Forest portal creation entirely. Provided for server operators looking to restrict action to the dimension.");
        this.configEntry("check_portal_placement", "Check Portal Placement", "Determines if new portals should be pre-checked for safety. If false, portals will fail to form rather than redirect to a safe alternate destination.\nNote that disabling this also reduces the rate at which portal formation checks are performed.");
        this.configEntry("destructive_portal_lighting", "Destructive Lightning", "Set this to false if you want the lightning that zaps the portal to not set things on fire. For those who don't like fun.");
        this.configEntry("portal_return", "Lock Return Portal", "If false, the return portal will require the activation item.");
        this.configEntry("portal_unlocked_by_advancement", "Portal Unlock Advancement", "Use a valid advancement resource location as a string. For example, using the string \"minecraft:story/mine_diamond\" will lock the portal behind the \"Diamonds!\" advancement. Invalid/Empty Advancement resource IDs will leave the portal entirely unlocked.");
        this.configEntry("max_portal_size", "Max Portal Size", "The max amount of water spaces the mod will check for when creating a portal. Very high numbers may cause performance issues.");
        this.configCategory("uncrafting", "Uncrafting Table", "Settings for all things related to the Uncrafting Table.");
        this.configEntry("uncrafting_xp_cost", "Uncrafting Cost Multiplier", "Multiplies the total XP cost of uncrafting an item and rounds up.\nHigher values means the recipe will cost more to uncraft, lower means less. Set to 0 to disable the cost altogether.\nNote that this only affects reversed crafting recipes, uncrafting recipes will still use the same cost as they normally would.");
        this.configEntry("repairing_xp_cost", "Repairing Cost Multiplier", "Multiplies the total XP cost of repairing an item and rounds up.\nHigher values means the recipe will cost more to repair, lower means less. Set to 0 to disable the cost altogether.");
        this.configEntry("uncrafting_recipes", "Disabled Recipes", "If you don't want to disable uncrafting altogether, and would rather disable certain recipes, this is for you.\nTo add a recipe, add the mod id followed by the name of the recipe. You can check this in things like JEI.\nExample: \"twilightforest:firefly_particle_spawner\" will disable uncrafting the particle spawner into a firefly jar, firefly, and poppy.\nIf an item has multiple crafting recipes and you wish to disable them all, add the item to the \"twilightforest:banned_uncraftables\" item tag.\nIf you have a problematic ingredient, like infested towerwood for example, add the item to the \"twilightforest:banned_uncrafting_ingredients\" item tag.");
        this.configEntry("uncrafting_recipes_flip", "Recipe Blacklist", "If true, this will invert the above uncrafting recipe list from a blacklist to a whitelist.");
        this.configEntry("uncrafting_mod_ids", "Disabled Mod IDs", "Here, you can disable all items from certain mods from being uncrafted.\nInput a valid mod id to disable all uncrafting recipes from that mod.\nExample: \"twilightforest\" will disable all uncrafting recipes from this mod.");
        this.configEntry("uncrafting_mod_id_flip", "Mod ID Blacklist", "If true, this will invert the above option from a blacklist to a whitelist.");
        this.configEntry("shapeless_uncrafting", "Shapeless Uncrafting", "If true, the uncrafting table will also be allowed to uncraft shapeless recipes.\nThe table was originally intended to only take shaped recipes, but this option remains for people who wish to keep the functionality.");
        this.configEntry("ingredient_switching", "Disable Ingredient Switching", "If true, the uncrafting table will no longer allow you to switch between ingredients if a recipe uses a tag for crafting.\nThis will remove the functionality for ALL RECIPES!\nIf you want to prevent certain ingredients from showing up in the first place, use the \"twilightforest:banned_uncrafting_ingredients\" tag.");
        this.configEntry("disable_uncrafting", "Disable Uncrafting", "Disables the uncrafting function of the uncrafting table. Recommended as a last resort if there's too many things to change about its behavior (or you're just lazy, I dont judge).\nDo note that special uncrafting recipes are not disabled as the mod relies on them for other things.");
        this.configEntry("disable_uncrafting_table", "Disable Uncrafting Table", "Disables any usage of the uncrafting table, as well as prevents it from showing up in loot or crafted.\nPlease note that table has more uses than just uncrafting, you can read about them here! http://benimatic.com/tfwiki/index.php?title=Uncrafting_Table\nIt is highly recommended to keep the table enabled as the mod has special uncrafting exclusive recipes, but the option remains for people that dont want the table to be functional at all.\nIf you are looking to just prevent normal crafting recipes from being reversed, consider using the 'disableUncrafting' option instead.");
        this.configCategory("magic_trees", "Magic Trees", "Settings for all things related to the magic trees.");
        this.configEntry("time_range", "Tree of Time Range", "Defines the radius at which the Timewood Core works. Can be a number anywhere between 1 and 128.\nSet to 0 to prevent the Timewood Core from functioning.");
        this.configEntry("transformation_range", "Tree of Transformation Range", "Defines the radius at which the Transformation Core works. Can be a number anywhere between 1 and 128.\nSet to 0 to prevent the Transformation Core from functioning.");
        this.configEntry("mining_range", "Miner's Tree Range", "Defines the radius at which the Minewood Core works. Can be a number anywhere between 1 and 128.\nSet to 0 to prevent the Minewood Core from functioning.");
        this.configEntry("sorting_range", "Sorting Tree Range", "Defines the radius at which the Sortingwood Core works. Can be a number anywhere between 1 and 128.\nSet to 0 to prevent the Sortingwood Core from functioning.");
        this.configEntry("shield", "Shield Interactions", "We recommend downloading the Shield Parry mod for parrying, but these controls remain for without.");
        this.configEntry("parry_non_twilight", "Parry Non-TF Projectiles", "Set to true to parry non-Twilight projectiles.");
        this.configEntry("parry_window", "Parry Window", "The amount of ticks after raising a shield that makes it OK to parry a projectile. (1 tick = 1/20 second)");
        this.configEntry("casket_uuid_locking", "Casket UUID Locking", "If true, Keepsake Caskets that are spawned when a player dies will not be accessible by other players. Use this if you dont want people taking from other people's death caskets.\nNOTE: server operators will still be able to open locked caskets.");
        this.configEntry("disable_skull_candles", "Disable Skull Candles", "If true, disables the ability to make Skull Candles by right clicking a vanilla skull with a candle. Turn this on if you're having mod conflict issues for some reason.");
        this.configEntry("default_item_enchantments", "Default Item Enchantments", "If false, items that come enchanted when you craft them (such as ironwood or steeleaf gear) will not show this way in the creative inventory.\nPlease note that this doesn't affect the crafting recipes themselves, you will need a datapack to change those.");
        this.configEntry("boss_drop_chests", "Boss Drop Chests", "If true, Twilight Forest's bosses will put their drops inside of a chest where they originally spawned instead of dropping the loot directly.\nNote that the Knight Phantoms are not affected by this as their drops work differently.");
        this.configEntry("cloud_precipitation", "Cloud Precipitation Distance", "Dictates how many blocks down from a cloud block should the game logic check for handling weather related code.\nLower if experiencing low tick rate. Set to 0 to turn all cloud precipitation logic off.");
        this.configEntry("multiplayer_fight_adjuster", "Multiplayer Fight Adjuster", "Determines how bosses should adjust to multiplayer fights. There are 4 possible values that can be put here:\nNONE: doesnt do anything when multiple people participate in a bossfight. Bosses will act the same as they do in singleplayer or solo fights.\nMORE_LOOT: adds additional drops to a boss' loot table based on how many players participated in the fight. These are fully controlled through the entity's loot table, using the `twilightforest:multiplayer_multiplier` loot function. Note that this function will only do things to entities that are included in the `twilightforest:multiplayer_inclusive_entities` tag.\nMORE_HEALTH: increases the health of each boss by 20 hearts for each player nearby when the fight starts.\nMORE_LOOT_AND_HEALTH: does both of the above functions for each boss.");
        this.add("config.twilightforest.multiplayer_fight_adjuster.none", "None");
        this.add("config.twilightforest.multiplayer_fight_adjuster.more_loot", "More Loot");
        this.add("config.twilightforest.multiplayer_fight_adjuster.more_health", "More Health");
        this.add("config.twilightforest.multiplayer_fight_adjuster.more_loot_and_health", "More Loot & Health");
        this.addKeyBindCategory(TFKeyBindsCategories.TRAVELLERS_GEAR, "Twilight Forest (Traveller's Gear)");
        this.addKeyMapping(TFKeyBinds.RED_THREAD_VISION_KEY, "See Red Thread with Goggles");
        this.addKeyMapping(TFKeyBinds.ITEM_DISPLAY_MAP_CYCLE_KEY, "Cycle Item Display's Stored Maps");
        this.addKeyMapping(TFKeyBinds.ZOOM_KEY, "Zoom With Goggles");
        this.addKeyMapping(TFKeyBinds.SWAP_HOTBAR_KEY, "Swap Hotbar");
        this.add("item.twilightforest.travellers_gloves.desc", "Cosmetic");
        this.addTravellersModifier(registries, TravellersModifiersManager.ZOOM_ABILITY, "Zoom (keybind: ${tfkeybinds/" + TFKeyBinds.ZOOM_KEY.getName() + "})");
        this.addTravellersModifier(registries, TravellersModifiersManager.SWIFT_SWIM_ABILITY, "Swift Swim");
        this.addTravellersModifier(registries, TravellersModifiersManager.SWAP_HOTBAR_ABILITY, "Swap Hotbar (keybind: ${tfkeybinds/" + TFKeyBinds.SWAP_HOTBAR_KEY.getName() + "})");
        this.addTravellersModifier(registries, TravellersModifiersManager.HIGH_JUMP_ABILITY, "High Jump");
        this.addTravellersModifier(registries, TravellersModifiersManager.STEP_UP_ABILITY, "Step-Up");
        this.addTravellersModifier(registries, TravellersModifiersManager.AUTO_REPAIR_MODIFIER, "Auto-Repair");
        this.addTravellersDescription(registries, TravellersModifiersManager.AUTO_REPAIR_MODIFIER, "Repairs durability over time");
        this.addTravellersModifier(registries, TravellersModifiersManager.AQUATIC_AGILITY_MODIFIER, "Aquatic Agility");
        this.addTravellersDescription(registries, TravellersModifiersManager.AQUATIC_AGILITY_MODIFIER, "Respiration and Aqua Affinity in one");
        this.addTravellersModifier(registries, TravellersModifiersManager.RED_THREAD_VISION_MODIFIER, "Red Thread Vision (keybind: ${tfkeybinds/" + TFKeyBinds.RED_THREAD_VISION_KEY.getName() + "})");
        this.addTravellersDescription(registries, TravellersModifiersManager.RED_THREAD_VISION_MODIFIER, "Allows you to see placed Red Thread");
        this.addTravellersModifier(registries, TravellersModifiersManager.ALL_NIGHT_GOGGLES_MODIFIER, "All-Night Goggles");
        this.addTravellersDescription(registries, TravellersModifiersManager.ALL_NIGHT_GOGGLES_MODIFIER, "Prevents Insomnia and Enderman aggression");
        this.addTravellersModifier(registries, TravellersModifiersManager.ITEM_DISPLAY_MODIFIER, "Item Display (keybind: ${tfkeybinds/" + TFKeyBinds.ITEM_DISPLAY_MAP_CYCLE_KEY.getName() + "})");
        this.addTravellersDescription(registries, TravellersModifiersManager.ITEM_DISPLAY_MODIFIER, "Right-click items on the Goggles to add displays");
        this.add("travellers_gear.modifier.twilightforest.item_display.clock.unknown", "Time Unknown");
        this.add("travellers_gear.modifier.twilightforest.item_display.compass.lodestone", "%s (%s blocks away)");
        this.addTravellersModifier(registries, TravellersModifiersManager.STEALTH_MODIFIER, "Stealth (sneak to activate)");
        this.addTravellersDescription(registries, TravellersModifiersManager.STEALTH_MODIFIER, "Sneak to turn invisible");
        this.addTravellersModifier(registries, TravellersModifiersManager.ARROW_MAGNETISM_MODIFIER, "Arrow Magnetism");
        this.addTravellersDescription(registries, TravellersModifiersManager.ARROW_MAGNETISM_MODIFIER, "Retrieves missed arrows");
        this.addTravellersModifier(registries, TravellersModifiersManager.EFFICIENT_EATER_MODIFIER, "Efficient Eater");
        this.addTravellersDescription(registries, TravellersModifiersManager.EFFICIENT_EATER_MODIFIER, "Reduces movement-based hunger drain");
        this.addTravellersModifier(registries, TravellersModifiersManager.PERFECT_DODGE_MODIFIER, "Perfect Dodge");
        this.addTravellersDescription(registries, TravellersModifiersManager.PERFECT_DODGE_MODIFIER, "30% chance to dodge projectiles");
        this.addTravellersModifier(registries, TravellersModifiersManager.HASTE_MODIFIER, "Haste");
        this.addTravellersDescription(registries, TravellersModifiersManager.HASTE_MODIFIER, "Grants Haste II");
        this.addTravellersModifier(registries, TravellersModifiersManager.SWAP_HOTBAR_MODIFIER, "Swap Hotbar (keybind: ${tfkeybinds/" + TFKeyBinds.SWAP_HOTBAR_KEY.getName() + "})");
        this.addTravellersDescription(registries, TravellersModifiersManager.SWAP_HOTBAR_MODIFIER, "Allows you to store and withdraw your hotbar");
        this.addTravellersModifier(registries, TravellersModifiersManager.GRADUAL_GLIDE_MODIFIER, "Gradual Glide (sneak to activate)");
        this.addTravellersDescription(registries, TravellersModifiersManager.GRADUAL_GLIDE_MODIFIER, "Allows for gliding through the air");
        this.addTravellersModifier(registries, TravellersModifiersManager.AGILE_RANGER_MODIFIER, "Agile Ranger");
        this.addTravellersDescription(registries, TravellersModifiersManager.AGILE_RANGER_MODIFIER, "Allows normal movement when using bow-like items");
        this.addTravellersModifier(registries, TravellersModifiersManager.DOUBLE_JUMP_MODIFIER, "Double Jump");
        this.addTravellersDescription(registries, TravellersModifiersManager.DOUBLE_JUMP_MODIFIER, "Lets you do a second jump in mid-air");
        this.addTravellersModifier(registries, TravellersModifiersManager.SIDESTEP_MODIFIER, "Sidestep");
        this.addTravellersDescription(registries, TravellersModifiersManager.SIDESTEP_MODIFIER, "Double-tap %s or %s to do a dash");
        this.addTravellersModifier(registries, TravellersModifiersManager.STRAIGHT_AHEAD_MODIFIER, "Straight Ahead");
        this.addTravellersDescription(registries, TravellersModifiersManager.STRAIGHT_AHEAD_MODIFIER, "Increases forward movement speed");
        this.addTravellersModifier(registries, TravellersModifiersManager.SLIMY_SOLES_MODIFIER, "Slimy Soles");
        this.addTravellersDescription(registries, TravellersModifiersManager.SLIMY_SOLES_MODIFIER, "Prevents fall damage by making you bounce");
        this.addTravellersModifier(registries, TravellersModifiersManager.UNRESTRAINED_MODIFIER, "Unrestrained");
        this.addTravellersDescription(registries, TravellersModifiersManager.UNRESTRAINED_MODIFIER, "Prevents blocks from slowing you down");
        this.addTravellersModifier(registries, TravellersModifiersManager.WATER_WALK_MODIFIER, "Water Walk");
        this.addTravellersDescription(registries, TravellersModifiersManager.WATER_WALK_MODIFIER, "Allows you to walk on Water");
        this.add("travellers_gear.ability", "Ability: %s");
        this.add("travellers_gear.modifier.empty", "Empty");
        this.add("travellers_gear.broken", " (Broken)");
        this.add("travellers_gear.shift_info", "Hold %s for info");
        this.add("travellers_gear.info_indent", "  \u2937 ");
    }
}

