/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat.rei.displays;

import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.registry.RecipeManagerContext;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.Nullable;
import twilightforest.compat.rei.TFREIServerPlugin;
import twilightforest.item.recipe.UncraftingRecipe;

public class REIUncraftingDisplay
extends BasicDisplay {
    private final RecipeHolder<? extends CraftingRecipe> recipe;

    private REIUncraftingDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, RecipeHolder<? extends CraftingRecipe> recipe) {
        super(inputs, outputs, Optional.of(recipe.id()));
        this.recipe = recipe;
    }

    public static REIUncraftingDisplay ofUncrafting(RecipeHolder<UncraftingRecipe> recipe) {
        RegistryAccess registryAccess = REIUncraftingDisplay.registryAccess();
        List inputs = EntryIngredients.ofIngredients((List)((UncraftingRecipe)recipe.value()).getIngredients());
        List<EntryIngredient> outputs = List.of(EntryIngredients.of((ItemStack)((UncraftingRecipe)recipe.value()).getResultItem((HolderLookup.Provider)registryAccess)));
        return new REIUncraftingDisplay(inputs, outputs, recipe);
    }

    public static REIUncraftingDisplay of(RecipeHolder<CraftingRecipe> recipe) {
        boolean isUncraftingRecipe = recipe.value() instanceof UncraftingRecipe;
        RegistryAccess registryAccess = REIUncraftingDisplay.registryAccess();
        List<EntryIngredient> inputs = isUncraftingRecipe ? EntryIngredients.ofIngredients((List)((CraftingRecipe)recipe.value()).getIngredients()) : List.of(EntryIngredients.of((ItemStack)((CraftingRecipe)recipe.value()).getResultItem((HolderLookup.Provider)registryAccess)));
        List<EntryIngredient> outputs = isUncraftingRecipe ? List.of(EntryIngredients.of((ItemStack)((CraftingRecipe)recipe.value()).getResultItem((HolderLookup.Provider)registryAccess))) : EntryIngredients.ofIngredients((List)((CraftingRecipe)recipe.value()).getIngredients());
        return new REIUncraftingDisplay(inputs, outputs, recipe);
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return TFREIServerPlugin.UNCRAFTING;
    }

    public CraftingRecipe getRecipe() {
        return (CraftingRecipe)this.recipe.value();
    }

    public ResourceLocation getRecipeId() {
        return this.recipe.id();
    }

    public static enum Serializer implements DisplaySerializer<REIUncraftingDisplay>
    {
        INSTANCE;


        public CompoundTag save(CompoundTag tag, REIUncraftingDisplay display) {
            tag.putString("recipe_id", display.getRecipeId().toString());
            return tag;
        }

        @Nullable
        public REIUncraftingDisplay read(CompoundTag tag) {
            Optional recipe;
            ResourceLocation location = ResourceLocation.tryParse((String)tag.getString("recipe_id"));
            if (location != null && (recipe = RecipeManagerContext.getInstance().getRecipeManager().byKey(location)).isPresent()) {
                return REIUncraftingDisplay.of((RecipeHolder<CraftingRecipe>)((RecipeHolder)recipe.get()));
            }
            return null;
        }
    }
}

