/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat.jei.categories;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import twilightforest.TwilightForestMod;
import twilightforest.compat.jei.JEICompat;
import twilightforest.compat.jei.renderers.EntityRenderer;
import twilightforest.compat.jei.util.TransformationRecipe;
import twilightforest.init.TFItems;

public class TransformationPowderCategory
implements IRecipeCategory<TransformationRecipe> {
    public static final RecipeType<TransformationRecipe> TRANSFORMATION = RecipeType.create((String)"twilightforest", (String)"transformation_powder", TransformationRecipe.class);
    private final IDrawable icon;
    private final IDrawable arrow;
    private final IDrawable slot;
    private final IDrawable doubleArrow;
    private final Component localizedName;
    private final EntityRenderer entityRenderer = new EntityRenderer(32);

    public TransformationPowderCategory(IGuiHelper helper) {
        this.arrow = helper.drawableBuilder(TwilightForestMod.getGuiTexture("transformation_arrow.png"), 0, 0, 23, 30).setTextureSize(23, 30).build();
        this.doubleArrow = helper.drawableBuilder(TwilightForestMod.getGuiTexture("transformation_double_arrow.png"), 0, 0, 23, 30).setTextureSize(23, 30).build();
        this.slot = helper.drawableBuilder(TwilightForestMod.getGuiTexture("big_slot.png"), 0, 0, 34, 34).setTextureSize(34, 34).build();
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)((Item)TFItems.TRANSFORMATION_POWDER.get()).getDefaultInstance());
        this.localizedName = Component.translatable((String)"gui.twilightforest.transformation_jei");
    }

    public RecipeType<TransformationRecipe> getRecipeType() {
        return TRANSFORMATION;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public int getWidth() {
        return 116;
    }

    public int getHeight() {
        return 54;
    }

    public void draw(TransformationRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        if (recipe.isReversible()) {
            this.doubleArrow.draw(graphics, 46, 7);
        } else {
            this.arrow.draw(graphics, 46, 7);
        }
        this.slot.draw(graphics, 7, 10);
        this.slot.draw(graphics, 75, 10);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, TransformationRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 8, 11).setCustomRenderer(JEICompat.ENTITY_TYPE, (IIngredientRenderer)this.entityRenderer).addIngredient(JEICompat.ENTITY_TYPE, (Object)recipe.input());
        SpawnEggItem inputEgg = DeferredSpawnEggItem.byId(recipe.input().type());
        if (inputEgg != null) {
            builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStack(new ItemStack((ItemLike)inputEgg));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 76, 11).setCustomRenderer(JEICompat.ENTITY_TYPE, (IIngredientRenderer)this.entityRenderer).addIngredient(JEICompat.ENTITY_TYPE, (Object)recipe.output());
        SpawnEggItem outputEgg = DeferredSpawnEggItem.byId(recipe.output().type());
        if (outputEgg != null) {
            builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStack(new ItemStack((ItemLike)outputEgg));
        }
    }
}

