/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat.emi.recipes;

import dev.emi.emi.EmiPort;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.Nullable;

public abstract class TFEmiRecipe<T extends Recipe<?>>
implements EmiRecipe {
    private final EmiRecipeCategory category;
    private final RecipeHolder<T> recipe;
    private final ResourceLocation id;
    private final int width;
    private final int height;
    private final List<EmiIngredient> inputs;
    private final List<EmiStack> outputs;

    public TFEmiRecipe(EmiRecipeCategory category, RecipeHolder<T> recipe, String prefix, int width, int height) {
        this(category, recipe, EmiPort.getId((Recipe)recipe.value()).withPrefix(prefix), width, height);
    }

    public TFEmiRecipe(EmiRecipeCategory category, RecipeHolder<T> recipe, ResourceLocation id, int width, int height) {
        this.category = category;
        this.recipe = recipe;
        this.width = width;
        this.height = height;
        this.id = id;
        this.inputs = new ArrayList<EmiIngredient>();
        this.inputs.addAll(recipe.value().getIngredients().stream().map(EmiIngredient::of).toList());
        this.addAdditionalInputs(this.inputs);
        this.outputs = new ArrayList<EmiStack>();
        this.outputs.add(EmiStack.of((ItemStack)recipe.value().getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess())));
        this.addAdditionalOutputs(this.outputs);
    }

    protected abstract void addAdditionalInputs(List<EmiIngredient> var1);

    protected abstract void addAdditionalOutputs(List<EmiStack> var1);

    public RecipeHolder<T> getRecipe() {
        return this.recipe;
    }

    public EmiRecipeCategory getCategory() {
        return this.category;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public int getDisplayWidth() {
        return this.width;
    }

    public int getDisplayHeight() {
        return this.height;
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }
}

