/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat.emi;

import com.mojang.datafixers.util.Pair;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiPatternCraftingRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.recipe.EmiAnvilRecipe;
import dev.emi.emi.recipe.EmiGrindstoneRecipe;
import dev.emi.emi.recipe.special.EmiAnvilEnchantRecipe;
import dev.emi.emi.recipe.special.EmiAnvilRepairItemRecipe;
import dev.emi.emi.recipe.special.EmiGrindstoneDisenchantingRecipe;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import twilightforest.compat.RecipeViewerConstants;
import twilightforest.compat.emi.TFEmiCategories;
import twilightforest.compat.emi.recipes.EmiCrumbleHornRecipe;
import twilightforest.compat.emi.recipes.EmiDryingRecipe;
import twilightforest.compat.emi.recipes.EmiEmperorsClothRecipe;
import twilightforest.compat.emi.recipes.EmiMoonwormQueenRecipe;
import twilightforest.compat.emi.recipes.EmiNoSmithingTemplateRecipe;
import twilightforest.compat.emi.recipes.EmiOminousFireRecipe;
import twilightforest.compat.emi.recipes.EmiScepterRepairRecipe;
import twilightforest.compat.emi.recipes.EmiTransformationPowderRecipe;
import twilightforest.compat.emi.recipes.EmiTravellersGearGrindstoneRecipe;
import twilightforest.compat.emi.recipes.EmiTravellersGearModifierRecipe;
import twilightforest.compat.emi.recipes.EmiUncraftingRecipe;
import twilightforest.config.TFConfig;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFItems;
import twilightforest.init.TFRecipes;
import twilightforest.init.custom.TravellersModifiersManager;
import twilightforest.item.recipe.DryingRecipe;
import twilightforest.item.recipe.EmperorsClothRecipe;
import twilightforest.item.recipe.MoonwormQueenRepairRecipe;
import twilightforest.item.recipe.NoTemplateSmithingRecipe;
import twilightforest.item.recipe.ScepterRepairRecipe;
import twilightforest.item.recipe.travellers.TravellersGearModifierRecipe;

@EmiEntrypoint
public class TFEmiCompat
implements EmiPlugin {
    private static final Function<List<EmiIngredient>, Boolean> CANT_USE_ENCHANTS = stack -> stack.contains(EmiStack.of(TFItems.MOONWORM_QUEEN)) || stack.contains(EmiStack.of(TFItems.LAMP_OF_CINDERS)) || stack.contains(EmiStack.of(TFItems.ORE_MAGNET)) || stack.contains(EmiStack.of(TFItems.TWILIGHT_SCEPTER)) || stack.contains(EmiStack.of(TFItems.LIFEDRAIN_SCEPTER)) || stack.contains(EmiStack.of(TFItems.ZOMBIE_SCEPTER)) || stack.contains(EmiStack.of(TFItems.FORTIFICATION_SCEPTER)) || stack.contains(EmiStack.of(TFItems.TRAVELLERS_GOGGLES)) || stack.contains(EmiStack.of(TFItems.TRAVELLERS_VEST)) || stack.contains(EmiStack.of(TFItems.TRAVELLERS_GLOVES)) || stack.contains(EmiStack.of(TFItems.TRAVELLERS_BELT)) || stack.contains(EmiStack.of(TFItems.TRAVELLERS_WINGS)) || stack.contains(EmiStack.of(TFItems.TRAVELLERS_BOOTS));
    private static final Function<List<EmiIngredient>, Boolean> NO_REPAIRING = stack -> stack.contains(EmiStack.of(TFItems.LAMP_OF_CINDERS)) || stack.contains(EmiStack.of(TFItems.GLASS_SWORD)) || stack.contains(EmiStack.of(TFItems.MAZEBREAKER_PICKAXE));

    public void register(EmiRegistry registry) {
        registry.addCategory((EmiRecipeCategory)TFEmiCategories.UNCRAFTING);
        registry.addCategory((EmiRecipeCategory)TFEmiCategories.CRUMBLE_HORN);
        registry.addCategory((EmiRecipeCategory)TFEmiCategories.TRANSFORMATION);
        registry.addCategory((EmiRecipeCategory)TFEmiCategories.EXANIMATE);
        registry.addCategory((EmiRecipeCategory)TFEmiCategories.DRYING);
        if (!TFConfig.disableEntireTable) {
            registry.addWorkstation(VanillaEmiRecipeCategories.CRAFTING, (EmiIngredient)EmiStack.of(TFBlocks.UNCRAFTING_TABLE));
            registry.addWorkstation((EmiRecipeCategory)TFEmiCategories.UNCRAFTING, (EmiIngredient)EmiStack.of(TFBlocks.UNCRAFTING_TABLE));
        }
        registry.addWorkstation((EmiRecipeCategory)TFEmiCategories.CRUMBLE_HORN, (EmiIngredient)EmiStack.of(TFItems.CRUMBLE_HORN));
        registry.addWorkstation((EmiRecipeCategory)TFEmiCategories.TRANSFORMATION, (EmiIngredient)EmiStack.of(TFItems.TRANSFORMATION_POWDER));
        registry.addWorkstation((EmiRecipeCategory)TFEmiCategories.EXANIMATE, (EmiIngredient)EmiStack.of(TFItems.EXANIMATE_ESSENCE));
        RecipeManager manager = Objects.requireNonNull(Minecraft.getInstance().level).getRecipeManager();
        if (!TFConfig.disableEntireTable) {
            List<RecipeHolder<? extends CraftingRecipe>> recipes = RecipeViewerConstants.getAllUncraftingRecipes(manager);
            recipes.forEach(recipe -> registry.addRecipe(new EmiUncraftingRecipe(recipe)));
        }
        for (RecipeViewerConstants.TransformationPowderInfo transformationPowderInfo : RecipeViewerConstants.getTransformationPowderRecipes()) {
            registry.addRecipe((EmiRecipe)new EmiTransformationPowderRecipe(transformationPowderInfo.input(), transformationPowderInfo.output(), transformationPowderInfo.reversible()));
        }
        for (RecipeViewerConstants.OminousFireInfo ominousFireInfo : RecipeViewerConstants.getOminousFireRecipes()) {
            registry.addRecipe((EmiRecipe)new EmiOminousFireRecipe(ominousFireInfo.input(), ominousFireInfo.output()));
        }
        for (Pair pair : RecipeViewerConstants.getCrumbleHornRecipes()) {
            registry.addRecipe((EmiRecipe)new EmiCrumbleHornRecipe((Block)pair.getFirst(), (Block)pair.getSecond()));
        }
        for (RecipeHolder recipeHolder : manager.getAllRecipesFor(RecipeType.SMITHING).stream().filter(holder -> holder.value() instanceof NoTemplateSmithingRecipe).toList()) {
            NoTemplateSmithingRecipe recipe2 = (NoTemplateSmithingRecipe)recipeHolder.value();
            registry.addRecipe((EmiRecipe)new EmiNoSmithingTemplateRecipe(EmiIngredient.of((Ingredient)recipe2.getBase()), EmiIngredient.of((Ingredient)recipe2.getAddition()), EmiStack.of((ItemStack)recipe2.getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess())), recipe2));
        }
        for (RecipeHolder recipeHolder : manager.getAllRecipesFor((RecipeType)TFRecipes.DRYING_RECIPE.get())) {
            if (((DryingRecipe)recipeHolder.value()).getResult().is(TFItems.STALE_BREAD)) continue;
            registry.addRecipe((EmiRecipe)new EmiDryingRecipe((RecipeHolder<DryingRecipe>)recipeHolder));
        }
        EmiTravellersGearGrindstoneRecipe.register(registry);
        for (RecipeHolder recipeHolder : manager.getAllRecipesFor(RecipeType.CRAFTING)) {
            EmiMoonwormQueenRecipe emiRecipe;
            Recipe recipe2;
            Objects.requireNonNull(recipeHolder.value());
            int n = 0;
            if ((emiRecipe = (switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MoonwormQueenRepairRecipe.class, EmperorsClothRecipe.class, ScepterRepairRecipe.class, TravellersGearModifierRecipe.class}, (Object)recipe2, n)) {
                case 0 -> {
                    MoonwormQueenRepairRecipe ignored = (MoonwormQueenRepairRecipe)recipe2;
                    yield new EmiMoonwormQueenRecipe();
                }
                case 1 -> {
                    EmperorsClothRecipe ignored = (EmperorsClothRecipe)recipe2;
                    yield new EmiEmperorsClothRecipe();
                }
                case 2 -> {
                    ScepterRepairRecipe recipe = (ScepterRepairRecipe)recipe2;
                    yield new EmiScepterRepairRecipe(recipe.getIngredients().stream().map(EmiIngredient::of).toList(), EmiStack.of((ItemLike)recipe.getScepter()), recipe.getRepairDurability(), recipeHolder.id());
                }
                case 3 -> {
                    TravellersGearModifierRecipe recipe = (TravellersGearModifierRecipe)recipe2;
                    if (TravellersModifiersManager.isModifierEnabled((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess(), recipe.getTravellersModifierKey())) {
                        yield new EmiTravellersGearModifierRecipe(recipe);
                    }
                    yield null;
                }
                default -> null;
            })) == null) continue;
            registry.addRecipe((EmiRecipe)emiRecipe);
        }
        registry.removeRecipes(recipe -> {
            if (recipe instanceof EmiPatternCraftingRecipe || recipe instanceof EmiGrindstoneRecipe) {
                return recipe.getInputs().contains(EmiStack.of(TFItems.MOONWORM_QUEEN)) || NO_REPAIRING.apply(recipe.getInputs()) != false;
            }
            if (recipe instanceof EmiGrindstoneDisenchantingRecipe || recipe instanceof EmiAnvilEnchantRecipe) {
                return CANT_USE_ENCHANTS.apply(recipe.getInputs());
            }
            if (recipe instanceof EmiAnvilRepairItemRecipe || recipe instanceof EmiAnvilRecipe) {
                return NO_REPAIRING.apply(recipe.getInputs());
            }
            return false;
        });
        registry.removeEmiStacks(stack -> TFItems.MAGIC_PAINTING.getId().equals((Object)stack.getId()));
    }
}

