/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import twilightforest.TwilightForestMod;
import twilightforest.client.model.TFModelLayers;
import twilightforest.client.model.entity.CubeOfAnnihilationModel;
import twilightforest.entity.RovingCube;

public class RovingCubeRenderer<T extends RovingCube>
extends EntityRenderer<T> {
    private static final ResourceLocation TEXTURE = TwilightForestMod.getModelTexture("cubeofannihilation.png");
    private final Model model;

    public RovingCubeRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new CubeOfAnnihilationModel(context.bakeLayer(TFModelLayers.CUBE_OF_ANNIHILATION));
    }

    public void render(T entity, float yaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int light) {
        stack.pushPose();
        VertexConsumer consumer = buffer.getBuffer(this.model.renderType(TEXTURE));
        stack.scale(2.0f, 2.0f, 2.0f);
        stack.mulPose(Axis.YP.rotationDegrees(Mth.wrapDegrees((float)((float)((RovingCube)((Object)entity)).tickCount + partialTicks)) * 11.0f));
        stack.translate(0.0f, 0.75f, 0.0f);
        this.model.renderToBuffer(stack, consumer, light, OverlayTexture.NO_OVERLAY);
        stack.popPose();
    }

    public ResourceLocation getTextureLocation(T entity) {
        return TEXTURE;
    }
}

