/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.Tags;
import twilightforest.block.DryingRackBlock;
import twilightforest.block.entity.DryingRackBlockEntity;
import twilightforest.data.tags.ItemTagGenerator;

public class DryingRackRenderer
implements BlockEntityRenderer<DryingRackBlockEntity> {
    private final ItemRenderer itemRenderer;

    public DryingRackRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.getItemRenderer();
    }

    public void render(DryingRackBlockEntity entity, float partialTick, PoseStack stack, MultiBufferSource source, int light, int overlay) {
        ItemStack item = entity.getTheItem();
        if (item.isEmpty()) {
            return;
        }
        Level level = entity.getLevel();
        BakedModel model = this.itemRenderer.getModel(item, level, null, 0);
        Direction dir = (Direction)entity.getBlockState().getValue((Property)DryingRackBlock.FACING);
        stack.pushPose();
        stack.translate(0.4f * (float)dir.getStepX() + 0.5f, model.isGui3d() ? 0.5f : (item.is(ItemTagGenerator.RENDER_LOWER_ON_DRYING_RACK) ? 0.325f : 0.45f), 0.4f * (float)dir.getStepZ() + 0.5f);
        if (item.is(ItemTags.BANNERS)) {
            stack.translate(0.0f, -0.4f, 0.0f);
        }
        if (item.is(Tags.Items.TOOLS_SHIELD)) {
            stack.translate(0.0f, -0.1f, 0.0f);
        }
        stack.scale(0.99f, 0.99f, 0.99f);
        stack.mulPose(Axis.YP.rotationDegrees(-dir.toYRot()));
        this.itemRenderer.renderStatic(entity.getTheItem(), ItemDisplayContext.FIXED, light, overlay, stack, source, level, (int)entity.getBlockPos().asLong());
        stack.popPose();
    }
}

