/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.overlay.display;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.joml.Matrix4f;
import twilightforest.client.overlay.display.ItemDisplay;

public class MapDisplay
implements ItemDisplay {
    private static final RenderType MAP_BACKGROUND = RenderType.text((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"textures/map/map_background.png"));
    private static final RenderType MAP_BACKGROUND_CHECKERBOARD = RenderType.text((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"textures/map/map_background_checkerboard.png"));

    @Override
    public void render(ItemStack item, GuiGraphics graphics, Minecraft minecraft, Gui gui, Player player, int widestWidgetWidth) {
        PoseStack stack = graphics.pose();
        MapId mapid = (MapId)item.get(DataComponents.MAP_ID);
        if (mapid == null) {
            return;
        }
        MapItemSavedData data = MapItem.getSavedData((ItemStack)item, (Level)minecraft.level);
        if (data == null) {
            return;
        }
        VertexConsumer consumer = graphics.bufferSource().getBuffer(MAP_BACKGROUND_CHECKERBOARD);
        Matrix4f matrix4f = stack.last().pose();
        float start = Math.max(widestWidgetWidth / 2 - 50, 0);
        consumer.addVertex(matrix4f, start, 100.0f, -2.0f).setColor(-1).setUv(0.0f, 1.0f).setLight(0xF000F0);
        consumer.addVertex(matrix4f, start + 100.0f, 100.0f, -2.0f).setColor(-1).setUv(1.0f, 1.0f).setLight(0xF000F0);
        consumer.addVertex(matrix4f, start + 100.0f, 0.0f, -2.0f).setColor(-1).setUv(1.0f, 0.0f).setLight(0xF000F0);
        consumer.addVertex(matrix4f, start, 0.0f, -2.0f).setColor(-1).setUv(0.0f, 0.0f).setLight(0xF000F0);
        stack.pushPose();
        stack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        stack.translate(-4.75f, -4.75f, -1.0f);
        stack.translate(-start, 0.0f, 0.0f);
        stack.scale(0.7075f, 0.7075f, -0.7075f);
        stack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        minecraft.gameRenderer.getMapRenderer().render(stack, (MultiBufferSource)graphics.bufferSource(), mapid, data, false, 0xF000F0);
        graphics.flush();
        stack.popPose();
    }

    @Override
    public ItemDisplay.DisplayPosition displayPosition() {
        return ItemDisplay.DisplayPosition.TOP;
    }

    @Override
    public ItemDisplay.Bounds getWidgetSize(ItemStack item, Minecraft minecraft, Gui gui, Player player, int widestWidgetWidth) {
        return new ItemDisplay.Bounds(Math.max(widestWidgetWidth / 2 - 50, 0), 0, 100, 102);
    }
}

