/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.overlay;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.GameType;
import net.neoforged.api.distmarker.Dist;
import twilightforest.TwilightForestMod;
import twilightforest.beanification.Autowired;
import twilightforest.config.TFConfig;
import twilightforest.entity.passive.QuestRam;
import twilightforest.entity.passive.quest.ram.QuestingRamCurrentContext;

public class QuestingRamIndicatorOverlay {
    private static final ResourceLocation QUESTING_RAM_CHECK_SPRITE = TwilightForestMod.prefix("questing_ram_check");
    private static final ResourceLocation QUESTING_RAM_X_SPRITE = TwilightForestMod.prefix("questing_ram_x");
    @Autowired(dist={Dist.CLIENT})
    private static QuestingRamCurrentContext questingRamCurrentContext;

    public static void render(Minecraft minecraft, GuiGraphics graphics, Gui gui, Player player) {
        Entity entity;
        if (player != null && !minecraft.options.hideGui && TFConfig.showQuestRamCrosshairIndicator && minecraft.options.getCameraType().isFirstPerson() && (minecraft.gameMode.getPlayerMode() != GameType.SPECTATOR || gui.canRenderCrosshairForSpectator(minecraft.hitResult)) && (entity = minecraft.crosshairPickEntity) instanceof QuestRam) {
            QuestRam ram = (QuestRam)entity;
            ItemStack stack = player.getInventory().getItem(player.getInventory().selected);
            if (!stack.isEmpty()) {
                for (Map.Entry<DyeColor, Ingredient> questEntry : questingRamCurrentContext.getContext().questItems().entrySet()) {
                    if (!questEntry.getValue().test(stack)) continue;
                    RenderSystem.enableBlend();
                    RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    int j = (graphics.guiHeight() - 1) / 2 - 11;
                    int k = (graphics.guiHeight() - 1) / 2 - 3;
                    if (!ram.isColorPresent(questEntry.getKey())) {
                        graphics.blitSprite(QUESTING_RAM_X_SPRITE, k, j, 7, 7);
                    } else {
                        graphics.blitSprite(QUESTING_RAM_CHECK_SPRITE, k, j, 7, 7);
                    }
                    RenderSystem.defaultBlendFunc();
                    RenderSystem.disableBlend();
                    break;
                }
            }
        }
    }
}

