/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import twilightforest.TwilightForestMod;
import twilightforest.client.model.entity.TFGhastModel;
import twilightforest.client.model.entity.TrophyBlockModel;
import twilightforest.client.renderer.entity.UrGhastRenderer;
import twilightforest.entity.boss.UrGhast;

public class UrGhastModel
extends TFGhastModel<UrGhast>
implements TrophyBlockModel {
    private final ModelPart[][] tentacles = new ModelPart[9][4];
    private final ModelPart body;

    public UrGhastModel(ModelPart root) {
        super(root);
        this.body = root.getChild("body");
        for (int i = 0; i < this.tentacles.length; ++i) {
            this.tentacles[i][0] = this.body.getChild("tentacle_" + i);
            this.tentacles[i][1] = this.tentacles[i][0].getChild("tentacle_" + i + "_extension");
            this.tentacles[i][2] = this.tentacles[i][1].getChild("tentacle_" + i + "_extension_2");
            this.tentacles[i][3] = this.tentacles[i][2].getChild("tentacle_" + i + "_tip");
        }
    }

    public static LayerDefinition create() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -8.0f, -8.0f, 16.0f, 16.0f, 16.0f), PartPose.offset((float)0.0f, (float)8.0f, (float)0.0f));
        for (int i = 0; i < 9; ++i) {
            UrGhastModel.makeTentacle(body, "tentacle_" + i, i);
        }
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    protected static void makeTentacle(PartDefinition parent, String name, int iteration) {
        CubeListBuilder cubeListBuilder = CubeListBuilder.create().texOffs(iteration % 3, 0).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 5.0f, 3.0f);
        PartDefinition tentacleBase = parent.addOrReplaceChild(name, cubeListBuilder, switch (iteration) {
            case 0 -> PartPose.offset((float)4.5f, (float)7.0f, (float)4.5f);
            case 1 -> PartPose.offset((float)-4.5f, (float)7.0f, (float)4.5f);
            case 2 -> PartPose.offset((float)0.0f, (float)7.0f, (float)0.0f);
            case 3 -> PartPose.offset((float)5.5f, (float)7.0f, (float)-4.5f);
            case 4 -> PartPose.offset((float)-5.5f, (float)7.0f, (float)-4.5f);
            case 5 -> PartPose.offsetAndRotation((float)-7.5f, (float)3.5f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.7853982f);
            case 6 -> PartPose.offsetAndRotation((float)-7.5f, (float)-1.5f, (float)3.5f, (float)0.0f, (float)0.0f, (float)1.0471976f);
            case 7 -> PartPose.offsetAndRotation((float)7.5f, (float)3.5f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.7853982f);
            case 8 -> PartPose.offsetAndRotation((float)7.5f, (float)-1.5f, (float)3.5f, (float)0.0f, (float)0.0f, (float)-1.0471976f);
            default -> {
                TwilightForestMod.LOGGER.warn("Out of bounds with Ur-Ghast Trophy limb creation: Iteration {}", (Object)iteration);
                yield PartPose.ZERO;
            }
        });
        PartDefinition tentacleExtension = tentacleBase.addOrReplaceChild(name + "_extension", CubeListBuilder.create().texOffs(iteration % 4, 0).addBox(-1.5f, 1.0f, -1.5f, 3.0f, 4.0f, 3.0f), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition tentacleExtension2 = tentacleExtension.addOrReplaceChild(name + "_extension_2", CubeListBuilder.create().texOffs(iteration % 4, 4).addBox(-1.5f, 1.0f, -1.5f, 3.0f, 4.0f, 3.0f), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        tentacleExtension2.addOrReplaceChild(name + "_tip", CubeListBuilder.create().texOffs(iteration % 4, 9).addBox(-1.5f, 1.0f, -1.5f, 3.0f, 4.0f, 3.0f), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
    }

    @Override
    public void setupAnim(UrGhast entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.waveTentacles(limbSwingAmount, ageInTicks);
    }

    private void waveTentacles(float limbSwingAmount, float ageInTicks) {
        for (int i = 0; i < this.tentacles.length; ++i) {
            float wiggle = Math.min(limbSwingAmount, 0.6f);
            float time = (ageInTicks + (float)i * 9.0f) / 2.0f;
            this.tentacles[i][0].xRot = (Mth.cos((float)(time * 0.6662f)) - 1.0471976f) * wiggle;
            this.tentacles[i][1].xRot = Mth.cos((float)(time * 0.7774f)) * 1.2f * wiggle;
            this.tentacles[i][2].xRot = Mth.cos((float)(time * 0.8886f + 1.5707964f)) * 1.4f * wiggle;
            this.tentacles[i][3].xRot = Mth.cos((float)(time * 0.9998f + 0.7853982f)) * 1.6f * wiggle;
            this.tentacles[i][0].xRot = 0.2f + Mth.cos((float)(time * 0.3335f)) * 0.15f;
            this.tentacles[i][1].xRot = 0.1f + Mth.cos((float)(time * 0.4445f)) * 0.2f;
            this.tentacles[i][2].xRot = 0.1f + Mth.cos((float)(time * 0.5555f)) * 0.25f;
            this.tentacles[i][3].xRot = 0.1f + Mth.cos((float)(time * 0.6665f)) * 0.3f;
            float yTwist = 0.4f;
            this.tentacles[i][0].yRot = yTwist * Mth.sin((float)(time * 0.3f));
        }
    }

    @Override
    public void setupRotationsForTrophy(float x, float y, float z, float mouthAngle) {
        this.body.yRot = y * ((float)Math.PI / 180);
        this.body.xRot = z * ((float)Math.PI / 180);
        this.waveTentacles(x, x * 0.2f);
    }

    @Override
    public void renderTrophy(PoseStack stack, MultiBufferSource buffer, int light, int overlay, int color, ItemDisplayContext context) {
        if (context == ItemDisplayContext.NONE) {
            stack.translate(0.0f, -1.0f, 0.0f);
        }
        stack.scale(0.5f, 0.5f, 0.5f);
        VertexConsumer consumer = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)UrGhastRenderer.TEXTURE));
        this.body.render(stack, consumer, light, overlay, color);
    }
}

