/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.FastColor;
import org.jetbrains.annotations.Nullable;
import twilightforest.client.model.entity.HostileWolfModel;
import twilightforest.entity.monster.MistWolf;

public class MistWolfModel
extends HostileWolfModel<MistWolf> {
    @Nullable
    private MistWolf wolf;

    public MistWolfModel(ModelPart root) {
        super(RenderType::entityTranslucent, root);
    }

    public void renderToBuffer(PoseStack stack, VertexConsumer consumer, int light, int overlay, int color) {
        if (this.wolf != null) {
            float brightness = (float)this.wolf.level().getMaxLocalRawBrightness(this.wolf.blockPosition()) / 15.0f;
            float misty = Math.min(1.0f, brightness * 3.0f + 0.25f);
            float smoky = Math.min(1.0f, brightness * 2.0f + 0.3f);
            super.renderToBuffer(stack, consumer, light, overlay, FastColor.ARGB32.colorFromFloat((float)smoky, (float)misty, (float)misty, (float)misty));
        } else {
            super.renderToBuffer(stack, consumer, light, overlay, color);
        }
        this.wolf = null;
    }

    @Override
    public void setupAnim(MistWolf entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.wolf = entity;
    }
}

