/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import twilightforest.client.JappaPackReloadListener;
import twilightforest.entity.boss.Hydra;

public class HydraModel
extends HierarchicalModel<Hydra> {
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart tail;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    @Nullable
    private Hydra hydra;

    public HydraModel(ModelPart root) {
        this.root = root;
        this.body = root.getChild("body");
        this.tail = root.getChild("tail_1");
        this.rightLeg = root.getChild("right_leg");
        this.leftLeg = root.getChild("left_leg");
    }

    public static LayerDefinition checkForPack() {
        return JappaPackReloadListener.INSTANCE.isJappaPackLoaded() ? HydraModel.createJappaModel() : HydraModel.create();
    }

    private static LayerDefinition create() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-48.0f, 0.0f, 0.0f, 96.0f, 96.0f, 40.0f), PartPose.offsetAndRotation((float)0.0f, (float)-12.0f, (float)0.0f, (float)1.22173f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 136).addBox(-16.0f, 0.0f, -16.0f, 32.0f, 48.0f, 32.0f).texOffs(184, 200).addBox(-20.0f, 40.0f, -20.0f, 8.0f, 8.0f, 8.0f).texOffs(184, 200).addBox(-4.0f, 40.0f, -22.0f, 8.0f, 8.0f, 8.0f).texOffs(184, 200).addBox(12.0f, 40.0f, -20.0f, 8.0f, 8.0f, 8.0f), PartPose.offset((float)48.0f, (float)-24.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().mirror().texOffs(0, 136).addBox(-16.0f, 0.0f, -16.0f, 32.0f, 48.0f, 32.0f).texOffs(184, 200).addBox(-20.0f, 40.0f, -20.0f, 8.0f, 8.0f, 8.0f).texOffs(184, 200).addBox(-4.0f, 40.0f, -22.0f, 8.0f, 8.0f, 8.0f).texOffs(184, 200).addBox(12.0f, 40.0f, -20.0f, 8.0f, 8.0f, 8.0f), PartPose.offset((float)-48.0f, (float)-24.0f, (float)0.0f));
        PartDefinition tail1 = partdefinition.addOrReplaceChild("tail_1", CubeListBuilder.create().texOffs(128, 136).addBox(-16.0f, -16.0f, -16.0f, 32.0f, 32.0f, 32.0f).texOffs(128, 200).addBox(-2.0f, -28.0f, -11.0f, 4.0f, 24.0f, 24.0f), PartPose.offset((float)0.0f, (float)6.0f, (float)108.0f));
        PartDefinition tail2 = tail1.addOrReplaceChild("tail_2", CubeListBuilder.create().texOffs(128, 136).addBox(-16.0f, -16.0f, -16.0f, 32.0f, 32.0f, 32.0f).texOffs(128, 200).addBox(-2.0f, -28.0f, -11.0f, 4.0f, 24.0f, 24.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)32.0f));
        PartDefinition tail3 = tail2.addOrReplaceChild("tail_3", CubeListBuilder.create().texOffs(128, 136).addBox(-16.0f, -16.0f, -16.0f, 32.0f, 32.0f, 32.0f).texOffs(128, 200).addBox(-2.0f, -28.0f, -11.0f, 4.0f, 24.0f, 24.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)32.0f));
        tail3.addOrReplaceChild("tail_4", CubeListBuilder.create().texOffs(128, 136).addBox(-16.0f, -16.0f, -16.0f, 32.0f, 32.0f, 32.0f).texOffs(128, 200).addBox(-2.0f, -28.0f, -11.0f, 4.0f, 24.0f, 24.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)32.0f));
        PartDefinition head1 = partdefinition.addOrReplaceChild("head_1", CubeListBuilder.create().texOffs(272, 0).addBox(-16.0f, -14.0f, -32.0f, 32.0f, 24.0f, 32.0f).texOffs(272, 56).addBox(-15.0f, -2.0f, -56.0f, 30.0f, 12.0f, 24.0f).texOffs(128, 200).addBox(-2.0f, -30.0f, -12.0f, 4.0f, 24.0f, 24.0f), PartPose.offset((float)-74.0f, (float)-100.0f, (float)-32.0f));
        head1.addOrReplaceChild("jaw_1", CubeListBuilder.create().texOffs(272, 92).addBox(-15.0f, 0.0f, -48.0f, 30.0f, 8.0f, 48.0f), PartPose.offset((float)0.0f, (float)10.0f, (float)-4.0f));
        head1.addOrReplaceChild("frill_1", CubeListBuilder.create().texOffs(272, 200).addBox(-24.0f, -40.0f, 0.0f, 48.0f, 48.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-10.0f, (float)-0.5235988f, (float)0.0f, (float)0.0f));
        PartDefinition neck1a = partdefinition.addOrReplaceChild("neck_1a", CubeListBuilder.create().texOffs(128, 136).addBox(-16.0f, -16.0f, -16.0f, 32.0f, 32.0f, 32.0f).texOffs(128, 200).addBox(-2.0f, -24.0f, 0.0f, 4.0f, 24.0f, 24.0f), PartPose.offset((float)-42.0f, (float)-48.0f, (float)0.0f));
        PartDefinition neck1b = neck1a.addOrReplaceChild("neck_1b", CubeListBuilder.create().texOffs(128, 136).addBox(-16.0f, -16.0f, -16.0f, 32.0f, 32.0f, 32.0f).texOffs(128, 200).addBox(-2.0f, -24.0f, 0.0f, 4.0f, 24.0f, 24.0f), PartPose.offset((float)-16.0f, (float)-16.0f, (float)-16.0f));
        neck1b.addOrReplaceChild("neck_1c", CubeListBuilder.create().texOffs(128, 136).addBox(-16.0f, -16.0f, -16.0f, 32.0f, 32.0f, 32.0f).texOffs(128, 200).addBox(-2.0f, -24.0f, 0.0f, 4.0f, 24.0f, 24.0f), PartPose.offset((float)-16.0f, (float)-16.0f, (float)-16.0f));
        PartDefinition head2 = partdefinition.addOrReplaceChild("head_2", CubeListBuilder.create().texOffs(272, 0).addBox(-16.0f, -14.0f, -32.0f, 32.0f, 24.0f, 32.0f).texOffs(272, 56).addBox(-15.0f, -2.0f, -56.0f, 30.0f, 12.0f, 24.0f).texOffs(128, 200).addBox(-2.0f, -30.0f, -12.0f, 4.0f, 24.0f, 24.0f), PartPose.offset((float)0.0f, (float)-116.0f, (float)-32.0f));
        head2.addOrReplaceChild("jaw_2", CubeListBuilder.create().texOffs(272, 92).addBox(-15.0f, 0.0f, -48.0f, 30.0f, 8.0f, 48.0f), PartPose.offset((float)0.0f, (float)10.0f, (float)-4.0f));
        head2.addOrReplaceChild("frill_2", CubeListBuilder.create().texOffs(272, 200).addBox(-24.0f, -40.0f, 0.0f, 48.0f, 48.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-10.0f, (float)-0.5235988f, (float)0.0f, (float)0.0f));
        PartDefinition neck2a = partdefinition.addOrReplaceChild("neck_2a", CubeListBuilder.create().texOffs(128, 136).addBox(-16.0f, -16.0f, -16.0f, 32.0f, 32.0f, 32.0f).texOffs(128, 200).addBox(-2.0f, -24.0f, 0.0f, 4.0f, 24.0f, 24.0f), PartPose.offset((float)0.0f, (float)-48.0f, (float)0.0f));
        PartDefinition neck2b = neck2a.addOrReplaceChild("neck_2b", CubeListBuilder.create().texOffs(128, 136).addBox(-16.0f, -16.0f, -16.0f, 32.0f, 32.0f, 32.0f).texOffs(128, 200).addBox(-2.0f, -24.0f, 0.0f, 4.0f, 24.0f, 24.0f), PartPose.offset((float)-0.0f, (float)-24.0f, (float)-16.0f));
        neck2b.addOrReplaceChild("neck_2c", CubeListBuilder.create().texOffs(128, 136).addBox(-16.0f, -16.0f, -16.0f, 32.0f, 32.0f, 32.0f).texOffs(128, 200).addBox(-2.0f, -24.0f, 0.0f, 4.0f, 24.0f, 24.0f), PartPose.offset((float)0.0f, (float)-24.0f, (float)-16.0f));
        PartDefinition head3 = partdefinition.addOrReplaceChild("head_3", CubeListBuilder.create().texOffs(272, 0).addBox(-16.0f, -14.0f, -32.0f, 32.0f, 24.0f, 32.0f).texOffs(272, 56).addBox(-15.0f, -2.0f, -56.0f, 30.0f, 12.0f, 24.0f).texOffs(128, 200).addBox(-2.0f, -30.0f, -12.0f, 4.0f, 24.0f, 24.0f), PartPose.offset((float)74.0f, (float)-100.0f, (float)-32.0f));
        head3.addOrReplaceChild("jaw_3", CubeListBuilder.create().texOffs(272, 92).addBox(-15.0f, 0.0f, -48.0f, 30.0f, 8.0f, 48.0f), PartPose.offset((float)0.0f, (float)10.0f, (float)-4.0f));
        head3.addOrReplaceChild("frill_3", CubeListBuilder.create().texOffs(272, 200).addBox(-24.0f, -40.0f, 0.0f, 48.0f, 48.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-10.0f, (float)-0.5235988f, (float)0.0f, (float)0.0f));
        PartDefinition neck3a = partdefinition.addOrReplaceChild("neck_3a", CubeListBuilder.create().texOffs(128, 136).addBox(-16.0f, -16.0f, -16.0f, 32.0f, 32.0f, 32.0f).texOffs(128, 200).addBox(-2.0f, -24.0f, 0.0f, 4.0f, 24.0f, 24.0f), PartPose.offset((float)42.0f, (float)-48.0f, (float)0.0f));
        PartDefinition neck3b = neck3a.addOrReplaceChild("neck_3b", CubeListBuilder.create().texOffs(128, 136).addBox(-16.0f, -16.0f, -16.0f, 32.0f, 32.0f, 32.0f).texOffs(128, 200).addBox(-2.0f, -24.0f, 0.0f, 4.0f, 24.0f, 24.0f), PartPose.offset((float)16.0f, (float)-16.0f, (float)-16.0f));
        neck3b.addOrReplaceChild("neck_3c", CubeListBuilder.create().texOffs(128, 136).addBox(-16.0f, -16.0f, -16.0f, 32.0f, 32.0f, 32.0f).texOffs(128, 200).addBox(-2.0f, -24.0f, 0.0f, 4.0f, 24.0f, 24.0f), PartPose.offset((float)16.0f, (float)-16.0f, (float)-16.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)512, (int)256);
    }

    private static LayerDefinition createJappaModel() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head1 = partdefinition.addOrReplaceChild("head_1", CubeListBuilder.create().texOffs(260, 64).addBox(-16.0f, -16.0f, -16.0f, 32.0f, 32.0f, 32.0f).texOffs(236, 128).addBox(-16.0f, -2.0f, -40.0f, 32.0f, 10.0f, 24.0f).texOffs(356, 70).addBox(-12.0f, 8.0f, -36.0f, 24.0f, 6.0f, 20.0f), PartPose.offset((float)-74.0f, (float)-100.0f, (float)-56.0f));
        PartDefinition head2 = partdefinition.addOrReplaceChild("head_2", CubeListBuilder.create().texOffs(260, 64).addBox(-16.0f, -16.0f, -16.0f, 32.0f, 32.0f, 32.0f).texOffs(236, 128).addBox(-16.0f, -2.0f, -40.0f, 32.0f, 10.0f, 24.0f).texOffs(356, 70).addBox(-12.0f, 8.0f, -36.0f, 24.0f, 6.0f, 20.0f), PartPose.offset((float)0.0f, (float)-116.0f, (float)-56.0f));
        PartDefinition head3 = partdefinition.addOrReplaceChild("head_3", CubeListBuilder.create().texOffs(260, 64).addBox(-16.0f, -16.0f, -16.0f, 32.0f, 32.0f, 32.0f).texOffs(236, 128).addBox(-16.0f, -2.0f, -40.0f, 32.0f, 10.0f, 24.0f).texOffs(356, 70).addBox(-12.0f, 8.0f, -36.0f, 24.0f, 6.0f, 20.0f), PartPose.offset((float)74.0f, (float)-100.0f, (float)-56.0f));
        head1.addOrReplaceChild("mouth_1", CubeListBuilder.create().texOffs(240, 162).addBox(-15.0f, 0.0f, -24.0f, 30.0f, 8.0f, 24.0f), PartPose.offset((float)0.0f, (float)8.0f, (float)-16.0f));
        head2.addOrReplaceChild("mouth_2", CubeListBuilder.create().texOffs(240, 162).addBox(-15.0f, 0.0f, -24.0f, 30.0f, 8.0f, 24.0f), PartPose.offset((float)0.0f, (float)8.0f, (float)-16.0f));
        head3.addOrReplaceChild("mouth_3", CubeListBuilder.create().texOffs(240, 162).addBox(-15.0f, 0.0f, -24.0f, 30.0f, 8.0f, 24.0f), PartPose.offset((float)0.0f, (float)8.0f, (float)-16.0f));
        head1.addOrReplaceChild("plate_1", CubeListBuilder.create().texOffs(388, 0).addBox(-24.0f, -48.0f, 0.0f, 48.0f, 48.0f, 6.0f).texOffs(220, 0).addBox(-4.0f, -32.0f, -8.0f, 8.0f, 32.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-1.0f, (float)-0.7853982f, (float)0.0f, (float)0.0f));
        head2.addOrReplaceChild("plate_2", CubeListBuilder.create().texOffs(388, 0).addBox(-24.0f, -48.0f, 0.0f, 48.0f, 48.0f, 6.0f).texOffs(220, 0).addBox(-4.0f, -32.0f, -8.0f, 8.0f, 32.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-1.0f, (float)-0.7853982f, (float)0.0f, (float)0.0f));
        head3.addOrReplaceChild("plate_3", CubeListBuilder.create().texOffs(388, 0).addBox(-24.0f, -48.0f, 0.0f, 48.0f, 48.0f, 6.0f).texOffs(220, 0).addBox(-4.0f, -32.0f, -8.0f, 8.0f, 32.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-1.0f, (float)-0.7853982f, (float)0.0f, (float)0.0f));
        PartDefinition neck1 = partdefinition.addOrReplaceChild("neck_1", CubeListBuilder.create().texOffs(260, 0).addBox(-16.0f, -16.0f, -16.0f, 32.0f, 32.0f, 32.0f).texOffs(0, 0).addBox(-2.0f, -24.0f, 0.0f, 4.0f, 8.0f, 16.0f), PartPose.offset((float)-42.0f, (float)-48.0f, (float)0.0f));
        PartDefinition neck2 = partdefinition.addOrReplaceChild("neck_2", CubeListBuilder.create().texOffs(260, 0).addBox(-16.0f, -16.0f, -16.0f, 32.0f, 32.0f, 32.0f).texOffs(0, 0).addBox(-2.0f, -24.0f, 0.0f, 4.0f, 8.0f, 16.0f), PartPose.offset((float)0.0f, (float)-48.0f, (float)0.0f));
        PartDefinition neck3 = partdefinition.addOrReplaceChild("neck_3", CubeListBuilder.create().texOffs(260, 0).addBox(-16.0f, -16.0f, -16.0f, 32.0f, 32.0f, 32.0f).texOffs(0, 0).addBox(-2.0f, -24.0f, 0.0f, 4.0f, 8.0f, 16.0f), PartPose.offset((float)42.0f, (float)-48.0f, (float)0.0f));
        PartDefinition neck4 = neck1.addOrReplaceChild("neck_4", CubeListBuilder.create().texOffs(260, 0).addBox(-16.0f, -16.0f, -16.0f, 32.0f, 32.0f, 32.0f).texOffs(0, 0).addBox(-2.0f, -24.0f, 0.0f, 4.0f, 8.0f, 16.0f), PartPose.offset((float)-16.0f, (float)-16.0f, (float)-16.0f));
        PartDefinition neck5 = neck2.addOrReplaceChild("neck_5", CubeListBuilder.create().texOffs(260, 0).addBox(-16.0f, -16.0f, -16.0f, 32.0f, 32.0f, 32.0f).texOffs(0, 0).addBox(-2.0f, -24.0f, 0.0f, 4.0f, 8.0f, 16.0f), PartPose.offset((float)0.0f, (float)-24.0f, (float)-16.0f));
        PartDefinition neck6 = neck3.addOrReplaceChild("neck_6", CubeListBuilder.create().texOffs(260, 0).addBox(-16.0f, -16.0f, -16.0f, 32.0f, 32.0f, 32.0f).texOffs(0, 0).addBox(-2.0f, -24.0f, 0.0f, 4.0f, 8.0f, 16.0f), PartPose.offset((float)16.0f, (float)-16.0f, (float)-16.0f));
        neck4.addOrReplaceChild("neck_7", CubeListBuilder.create().texOffs(260, 0).addBox(-16.0f, -16.0f, -16.0f, 32.0f, 32.0f, 32.0f).texOffs(0, 0).addBox(-2.0f, -24.0f, 0.0f, 4.0f, 8.0f, 16.0f), PartPose.offset((float)-16.0f, (float)-16.0f, (float)-16.0f));
        neck5.addOrReplaceChild("neck_8", CubeListBuilder.create().texOffs(260, 0).addBox(-16.0f, -16.0f, -16.0f, 32.0f, 32.0f, 32.0f).texOffs(0, 0).addBox(-2.0f, -24.0f, 0.0f, 4.0f, 8.0f, 16.0f), PartPose.offset((float)0.0f, (float)-24.0f, (float)-16.0f));
        neck6.addOrReplaceChild("neck_9", CubeListBuilder.create().texOffs(260, 0).addBox(-16.0f, -16.0f, -16.0f, 32.0f, 32.0f, 32.0f).texOffs(0, 0).addBox(-2.0f, -24.0f, 0.0f, 4.0f, 8.0f, 16.0f), PartPose.offset((float)16.0f, (float)-16.0f, (float)-16.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-45.0f, -12.0f, -20.0f, 90.0f, 96.0f, 40.0f).texOffs(88, 136).addBox(-2.0f, 20.0f, 20.0f, 4.0f, 16.0f, 12.0f).texOffs(120, 136).addBox(-2.0f, 48.0f, 20.0f, 4.0f, 16.0f, 12.0f), PartPose.offsetAndRotation((float)0.0f, (float)-32.0f, (float)0.0f, (float)1.1170107f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 136).addBox(-14.0f, -8.0f, -16.0f, 28.0f, 52.0f, 32.0f).texOffs(0, 220).addBox(-14.0f, 36.0f, -22.0f, 28.0f, 8.0f, 6.0f), PartPose.offset((float)-40.0f, (float)-20.0f, (float)-12.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(120, 136).addBox(-14.0f, -8.0f, -16.0f, 28.0f, 52.0f, 32.0f).texOffs(68, 220).addBox(-14.0f, 36.0f, -22.0f, 28.0f, 8.0f, 6.0f), PartPose.offset((float)40.0f, (float)-20.0f, (float)-12.0f));
        PartDefinition tail1 = partdefinition.addOrReplaceChild("tail_1", CubeListBuilder.create().texOffs(260, 0).addBox(-16.0f, -16.0f, -16.0f, 32.0f, 32.0f, 32.0f).texOffs(0, 0).addBox(-2.0f, -24.0f, 0.0f, 4.0f, 8.0f, 16.0f), PartPose.offset((float)0.0f, (float)8.0f, (float)80.0f));
        PartDefinition tail2 = tail1.addOrReplaceChild("tail_2", CubeListBuilder.create().texOffs(260, 0).addBox(-16.0f, -16.0f, -16.0f, 32.0f, 32.0f, 32.0f).texOffs(0, 0).addBox(-2.0f, -24.0f, 0.0f, 4.0f, 8.0f, 16.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)32.0f));
        PartDefinition tail3 = tail2.addOrReplaceChild("tail_3", CubeListBuilder.create().texOffs(260, 0).addBox(-16.0f, -16.0f, -16.0f, 32.0f, 32.0f, 32.0f).texOffs(0, 0).addBox(-2.0f, -24.0f, 0.0f, 4.0f, 8.0f, 16.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)32.0f));
        tail3.addOrReplaceChild("tail_4", CubeListBuilder.create().texOffs(260, 0).addBox(-16.0f, -16.0f, -16.0f, 32.0f, 32.0f, 32.0f).texOffs(0, 0).addBox(-2.0f, -24.0f, 0.0f, 4.0f, 8.0f, 16.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)32.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)512, (int)256);
    }

    public ModelPart root() {
        return this.root;
    }

    public void renderToBuffer(PoseStack stack, VertexConsumer consumer, int light, int overlay, int color) {
        if (this.hydra != null && this.hydra.renderFakeHeads) {
            super.renderToBuffer(stack, consumer, light, overlay, color);
        } else {
            this.rightLeg.render(stack, consumer, light, overlay, color);
            this.leftLeg.render(stack, consumer, light, overlay, color);
            this.body.render(stack, consumer, light, overlay, color);
            this.tail.render(stack, consumer, light, overlay, color);
        }
        this.hydra = null;
    }

    public void setupAnim(Hydra entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.hydra = entity;
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
    }
}

