/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import twilightforest.client.JappaPackReloadListener;
import twilightforest.client.model.entity.TrophyBlockModel;
import twilightforest.client.renderer.entity.HydraRenderer;
import twilightforest.entity.boss.HydraHead;
import twilightforest.entity.boss.HydraPart;

public class HydraHeadModel<T extends HydraHead>
extends ListModel<T>
implements TrophyBlockModel {
    private final ModelPart head;
    private final ModelPart jaw;

    public HydraHeadModel(ModelPart root) {
        this.head = root.getChild("head");
        this.jaw = this.head.getChild("jaw");
    }

    public static LayerDefinition checkForPack() {
        return JappaPackReloadListener.INSTANCE.isJappaPackLoaded() ? HydraHeadModel.createJappaModel() : HydraHeadModel.create();
    }

    private static LayerDefinition create() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(272, 0).addBox(-16.0f, -14.0f, -16.0f, 32.0f, 24.0f, 32.0f, new CubeDeformation(0.01f)).texOffs(272, 56).addBox(-15.0f, -2.0f, -40.0f, 30.0f, 12.0f, 24.0f).texOffs(272, 132).addBox(-15.0f, 9.0f, -4.0f, 30.0f, 8.0f, 16.0f).texOffs(128, 200).addBox(-2.0f, -30.0f, 4.0f, 4.0f, 24.0f, 24.0f).texOffs(272, 156).addBox(-12.0f, 9.0f, -33.0f, 2.0f, 5.0f, 2.0f).texOffs(272, 156).addBox(10.0f, 9.0f, -33.0f, 2.0f, 5.0f, 2.0f).texOffs(280, 156).addBox(-8.0f, 8.0f, -33.0f, 16.0f, 2.0f, 2.0f).texOffs(280, 160).addBox(-10.0f, 8.0f, -29.0f, 2.0f, 2.0f, 16.0f).texOffs(280, 160).addBox(8.0f, 8.0f, -29.0f, 2.0f, 2.0f, 16.0f), PartPose.ZERO);
        head.addOrReplaceChild("jaw", CubeListBuilder.create().texOffs(272, 92).addBox(-15.0f, 0.0f, -26.0f, 30.0f, 8.0f, 32.0f).texOffs(272, 156).addBox(-10.0f, -5.0f, -23.0f, 2.0f, 5.0f, 2.0f).texOffs(272, 156).addBox(8.0f, -5.0f, -23.0f, 2.0f, 5.0f, 2.0f).texOffs(280, 156).addBox(-8.0f, -1.0f, -23.0f, 16.0f, 2.0f, 2.0f).texOffs(280, 160).addBox(-10.0f, -1.0f, -19.0f, 2.0f, 2.0f, 16.0f).texOffs(280, 160).addBox(8.0f, -1.0f, -19.0f, 2.0f, 2.0f, 16.0f), PartPose.offset((float)0.0f, (float)10.0f, (float)-10.0f));
        head.addOrReplaceChild("frill", CubeListBuilder.create().texOffs(272, 200).addBox(-24.0f, -50.0f, 16.0f, 48.0f, 48.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-14.0f, (float)-0.5235988f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)512, (int)256);
    }

    private static LayerDefinition createJappaModel() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(260, 64).addBox(-16.0f, -16.0f, -16.0f, 32.0f, 32.0f, 32.0f).texOffs(236, 128).addBox(-16.0f, -2.0f, -40.0f, 32.0f, 10.0f, 24.0f).texOffs(356, 70).addBox(-12.0f, 8.0f, -36.0f, 24.0f, 6.0f, 20.0f), PartPose.ZERO);
        head.addOrReplaceChild("jaw", CubeListBuilder.create().texOffs(240, 162).addBox(-15.0f, 0.0f, -24.0f, 30.0f, 8.0f, 24.0f), PartPose.offset((float)0.0f, (float)10.0f, (float)-14.0f));
        head.addOrReplaceChild("plate", CubeListBuilder.create().texOffs(388, 0).addBox(-24.0f, -48.0f, 0.0f, 48.0f, 48.0f, 6.0f).texOffs(220, 0).addBox(-4.0f, -32.0f, -8.0f, 8.0f, 32.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7853982f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)512, (int)256);
    }

    public Iterable<ModelPart> parts() {
        return ImmutableList.of((Object)this.head);
    }

    public void setupAnim(HydraHead entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        this.head.yRot = this.getRotationY((HydraPart)((Object)entity), partialTicks);
        this.head.xRot = this.getRotationX((HydraPart)((Object)entity), partialTicks);
        float mouthOpenLast = ((HydraHead)((Object)entity)).getMouthOpenLast();
        float mouthOpenReal = ((HydraHead)((Object)entity)).getMouthOpen();
        float mouthOpen = Mth.lerp((float)partialTicks, (float)mouthOpenLast, (float)mouthOpenReal);
        this.head.xRot -= mouthOpen * 0.2617994f;
        this.jaw.xRot = mouthOpen * 1.0471976f;
    }

    public float getRotationY(HydraPart whichHead, float time) {
        float yaw = whichHead.yRotO + (whichHead.getYRot() - whichHead.yRotO) * time;
        return yaw * ((float)Math.PI / 180);
    }

    public float getRotationX(HydraPart whichHead, float time) {
        return (whichHead.xRotO + (whichHead.getXRot() - whichHead.xRotO) * time) * ((float)Math.PI / 180);
    }

    @Override
    public void setupRotationsForTrophy(float x, float y, float z, float mouthAngle) {
        this.head.yRot = y * ((float)Math.PI / 180);
        this.head.xRot = z * ((float)Math.PI / 180);
        this.jaw.xRot = mouthAngle * 1.0471976f;
    }

    @Override
    public void renderTrophy(PoseStack stack, MultiBufferSource buffer, int light, int overlay, int color, ItemDisplayContext context) {
        boolean itemForm = context != ItemDisplayContext.NONE;
        stack.scale(0.25f, 0.25f, 0.25f);
        if (itemForm) {
            stack.scale(0.9f, 0.9f, 0.9f);
        }
        if (context == ItemDisplayContext.GUI) {
            stack.translate(0.0f, 0.0f, 0.75f);
        }
        stack.translate(0.0f, -1.0f, itemForm && !JappaPackReloadListener.INSTANCE.isJappaPackLoaded() ? -1.0f : 0.0f);
        VertexConsumer consumer = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)HydraRenderer.TEXTURE));
        this.head.render(stack, consumer, light, overlay, color);
    }
}

