/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.block.connected;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import twilightforest.client.model.block.connected.UnbakedConnectedTextureModel;

public class ConnectedTextureModelLoader
implements IGeometryLoader<UnbakedConnectedTextureModel> {
    public static final ConnectedTextureModelLoader INSTANCE = new ConnectedTextureModelLoader();

    public UnbakedConnectedTextureModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) throws JsonParseException {
        JsonObject baseTextureInfo = GsonHelper.getAsJsonObject((JsonObject)jsonObject, (String)"base", (JsonObject)new JsonObject());
        int baseTintIndex = GsonHelper.getAsInt((JsonObject)baseTextureInfo, (String)"tint_index", (int)-1);
        int baseEmissivity = GsonHelper.getAsInt((JsonObject)baseTextureInfo, (String)"emissivity", (int)0);
        JsonObject overlayInfo = GsonHelper.getAsJsonObject((JsonObject)jsonObject, (String)"connected_texture", (JsonObject)new JsonObject());
        int tintIndex = GsonHelper.getAsInt((JsonObject)overlayInfo, (String)"tint_index", (int)-1);
        int emissivity = GsonHelper.getAsInt((JsonObject)overlayInfo, (String)"emissivity", (int)0);
        boolean renderDisabled = GsonHelper.getAsBoolean((JsonObject)overlayInfo, (String)"render_disabled_faces", (boolean)true);
        EnumSet<Direction> faces = this.parseEnabledFaces(overlayInfo);
        List<Block> connectables = this.parseConnnectableBlocks(jsonObject);
        return new UnbakedConnectedTextureModel(faces, renderDisabled, connectables, baseTintIndex, baseEmissivity, tintIndex, emissivity);
    }

    private EnumSet<Direction> parseEnabledFaces(JsonObject object) {
        if (!object.has("faces")) {
            return EnumSet.allOf(Direction.class);
        }
        EnumSet<Direction> faces = EnumSet.noneOf(Direction.class);
        for (JsonElement element : object.getAsJsonArray("faces")) {
            Direction face = Direction.byName((String)element.getAsString());
            if (face == null) {
                throw new JsonParseException("Invalid face: " + element.getAsString());
            }
            faces.add(face);
        }
        return faces;
    }

    private List<Block> parseConnnectableBlocks(JsonObject object) {
        if (!object.has("connectable_blocks")) {
            return List.of();
        }
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (JsonElement element : object.getAsJsonArray("connectable_blocks")) {
            if (element.getAsString().startsWith("#")) {
                ResourceLocation tag = ResourceLocation.tryParse((String)element.getAsString().substring(1));
                if (tag != null) {
                    BuiltInRegistries.BLOCK.getTagOrEmpty(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)tag)).forEach(blockHolder -> blocks.add((Block)blockHolder.value()));
                    continue;
                }
                throw new JsonParseException("Invalid block tag: " + element.getAsString());
            }
            Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.tryParse((String)element.getAsString()));
            if (block == Blocks.AIR) {
                throw new JsonParseException("Invalid block: " + element.getAsString());
            }
            blocks.add(block);
        }
        return blocks;
    }
}

