/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.event;

import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import twilightforest.client.LockedBiomeToast;
import twilightforest.config.TFConfig;
import twilightforest.util.Restriction;
import twilightforest.util.landmarks.LandmarkUtil;

public class LockedBiomeToastHandler {
    private static boolean shownToast = false;
    private static int timeUntilToast = 60;

    protected static void tickLockedToastLogic(ClientTickEvent.Post event) {
        Level level;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || !((level = player.level()) instanceof ClientLevel)) {
            return;
        }
        ClientLevel level2 = (ClientLevel)level;
        if (level2.isClientSide() && player.tickCount % 5 == 0 && LandmarkUtil.isProgressionEnforced((Level)level2) && !player.isCreative() && !player.isSpectator() && !TFConfig.disableLockedBiomeToasts) {
            Optional<Restriction> restriction = Restriction.getRestrictionForBiome((Biome)level2.getBiome(player.blockPosition()).value(), (Entity)player);
            if (restriction.isPresent() && restriction.get().lockedBiomeToast() != null) {
                if (!shownToast && --timeUntilToast <= 0) {
                    Minecraft.getInstance().getToasts().addToast((Toast)new LockedBiomeToast(restriction.get().lockedBiomeToast()));
                    shownToast = true;
                }
            } else if (shownToast) {
                timeUntilToast = 60;
                shownToast = false;
            }
        }
    }
}

