/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.event;

import com.ibm.icu.text.RuleBasedNumberFormat;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.time.LocalDate;
import java.time.Month;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.client.gui.components.SplashRenderer;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.ComputeFovModifierEvent;
import net.neoforged.neoforge.client.event.CustomizeGuiOverlayEvent;
import net.neoforged.neoforge.client.event.RenderFrameEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.event.SelectMusicEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import twilightforest.TwilightForestMod;
import twilightforest.beanification.Autowired;
import twilightforest.beanification.Component;
import twilightforest.beanification.PostConstruct;
import twilightforest.block.GiantBlock;
import twilightforest.block.MiniatureStructureBlock;
import twilightforest.block.entity.GrowingBeanstalkBlockEntity;
import twilightforest.client.BugModelAnimationHelper;
import twilightforest.client.ISTER;
import twilightforest.client.OptifineWarningScreen;
import twilightforest.client.TFShaders;
import twilightforest.client.event.ClientRegistrationEvents;
import twilightforest.client.event.CloudEvents;
import twilightforest.client.event.FogHandler;
import twilightforest.client.event.LockedBiomeToastHandler;
import twilightforest.client.renderer.entity.MagicPaintingRenderer;
import twilightforest.compat.curios.CuriosCompat;
import twilightforest.config.TFConfig;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.entity.boss.bar.ClientTFBossBar;
import twilightforest.events.HostileMountEvents;
import twilightforest.init.TFDataComponents;
import twilightforest.init.TFDimension;
import twilightforest.item.EnderBowItem;
import twilightforest.item.GiantPickItem;
import twilightforest.item.IceBowItem;
import twilightforest.item.SeekerBowItem;
import twilightforest.item.TripleBowItem;
import twilightforest.item.TrophyItem;
import twilightforest.util.HolderMatcher;
import twilightforest.util.entities.EntityRenderingUtil;

@Component(dist={Dist.CLIENT})
public class ClientGameEvents {
    private final VoxelShape GIANT_BLOCK = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)4.0, (double)4.0);
    private final MutableComponent WIP_TEXT = net.minecraft.network.chat.Component.translatable((String)"misc.twilightforest.wip").withStyle(ChatFormatting.RED);
    private final MutableComponent EMPERORS_CLOTH_TOOLTIP = net.minecraft.network.chat.Component.translatable((String)"item.twilightforest.emperors_cloth.desc").withStyle(ChatFormatting.GRAY);
    private boolean firstTitleScreenShown = false;
    public static int time = 0;
    private float shakeIntensity = 0.0f;
    private int aurora = 0;
    private int lastAurora = 0;
    @Autowired(dist={Dist.CLIENT})
    private HolderMatcher holderMatcher;

    @PostConstruct
    private void setup() {
        NeoForge.EVENT_BUS.addListener(this::addCustomTooltips);
        NeoForge.EVENT_BUS.addListener(this::clientTick);
        NeoForge.EVENT_BUS.addListener(this::customizeSplashes);
        NeoForge.EVENT_BUS.addListener(this::clearEntityRenderUtilMap);
        NeoForge.EVENT_BUS.addListener(this::handleGameBootup);
        NeoForge.EVENT_BUS.addListener(this::killVignette);
        NeoForge.EVENT_BUS.addListener(this::removeHostileMountHealth);
        NeoForge.EVENT_BUS.addListener(this::renderAurora);
        NeoForge.EVENT_BUS.addListener(this::renderCustomBossbars);
        NeoForge.EVENT_BUS.addListener(this::renderGiantBlockOutlines);
        NeoForge.EVENT_BUS.addListener(this::setMusicInDimension);
        NeoForge.EVENT_BUS.addListener(this::shakeCamera);
        NeoForge.EVENT_BUS.addListener(this::translateBookAuthor);
        NeoForge.EVENT_BUS.addListener(this::unrenderHeadWithTrophies);
        NeoForge.EVENT_BUS.addListener(this::updateBowFOV);
        NeoForge.EVENT_BUS.addListener(CloudEvents::renderPrecipitation);
        NeoForge.EVENT_BUS.addListener(CloudEvents::tickWeatherEffects);
        NeoForge.EVENT_BUS.addListener(FogHandler::renderFog);
        NeoForge.EVENT_BUS.addListener(FogHandler::unloadFog);
        NeoForge.EVENT_BUS.addListener(LockedBiomeToastHandler::tickLockedToastLogic);
    }

    private void handleGameBootup(ScreenEvent.Init.Post event) {
        if (this.firstTitleScreenShown || !(event.getScreen() instanceof TitleScreen)) {
            return;
        }
        ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
        if (resourceManager instanceof ReloadableResourceManager) {
            ReloadableResourceManager resourceManager2 = (ReloadableResourceManager)resourceManager;
            resourceManager2.registerReloadListener((PreparableReloadListener)ISTER.INSTANCE.get());
            TwilightForestMod.LOGGER.debug("Registered ISTER listener");
        }
        if (ClientRegistrationEvents.isOptifinePresent() && !TFConfig.disableOptifineNagScreen) {
            Minecraft.getInstance().setScreen((Screen)new OptifineWarningScreen(event.getScreen()));
        }
        this.firstTitleScreenShown = true;
    }

    private void customizeSplashes(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof TitleScreen) {
            LocalDate date;
            TitleScreen title = (TitleScreen)screen;
            SplashRenderer renderer = title.splash;
            if (renderer != null && (date = LocalDate.now()).getMonth() == Month.AUGUST && date.getDayOfMonth() == 19) {
                RuleBasedNumberFormat formatter = new RuleBasedNumberFormat(Locale.US, 2);
                renderer.splash = String.format("Happy %s birthday to the Twilight Forest!", formatter.format((long)(date.getYear() - 2011)));
            }
        }
    }

    private void clearEntityRenderUtilMap(ScreenEvent.Closing event) {
        if (!EntityRenderingUtil.ENTITY_MAP.isEmpty()) {
            EntityRenderingUtil.ENTITY_MAP.clear();
        }
    }

    private void setMusicInDimension(SelectMusicEvent event) {
        Music music = event.getOriginalMusic();
        if (Minecraft.getInstance().level != null && Minecraft.getInstance().player != null && (music == Musics.CREATIVE || music == Musics.UNDER_WATER) && TFDimension.isTwilightWorldOnClient((Level)Minecraft.getInstance().level)) {
            event.setMusic(((Biome)Minecraft.getInstance().level.getBiomeManager().getNoiseBiomeAtPosition(Minecraft.getInstance().player.blockPosition()).value()).getBackgroundMusic().orElse(Musics.GAME));
        }
    }

    private void removeHostileMountHealth(RenderGuiLayerEvent.Pre event) {
        if (VanillaGuiLayers.VEHICLE_HEALTH == event.getName() && HostileMountEvents.isRidingUnfriendly((LivingEntity)Minecraft.getInstance().player)) {
            event.setCanceled(true);
        }
    }

    private void renderAurora(RenderLevelStageEvent event) {
        if (Minecraft.getInstance().level == null) {
            return;
        }
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_WEATHER && (this.aurora > 0 || this.lastAurora > 0) && TFShaders.AURORA != null) {
            Tesselator tesselator = Tesselator.getInstance();
            BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            float scale = 2048.0f * (Minecraft.getInstance().gameRenderer.getRenderDistance() / 32.0f);
            Vec3 pos = event.getCamera().getPosition();
            float y = (float)(256.0 - pos.y());
            buffer.addVertex(-scale, y, scale).setColor(1.0f, 1.0f, 1.0f, 1.0f);
            buffer.addVertex(-scale, y, -scale).setColor(1.0f, 1.0f, 1.0f, 1.0f);
            buffer.addVertex(scale, y, -scale).setColor(1.0f, 1.0f, 1.0f, 1.0f);
            buffer.addVertex(scale, y, scale).setColor(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(Mth.lerp((float)event.getPartialTick().getGameTimeDeltaTicks(), (float)this.lastAurora, (float)this.aurora) / 60.0f * 0.5f));
            TFShaders.AURORA.invokeThenEndTesselator(Minecraft.getInstance().level == null ? 0 : Mth.abs((int)((int)Minecraft.getInstance().level.getBiomeManager().biomeZoomSeed)), (float)pos.x(), (float)pos.y(), (float)pos.z(), buffer);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableDepthTest();
            RenderSystem.disableBlend();
        }
    }

    private void killVignette(RenderFrameEvent.Pre event) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.level != null && TFDimension.DIMENSION_KEY.equals((Object)minecraft.level.dimension())) {
            minecraft.gui.vignetteBrightness = 0.0f;
        }
        if (minecraft.player != null && HostileMountEvents.isRidingUnfriendly((LivingEntity)minecraft.player)) {
            minecraft.gui.setOverlayMessage((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.empty(), false);
        }
    }

    private void clientTick(ClientTickEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        if (!mc.isPaused()) {
            ++time;
            this.lastAurora = this.aurora++;
            if (mc.level != null && mc.cameraEntity != null && !TFConfig.getValidAuroraBiomes(mc.level.registryAccess()).isEmpty()) {
                RegistryAccess access = mc.level.registryAccess();
                Holder biome = mc.level.getBiome(mc.cameraEntity.blockPosition());
                if (!TFConfig.getValidAuroraBiomes(access).stream().anyMatch(c -> this.holderMatcher.match(c, biome))) {
                    --this.aurora;
                }
                this.aurora = Mth.clamp((int)this.aurora, (int)0, (int)60);
            } else {
                this.aurora = 0;
            }
            BugModelAnimationHelper.animate();
            if (mc.level != null) {
                if (mc.level.getSkyFlashTime() > 0) {
                    MagicPaintingRenderer.lastLightning = mc.level.getGameTime();
                }
                if (TFConfig.firstPersonEffects && mc.player != null) {
                    HashSet<ChunkPos> chunksInRange = new HashSet<ChunkPos>();
                    for (int x = -16; x <= 16; x += 16) {
                        for (int z = -16; z <= 16; z += 16) {
                            chunksInRange.add(new ChunkPos((int)(mc.player.getX() + (double)x) >> 4, (int)(mc.player.getZ() + (double)z) >> 4));
                        }
                    }
                    for (ChunkPos pos : chunksInRange) {
                        List<BlockEntity> beanstalksInChunk;
                        if (mc.level.getChunk(pos.x, pos.z, ChunkStatus.FULL, false) == null || (beanstalksInChunk = mc.level.getChunk(pos.x, pos.z).getBlockEntities().values().stream().filter(blockEntity -> {
                            GrowingBeanstalkBlockEntity beanstalkBlock;
                            return blockEntity instanceof GrowingBeanstalkBlockEntity && (beanstalkBlock = (GrowingBeanstalkBlockEntity)((Object)blockEntity)).isBeanstalkRumbling();
                        }).toList()).isEmpty()) continue;
                        BlockEntity beanstalk = beanstalksInChunk.getFirst();
                        LocalPlayer player = mc.player;
                        this.shakeIntensity = (float)(1.0 - mc.player.distanceToSqr(Vec3.atCenterOf((Vec3i)beanstalk.getBlockPos())) / Math.pow(16.0, 2.0));
                        if (!(this.shakeIntensity > 0.0f)) continue;
                        player.moveTo(player.getX(), player.getY(), player.getZ(), player.getYRot() + (player.getRandom().nextFloat() - 0.5f) * this.shakeIntensity, player.getXRot() + (player.getRandom().nextFloat() * 2.5f - 1.25f) * this.shakeIntensity);
                        this.shakeIntensity = 0.0f;
                        break;
                    }
                }
            }
        }
    }

    private void shakeCamera(ViewportEvent.ComputeCameraAngles event) {
        if (TFConfig.firstPersonEffects && !Minecraft.getInstance().isPaused() && this.shakeIntensity > 0.0f && Minecraft.getInstance().player != null) {
            event.setYaw((float)Mth.lerp((double)event.getPartialTick(), (double)event.getYaw(), (double)(event.getYaw() + (Minecraft.getInstance().player.getRandom().nextFloat() * 2.0f - 1.0f) * this.shakeIntensity)));
            event.setPitch((float)Mth.lerp((double)event.getPartialTick(), (double)event.getPitch(), (double)(event.getPitch() + (Minecraft.getInstance().player.getRandom().nextFloat() * 2.0f - 1.0f) * this.shakeIntensity)));
            event.setRoll((float)Mth.lerp((double)event.getPartialTick(), (double)event.getRoll(), (double)(event.getRoll() + (Minecraft.getInstance().player.getRandom().nextFloat() * 2.0f - 1.0f) * this.shakeIntensity)));
            this.shakeIntensity = 0.0f;
        }
    }

    private void addCustomTooltips(ItemTooltipEvent event) {
        ItemStack item = event.getItemStack();
        if (item.has(TFDataComponents.EMPERORS_CLOTH)) {
            event.getToolTip().add(1, this.EMPERORS_CLOTH_TOOLTIP);
        }
        if (item.is(ItemTagGenerator.WIP)) {
            event.getToolTip().add(this.WIP_TEXT);
        }
    }

    private void updateBowFOV(ComputeFovModifierEvent event) {
        Item useItem;
        Player player = event.getPlayer();
        if (player.isUsingItem() && ((useItem = player.getUseItem().getItem()) instanceof TripleBowItem || useItem instanceof EnderBowItem || useItem instanceof IceBowItem || useItem instanceof SeekerBowItem)) {
            float f = (float)player.getTicksUsingItem() / 20.0f;
            f = f > 1.0f ? 1.0f : f * f;
            event.setNewFovModifier((float)Mth.lerp((double)((Double)Minecraft.getInstance().options.fovEffectScale().get()), (double)1.0, (double)(event.getFovModifier() * (1.0f - f * 0.15f))));
        }
    }

    private void unrenderHeadWithTrophies(RenderLivingEvent.Pre<?, ?> event) {
        ItemStack stack = event.getEntity().getItemBySlot(EquipmentSlot.HEAD);
        boolean visible = !(stack.getItem() instanceof TrophyItem) && !this.areCuriosEquipped(event.getEntity());
        boolean isPlayer = event.getEntity() instanceof Player;
        EntityModel entityModel = event.getRenderer().getModel();
        if (entityModel instanceof HeadedModel) {
            HeadedModel headedModel = (HeadedModel)entityModel;
            headedModel.getHead().visible = visible && (!isPlayer || headedModel.getHead().visible);
            EntityModel entityModel2 = event.getRenderer().getModel();
            if (entityModel2 instanceof HumanoidModel) {
                HumanoidModel humanoidModel = (HumanoidModel)entityModel2;
                humanoidModel.hat.visible = visible && (!isPlayer || humanoidModel.hat.visible);
            }
        }
    }

    private boolean areCuriosEquipped(LivingEntity entity) {
        if (ModList.get().isLoaded("curios")) {
            return CuriosCompat.isCurioEquippedAndVisible(entity, stack -> stack.getItem() instanceof TrophyItem);
        }
        return false;
    }

    private void translateBookAuthor(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.getItem() instanceof WrittenBookItem && stack.has(DataComponents.WRITTEN_BOOK_CONTENT) && stack.has(TFDataComponents.TRANSLATABLE_BOOK)) {
            List components = event.getToolTip();
            for (int i = 0; i < components.size(); ++i) {
                net.minecraft.network.chat.Component component = (net.minecraft.network.chat.Component)components.get(i);
                if (!component.toString().contains("book.byAuthor")) continue;
                components.set(i, net.minecraft.network.chat.Component.translatable((String)"book.byAuthor", (Object[])new Object[]{net.minecraft.network.chat.Component.translatable((String)"twilightforest.book.author")}).withStyle(component.getStyle()));
            }
        }
    }

    private void renderGiantBlockOutlines(RenderHighlightEvent.Block event) {
        BlockItem blockItem;
        Item item;
        BlockPos pos = event.getTarget().getBlockPos();
        BlockState state = event.getCamera().getEntity().level().getBlockState(pos);
        if (state.getBlock() instanceof MiniatureStructureBlock) {
            event.setCanceled(true);
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && (player.getMainHandItem().getItem() instanceof GiantPickItem || (item = player.getMainHandItem().getItem()) instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() instanceof GiantBlock)) {
            event.setCanceled(true);
            if (!state.isAir() && player.level().getWorldBorder().isWithinBounds(pos)) {
                BlockPos offsetPos = new BlockPos(pos.getX() & 0xFFFFFFFC, pos.getY() & 0xFFFFFFFC, pos.getZ() & 0xFFFFFFFC);
                VertexConsumer consumer = event.getMultiBufferSource().getBuffer(RenderType.lines());
                Vec3 xyz = Vec3.atLowerCornerOf((Vec3i)offsetPos).subtract(event.getCamera().getPosition());
                LevelRenderer.renderShape((PoseStack)event.getPoseStack(), (VertexConsumer)consumer, (VoxelShape)this.GIANT_BLOCK, (double)xyz.x(), (double)xyz.y(), (double)xyz.z(), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.45f);
            }
        }
    }

    private void renderCustomBossbars(CustomizeGuiOverlayEvent.BossEventProgress event) {
        LerpingBossEvent lerpingBossEvent = event.getBossEvent();
        if (lerpingBossEvent instanceof ClientTFBossBar) {
            ClientTFBossBar bossEvent = (ClientTFBossBar)lerpingBossEvent;
            event.setCanceled(true);
            bossEvent.renderBossBar(event.getGuiGraphics(), event.getX(), event.getY());
        }
    }
}

