/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block.entity.spawner;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.EventHooks;
import twilightforest.block.entity.spawner.BossSpawnerBlockEntity;
import twilightforest.entity.boss.Lich;
import twilightforest.init.TFBlockEntities;
import twilightforest.init.TFEntities;
import twilightforest.init.TFParticleType;

public class LichSpawnerBlockEntity
extends BossSpawnerBlockEntity<Lich> {
    public LichSpawnerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFBlockEntities.LICH_SPAWNER.get(), (EntityType)TFEntities.LICH.get(), pos, state);
    }

    @Override
    public boolean anyPlayerInRange(Level level) {
        Player closestPlayer = level.getNearestPlayer((double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 0.5, (double)this.getBlockPos().getZ() + 0.5, (double)this.getRange(), false);
        return closestPlayer != null && closestPlayer.getY() > (double)(this.getBlockPos().getY() - 4);
    }

    @Override
    protected boolean spawnMyBoss(ServerLevelAccessor accessor) {
        Lich myCreature = (Lich)this.makeMyCreature();
        BlockPos.MutableBlockPos mutableBlockPos = this.getBlockPos().mutable();
        while (accessor.getMinBuildHeight() < mutableBlockPos.getY() && accessor.getBlockState(mutableBlockPos.below()).isAir()) {
            mutableBlockPos.move(Direction.DOWN);
        }
        mutableBlockPos.move(Direction.UP);
        myCreature.moveTo((BlockPos)mutableBlockPos, accessor.getLevel().random.nextFloat() * 360.0f, 0.0f);
        EventHooks.finalizeMobSpawn((Mob)myCreature, (ServerLevelAccessor)accessor, (DifficultyInstance)accessor.getCurrentDifficultyAt((BlockPos)mutableBlockPos), (MobSpawnType)MobSpawnType.SPAWNER, null);
        myCreature.setAttackCooldown(40);
        myCreature.setExtinguishTimer();
        myCreature.setRestrictionPoint(GlobalPos.of((ResourceKey)myCreature.level().dimension(), (BlockPos)mutableBlockPos));
        return accessor.addFreshEntity((Entity)myCreature);
    }

    @Override
    public ParticleOptions getSpawnerParticle() {
        return (ParticleOptions)TFParticleType.OMINOUS_FLAME.get();
    }
}

