/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import twilightforest.block.ConnectableRotatedPillarBlock;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFDamageTypes;

public class ThornsBlock
extends ConnectableRotatedPillarBlock
implements SimpleWaterloggedBlock {
    protected static final VoxelShape BASE_SHAPE = Block.box((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0);
    protected static final VoxelShape WEST_SHAPE = Block.box((double)0.0, (double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0);
    protected static final VoxelShape EAST_SHAPE = Block.box((double)13.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0);
    protected static final VoxelShape DOWN_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)3.0, (double)13.0);
    protected static final VoxelShape UP_SHAPE = Block.box((double)3.0, (double)13.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    protected static final VoxelShape NORTH_SHAPE = Block.box((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)3.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.box((double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0, (double)16.0);
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final float THORN_DAMAGE = 4.0f;

    public ThornsBlock(BlockBehaviour.Properties properties) {
        super(properties, 10.0);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)AXIS, (Comparable)Direction.Axis.Y)).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public boolean canConnectTo(Direction.Axis thisAxis, Direction facing, BlockState facingState, boolean solidSide) {
        return facingState.getBlock() instanceof ThornsBlock || facingState.getBlock().equals(TFBlocks.THORN_ROSE.get()) || facingState.getBlock().equals(TFBlocks.THORN_LEAVES.get()) || facingState.getBlock().equals(TFBlocks.WEATHERED_DEADROCK.get());
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        VoxelShape shape = BASE_SHAPE;
        if (((Boolean)state.getValue((Property)DOWN)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)DOWN_SHAPE);
        }
        if (((Boolean)state.getValue((Property)UP)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)UP_SHAPE);
        }
        if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)NORTH_SHAPE);
        }
        if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)SOUTH_SHAPE);
        }
        if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)WEST_SHAPE);
        }
        if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)EAST_SHAPE);
        }
        return shape;
    }

    @Nullable
    public PathType getBlockPathType(BlockState state, BlockGetter getter, BlockPos pos, @Nullable Mob entity) {
        return PathType.DAMAGE_OTHER;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        ItemEntity item;
        if (!(entity instanceof ItemEntity) || !(item = (ItemEntity)entity).getItem().is(ItemTagGenerator.IMMUNE_TO_THORNS)) {
            entity.hurt(TFDamageTypes.getDamageSource(level, TFDamageTypes.THORNS, new EntityType[0]), 4.0f);
        }
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (state.getBlock() instanceof ThornsBlock && state.getValue((Property)AXIS) == Direction.Axis.Y) {
            this.entityInside(state, level, pos, entity);
        }
        super.stepOn(level, pos, state, entity);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (!player.getAbilities().instabuild) {
            if (!level.isClientSide()) {
                this.doThornBurst(level, pos, state);
            }
            return false;
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    private void doThornBurst(Level level, BlockPos pos, BlockState state) {
        switch ((Direction.Axis)state.getValue((Property)AXIS)) {
            case Y: {
                this.growThorns(level, pos, Direction.UP);
                this.growThorns(level, pos, Direction.DOWN);
                break;
            }
            case X: {
                this.growThorns(level, pos, Direction.EAST);
                this.growThorns(level, pos, Direction.WEST);
                break;
            }
            case Z: {
                this.growThorns(level, pos, Direction.NORTH);
                this.growThorns(level, pos, Direction.SOUTH);
            }
        }
        this.growThorns(level, pos, Direction.getRandom((RandomSource)level.getRandom()));
        this.growThorns(level, pos, Direction.getRandom((RandomSource)level.getRandom()));
        this.growThorns(level, pos, Direction.getRandom((RandomSource)level.getRandom()));
    }

    private void growThorns(Level level, BlockPos pos, Direction dir) {
        BlockPos dPos;
        int length = 1 + level.getRandom().nextInt(3);
        for (int i = 1; i < length && level.isEmptyBlock(dPos = pos.relative(dir, i)); ++i) {
            level.setBlock(dPos, (BlockState)((Block)TFBlocks.GREEN_THORNS.get()).defaultBlockState().setValue((Property)AXIS, (Comparable)dir.getAxis()), 2);
        }
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction.Axis axis = context.getClickedFace().getAxis();
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)AXIS, (Comparable)context.getClickedFace().getAxis());
        BlockPos pos = context.getClickedPos();
        for (Direction direction : Direction.values()) {
            BlockPos relativePos = pos.relative(direction);
            BlockState relativeState = context.getLevel().getBlockState(relativePos);
            state = (BlockState)state.setValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(this.canConnectTo(axis, direction, relativeState, true)));
        }
        return (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER));
    }

    @Override
    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor accessor, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            accessor.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)accessor));
        }
        if (facingState.is(Blocks.AIR)) {
            return state;
        }
        return super.updateShape(state, facing, facingState, accessor, currentPos, facingPos);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{WATERLOGGED}));
    }
}

