/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import twilightforest.init.TFBlocks;

public class ThornRoseBlock
extends BushBlock {
    public static final MapCodec<ThornRoseBlock> CODEC = ThornRoseBlock.simpleCodec(ThornRoseBlock::new);
    private static final float RADIUS = 0.4f;
    private static final VoxelShape AABB = Shapes.create((AABB)new AABB(0.09999999403953552, 0.09999999403953552, 0.09999999403953552, (double)0.9f, (double)0.9f, (double)0.9f));

    public ThornRoseBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)DirectionalBlock.FACING, (Comparable)Direction.UP));
    }

    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState blockstate = level.getBlockState(pos.relative(((Direction)state.getValue((Property)DirectionalBlock.FACING)).getOpposite()));
        return blockstate.is(TFBlocks.BROWN_THORNS) || blockstate.is(TFBlocks.GREEN_THORNS) || blockstate.isFaceSturdy((BlockGetter)level, pos, (Direction)state.getValue((Property)DirectionalBlock.FACING));
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return AABB;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DirectionalBlock.FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)DirectionalBlock.FACING, (Comparable)context.getClickedFace());
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)DirectionalBlock.FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)DirectionalBlock.FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)DirectionalBlock.FACING)));
    }
}

