/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.SpreadingSnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;
import twilightforest.block.SnowLoggable;

public abstract class TFBushBlock
extends Block
implements SnowLoggable {
    public static final IntegerProperty AGE = BlockStateProperties.AGE_3;
    public static final int MAX_AGE = 3;
    private final ResourceKey<LootTable> berryLoot;
    private static final VoxelShape SMALL_SNOWY_BUSH_SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0);
    private static final VoxelShape MEDIUM_SNOWY_BUSH_SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
    private static final VoxelShape[] SMALL_BUSH_SHAPES = (VoxelShape[])Util.make((Object)new VoxelShape[9], shapes -> {
        shapes[0] = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
        for (int i = 1; i <= 8; ++i) {
            shapes[i] = Shapes.or((VoxelShape)SMALL_SNOWY_BUSH_SHAPE, (VoxelShape)SNOW_SHAPE_BY_LAYER[i]);
        }
    });
    private static final VoxelShape[] MEDIUM_BUSH_SHAPES = (VoxelShape[])Util.make((Object)new VoxelShape[9], shapes -> {
        shapes[0] = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
        for (int i = 1; i <= 8; ++i) {
            shapes[i] = Shapes.or((VoxelShape)MEDIUM_SNOWY_BUSH_SHAPE, (VoxelShape)SNOW_SHAPE_BY_LAYER[i]);
        }
    });

    public TFBushBlock(ResourceKey<LootTable> berryLoot, BlockBehaviour.Properties properties) {
        super(properties);
        this.berryLoot = berryLoot;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)SNOW_LAYERS, (Comparable)Integer.valueOf(0)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState maybeSnow = context.getLevel().getBlockState(context.getClickedPos());
        if (maybeSnow.is(Blocks.SNOW) && (Integer)maybeSnow.getValue((Property)SnowLayerBlock.LAYERS) == 1) {
            return (BlockState)super.getStateForPlacement(context).setValue((Property)SNOW_LAYERS, (Comparable)Integer.valueOf(1));
        }
        return super.getStateForPlacement(context);
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if ((Integer)state.getValue((Property)SNOW_LAYERS) > 0 && !Blocks.SNOW.defaultBlockState().canSurvive((LevelReader)level, pos)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)SNOW_LAYERS, (Comparable)Integer.valueOf(0)), 2);
            level.levelEvent(2001, pos, Block.getId((BlockState)Blocks.SNOW.defaultBlockState()));
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE}).add(new Property[]{SNOW_LAYERS});
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Integer)state.getValue((Property)AGE)) {
            case 1 -> MEDIUM_BUSH_SHAPES[(Integer)state.getValue((Property)SNOW_LAYERS)];
            case 2, 3 -> Shapes.block();
            default -> SMALL_BUSH_SHAPES[(Integer)state.getValue((Property)SNOW_LAYERS)];
        };
    }

    protected float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if ((Integer)state.getValue((Property)AGE) < 3 && random.nextInt(20) == 0 && this.canGrowAt(state, (LevelReader)level, pos)) {
            this.grow(state, level, pos, (Integer)state.getValue((Property)AGE) + 1);
        }
        this.meltSnow(state, (Level)level, pos);
    }

    protected void grow(BlockState state, ServerLevel level, BlockPos pos, int age) {
        level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age)), 2);
        if (age == 2 && (Integer)state.getValue((Property)SNOW_LAYERS) > 0) {
            BlockState aboveState = level.getBlockState(pos.above());
            if (aboveState.canBeReplaced()) {
                level.setBlock(pos.above(), Blocks.SNOW.defaultBlockState(), 2);
            } else if (aboveState.getBlock() instanceof SnowLoggable && (Integer)aboveState.getValue((Property)SNOW_LAYERS) == 0) {
                level.setBlock(pos.above(), (BlockState)aboveState.setValue((Property)SNOW_LAYERS, (Comparable)Integer.valueOf(1)), 2);
            }
        }
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if ((Integer)state.getValue((Property)AGE) == 3) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                TFBushBlock.dropFromBlockInteractLootTable(serverLevel, this.berryLoot, state, pos, (level1, stack) -> ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack));
                level.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.getRandom().nextFloat() * 0.4f);
                BlockState newState = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(2));
                level.setBlock(pos, newState, 2);
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)newState));
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!stack.is(Items.SNOW) || (Integer)state.getValue((Property)SNOW_LAYERS) == 8 || !Blocks.SNOW.defaultBlockState().canSurvive((LevelReader)level, pos)) {
            return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
        }
        BlockState newState = (BlockState)state.setValue((Property)SNOW_LAYERS, (Comparable)Integer.valueOf((Integer)state.getValue((Property)SNOW_LAYERS) + 1));
        if (this.isColliding(player, pos, newState)) {
            return ItemInteractionResult.FAIL;
        }
        if (!player.hasInfiniteMaterials()) {
            stack.shrink(1);
        }
        level.setBlock(pos, newState, 19);
        level.playSound(player, pos, SoundEvents.SNOW_PLACE, SoundSource.BLOCKS);
        TFBushBlock.updateSnowBeneath(level, pos);
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    private static void updateSnowBeneath(Level level, BlockPos pos) {
        if (level.getBlockState(pos.below()).getBlock() instanceof SpreadingSnowyDirtBlock) {
            level.setBlock(pos.below(), (BlockState)level.getBlockState(pos.below()).setValue((Property)SnowyDirtBlock.SNOWY, (Comparable)Boolean.valueOf(true)), 2);
        }
    }

    protected void spawnDestroyParticles(Level level, Player player, BlockPos pos, BlockState state) {
        if (!player.isSecondaryUseActive() && (Integer)state.getValue((Property)SNOW_LAYERS) > 0) {
            return;
        }
        super.spawnDestroyParticles(level, player, pos, state);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (!player.isSecondaryUseActive() && (Integer)state.getValue((Property)SNOW_LAYERS) > 0) {
            this.handleBreakingLogic(level, pos, state, player, null);
            return false;
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    @Nullable
    public PushReaction getPistonPushReaction(BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 2 ? PushReaction.DESTROY : null;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState stateBelow = level.getBlockState(pos.below());
        boolean isSameMatureBush = stateBelow.is(state.getBlock()) && (Integer)stateBelow.getValue((Property)AGE) >= 2;
        return this.canBePlacedAt(stateBelow) || isSameMatureBush;
    }

    public abstract boolean canBePlacedAt(BlockState var1);

    protected boolean canGrowAt(BlockState state, LevelReader level, BlockPos pos) {
        return this.canSurvive(state, level, pos);
    }

    protected static void dropFromBlockInteractLootTable(ServerLevel serverlevel, ResourceKey<LootTable> resourcekey, BlockState blockstate, BlockPos pos, BiConsumer<ServerLevel, ItemStack> biconsumer) {
        TFBushBlock.dropFromLootTable(serverlevel, resourcekey, builder -> builder.withParameter(LootContextParams.BLOCK_STATE, (Object)blockstate).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY).create(LootContextParamSets.BLOCK), biconsumer);
    }

    protected static void dropFromLootTable(ServerLevel serverlevel, ResourceKey<LootTable> resourcekey, Function<LootParams.Builder, LootParams> function, BiConsumer<ServerLevel, ItemStack> biconsumer) {
        LootParams lootparams;
        LootTable loottable = serverlevel.getServer().reloadableRegistries().getLootTable(resourcekey);
        ObjectArrayList list = loottable.getRandomItems(lootparams = function.apply(new LootParams.Builder(serverlevel)));
        if (!list.isEmpty()) {
            list.forEach(itemstack -> biconsumer.accept(serverlevel, (ItemStack)itemstack));
        }
    }
}

