/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import twilightforest.block.TFHorizontalBlock;
import twilightforest.block.entity.SkullChestBlockEntity;
import twilightforest.enums.BlockLoggingEnum;
import twilightforest.init.TFBlockEntities;

public class SkullChestBlock
extends BaseEntityBlock
implements BlockLoggingEnum.IMultiLoggable {
    public static final DirectionProperty FACING = TFHorizontalBlock.FACING;
    public static final MapCodec<SkullChestBlock> CODEC = SkullChestBlock.simpleCodec(SkullChestBlock::new);
    private static final VoxelShape BOTTOM_X = Block.box((double)2.0, (double)0.0, (double)1.0, (double)14.0, (double)6.0, (double)15.0);
    private static final VoxelShape TOP_X = Block.box((double)1.0, (double)6.0, (double)0.0, (double)15.0, (double)14.0, (double)16.0);
    private static final VoxelShape BOTTOM_Z = Block.box((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)6.0, (double)14.0);
    private static final VoxelShape TOP_Z = Block.box((double)0.0, (double)6.0, (double)1.0, (double)16.0, (double)14.0, (double)15.0);
    private static final VoxelShape CASKET_X = Shapes.or((VoxelShape)BOTTOM_X, (VoxelShape)TOP_X);
    private static final VoxelShape CASKET_Z = Shapes.or((VoxelShape)BOTTOM_Z, (VoxelShape)TOP_Z);
    private static final VoxelShape SOLID = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    private static final VoxelShape TOPPER_X = Block.box((double)1.0, (double)12.0, (double)0.0, (double)15.0, (double)14.0, (double)16.0);
    private static final VoxelShape TOPPER_Z = Block.box((double)0.0, (double)12.0, (double)1.0, (double)16.0, (double)14.0, (double)15.0);
    private static final VoxelShape SOLID_X = Shapes.or((VoxelShape)SOLID, (VoxelShape)TOPPER_X);
    private static final VoxelShape SOLID_Z = Shapes.or((VoxelShape)SOLID, (VoxelShape)TOPPER_Z);

    public SkullChestBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends SkullChestBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState state) {
        return ((BlockLoggingEnum)((Object)state.getValue(BlockLoggingEnum.MULTILOGGED))).getBlock() == Blocks.AIR ? RenderShape.ENTITYBLOCK_ANIMATED : RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        if (((BlockLoggingEnum)((Object)state.getValue(BlockLoggingEnum.MULTILOGGED))).getBlock() != Blocks.AIR && ((BlockLoggingEnum)((Object)state.getValue(BlockLoggingEnum.MULTILOGGED))).getFluid() == Fluids.EMPTY) {
            return direction.getAxis() == Direction.Axis.X ? SOLID_X : SOLID_Z;
        }
        return direction.getAxis() == Direction.Axis.X ? CASKET_X : CASKET_Z;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SkullChestBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return SkullChestBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)TFBlockEntities.SKULL_CHEST.get()), SkullChestBlockEntity::tick);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity tileentity = level.getBlockEntity(pos);
            if (tileentity instanceof Container) {
                Containers.dropContents((Level)level, (BlockPos)pos, (Container)((Container)tileentity));
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    public float getExplosionResistance(BlockState state, BlockGetter getter, BlockPos pos, Explosion explosion) {
        return Float.MAX_VALUE;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (((BlockLoggingEnum)((Object)state.getValue(BlockLoggingEnum.MULTILOGGED))).getBlock() == Blocks.AIR || ((BlockLoggingEnum)((Object)state.getValue(BlockLoggingEnum.MULTILOGGED))).getFluid() != Fluids.EMPTY) {
            if (level.isClientSide()) {
                return ItemInteractionResult.SUCCESS;
            }
            MenuProvider menuProvider = this.getMenuProvider(state, level, pos);
            if (menuProvider != null) {
                player.openMenu(menuProvider);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity tile;
        if (!level.isClientSide() && !player.isCreative() && level.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS) && (tile = level.getBlockEntity(pos)) instanceof SkullChestBlockEntity) {
            Block block;
            SkullChestBlockEntity chest = (SkullChestBlockEntity)tile;
            ItemStack stack = new ItemStack((ItemLike)this);
            ItemEntity itementity = new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), stack);
            this.modifyDrop(state, stack);
            if (chest.hasCustomName()) {
                if (chest.owner != null) {
                    itementity.setCustomName(chest.getDisplayName());
                } else {
                    itementity.setCustomName(chest.getCustomName());
                }
            }
            if (((BlockLoggingEnum)((Object)state.getValue(BlockLoggingEnum.MULTILOGGED))).getFluid() == Fluids.EMPTY && (block = ((BlockLoggingEnum)((Object)state.getValue(BlockLoggingEnum.MULTILOGGED))).getBlock()) != Blocks.AIR) {
                ItemStack blockstack = new ItemStack((ItemLike)block);
                ItemEntity item = new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), blockstack);
                item.setDefaultPickUpDelay();
                level.addFreshEntity((Entity)item);
            }
            itementity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)itementity);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    protected void modifyDrop(BlockState state, ItemStack stack) {
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        this.reactWithNeighbors(level, pos, state);
        super.neighborChanged(state, level, pos, block, fromPos, isMoving);
    }

    private void reactWithNeighbors(Level level, BlockPos pos, BlockState state) {
        block4: {
            block3: {
                if (state.getValue(BlockLoggingEnum.MULTILOGGED) != BlockLoggingEnum.LAVA) break block3;
                boolean flag = level.getBlockState(pos.below()).is(Blocks.SOUL_SOIL);
                for (Direction direction : Direction.values()) {
                    if (direction == Direction.DOWN) continue;
                    BlockPos blockpos = pos.relative(direction);
                    if (level.getFluidState(blockpos).is(FluidTags.WATER)) {
                        level.setBlockAndUpdate(pos, (BlockState)state.setValue(BlockLoggingEnum.MULTILOGGED, (Comparable)((Object)BlockLoggingEnum.OBSIDIAN)));
                        level.levelEvent(1501, pos, 0);
                    }
                    if (!flag || !level.getBlockState(blockpos).is(Blocks.BLUE_ICE)) continue;
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue(BlockLoggingEnum.MULTILOGGED, (Comparable)((Object)BlockLoggingEnum.BASALT)));
                    level.levelEvent(1501, pos, 0);
                }
                break block4;
            }
            if (state.getValue(BlockLoggingEnum.MULTILOGGED) != BlockLoggingEnum.WATER) break block4;
            for (Direction direction : Direction.values()) {
                BlockPos blockpos;
                if (direction == Direction.DOWN || !level.getFluidState(blockpos = pos.relative(direction)).is(FluidTags.LAVA)) continue;
                level.setBlockAndUpdate(pos, (BlockState)state.setValue(BlockLoggingEnum.MULTILOGGED, (Comparable)((Object)BlockLoggingEnum.STONE)));
                level.levelEvent(1501, pos, 0);
            }
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)level.getBlockEntity(pos));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockLoggingEnum.MULTILOGGED, FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue(BlockLoggingEnum.MULTILOGGED, (Comparable)((Object)BlockLoggingEnum.getFromFluid(context.getLevel().getFluidState(context.getClickedPos()).getType())));
    }

    public FluidState getFluidState(BlockState state) {
        return ((BlockLoggingEnum)((Object)state.getValue(BlockLoggingEnum.MULTILOGGED))).getFluid().defaultFluidState();
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter getter, BlockPos pos, Entity entity) {
        return false;
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)mirror.mirror((Direction)state.getValue((Property)FACING)));
    }
}

