/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import twilightforest.block.FireJetBlock;
import twilightforest.enums.FireJetVariant;
import twilightforest.init.TFSounds;

public class EncasedFireJetBlock
extends FireJetBlock {
    public static final EnumProperty<FireJetVariant> STATE = FireJetBlock.STATE;

    public EncasedFireJetBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        FireJetVariant variant = (FireJetVariant)((Object)state.getValue(STATE));
        boolean powered = level.hasNeighborSignal(pos);
        if (variant == FireJetVariant.IDLE && powered) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue(STATE, (Comparable)((Object)FireJetVariant.POPPING)));
            level.playSound(null, pos, (SoundEvent)TFSounds.JET_START.get(), SoundSource.BLOCKS, 0.3f, 0.6f);
        } else if (variant == FireJetVariant.TIMEOUT && !powered) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue(STATE, (Comparable)((Object)FireJetVariant.IDLE)));
        }
    }
}

