/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class ConnectableRotatedPillarBlock
extends RotatedPillarBlock {
    protected static final BooleanProperty NORTH = PipeBlock.NORTH;
    protected static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    protected static final BooleanProperty WEST = PipeBlock.WEST;
    protected static final BooleanProperty EAST = PipeBlock.EAST;
    protected static final BooleanProperty UP = PipeBlock.UP;
    protected static final BooleanProperty DOWN = PipeBlock.DOWN;
    final double boundingBoxWidthLower;
    final double boundingBoxWidthUpper;

    public ConnectableRotatedPillarBlock(BlockBehaviour.Properties properties, double width) {
        super(properties);
        if (width >= 16.0) {
            this.boundingBoxWidthLower = 0.0;
            this.boundingBoxWidthUpper = 16.0;
        } else {
            this.boundingBoxWidthLower = 8.0 - width / 2.0;
            this.boundingBoxWidthUpper = 16.0 - this.boundingBoxWidthLower;
        }
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)AXIS, (Comparable)Direction.Axis.Y)).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{NORTH, EAST, SOUTH, WEST, DOWN, UP}));
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor accessor, BlockPos pos, BlockPos facingPos) {
        return (BlockState)state.setValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(facing), (Comparable)Boolean.valueOf(this.canConnectTo((Direction.Axis)state.getValue((Property)AXIS), facing, facingState, facingState.isFaceSturdy((BlockGetter)accessor, facingPos, facing.getOpposite()))));
    }

    public boolean canConnectTo(Direction.Axis thisAxis, Direction facing, BlockState facingState, boolean solidSide) {
        return !ConnectableRotatedPillarBlock.isExceptionForConnection((BlockState)facingState) && solidSide;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level iblockreader = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        BlockPos blockpos1 = blockpos.north();
        BlockPos blockpos2 = blockpos.south();
        BlockPos blockpos3 = blockpos.west();
        BlockPos blockpos4 = blockpos.east();
        BlockState blockstate = iblockreader.getBlockState(blockpos1);
        BlockState blockstate1 = iblockreader.getBlockState(blockpos2);
        BlockState blockstate2 = iblockreader.getBlockState(blockpos3);
        BlockState blockstate3 = iblockreader.getBlockState(blockpos4);
        Direction.Axis axis = context.getClickedFace().getAxis();
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)AXIS, (Comparable)axis)).setValue((Property)NORTH, (Comparable)Boolean.valueOf(this.canConnectTo(axis, Direction.NORTH, blockstate, blockstate.isFaceSturdy((BlockGetter)iblockreader, blockpos1, Direction.SOUTH))))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(this.canConnectTo(axis, Direction.SOUTH, blockstate1, blockstate1.isFaceSturdy((BlockGetter)iblockreader, blockpos2, Direction.NORTH))))).setValue((Property)WEST, (Comparable)Boolean.valueOf(this.canConnectTo(axis, Direction.WEST, blockstate2, blockstate2.isFaceSturdy((BlockGetter)iblockreader, blockpos3, Direction.EAST))))).setValue((Property)EAST, (Comparable)Boolean.valueOf(this.canConnectTo(axis, Direction.EAST, blockstate3, blockstate3.isFaceSturdy((BlockGetter)iblockreader, blockpos4, Direction.WEST))));
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return switch ((Direction.Axis)state.getValue((Property)AXIS)) {
            case Direction.Axis.X -> ConnectableRotatedPillarBlock.box((double)0.0, (double)((Boolean)state.getValue((Property)NORTH) != false ? 0.0 : this.boundingBoxWidthLower), (double)((Boolean)state.getValue((Property)WEST) != false ? 0.0 : this.boundingBoxWidthLower), (double)16.0, (double)((Boolean)state.getValue((Property)SOUTH) != false ? 16.0 : this.boundingBoxWidthUpper), (double)((Boolean)state.getValue((Property)EAST) != false ? 16.0 : this.boundingBoxWidthUpper));
            case Direction.Axis.Z -> ConnectableRotatedPillarBlock.box((double)((Boolean)state.getValue((Property)EAST) != false ? 0.0 : this.boundingBoxWidthLower), (double)((Boolean)state.getValue((Property)SOUTH) != false ? 0.0 : this.boundingBoxWidthLower), (double)0.0, (double)((Boolean)state.getValue((Property)WEST) != false ? 16.0 : this.boundingBoxWidthUpper), (double)((Boolean)state.getValue((Property)NORTH) != false ? 16.0 : this.boundingBoxWidthUpper), (double)16.0);
            default -> ConnectableRotatedPillarBlock.box((double)((Boolean)state.getValue((Property)WEST) != false ? 0.0 : this.boundingBoxWidthLower), (double)0.0, (double)((Boolean)state.getValue((Property)NORTH) != false ? 0.0 : this.boundingBoxWidthLower), (double)((Boolean)state.getValue((Property)EAST) != false ? 16.0 : this.boundingBoxWidthUpper), (double)16.0, (double)((Boolean)state.getValue((Property)SOUTH) != false ? 16.0 : this.boundingBoxWidthUpper));
        };
    }
}

