/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.beanification.processors.finalize;

import java.lang.annotation.ElementType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforgespi.language.ModFileScanData;
import twilightforest.beanification.BeanContext;
import twilightforest.beanification.BeanDefinition;
import twilightforest.beanification.BeanLifeCycle;
import twilightforest.beanification.InternalAutowired;
import twilightforest.beanification.PostConstruct;
import twilightforest.beanification.internal.DistAnnotationRetriever;
import twilightforest.beanification.internal.InternalReflectionHelper;
import twilightforest.beanification.processors.BeanProcessor;
import twilightforest.beanification.processors.IBeanProcessor;

@BeanProcessor(value=BeanLifeCycle.Finalize)
public class PostConstructAnnotationFinalizeBeanProcessor
implements IBeanProcessor {
    @InternalAutowired
    private DistAnnotationRetriever distAnnotationRetriever;
    @InternalAutowired
    private InternalReflectionHelper internalReflectionHelper;

    @Override
    public void process(BeanContext.BeanLifeCycleContext context, ModContainer modContainer, ModFileScanData scanData) throws Throwable {
        for (Map.Entry<BeanDefinition<?>, Object> entry : context.beans().orElseThrow().entrySet()) {
            Object bean = entry.getValue();
            Iterator it = this.distAnnotationRetriever.retrieve(scanData, ElementType.METHOD, PostConstruct.class).filter(a -> a.clazz().equals((Object)this.internalReflectionHelper.getType(bean.getClass()))).iterator();
            while (it.hasNext()) {
                String name = ((ModFileScanData.AnnotationData)it.next()).memberName();
                ArrayList<Method> methods = new ArrayList<Method>();
                try {
                    methods.add(this.internalReflectionHelper.getDeclaredMethod(bean.getClass(), name, new Class[0]));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                try {
                    methods.add(this.internalReflectionHelper.getDeclaredMethod(bean.getClass(), name, IEventBus.class));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                try {
                    methods.add(this.internalReflectionHelper.getDeclaredMethod(bean.getClass(), name, IEventBus.class, IEventBus.class));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                for (Method method : methods) {
                    if (!method.isAnnotationPresent(PostConstruct.class)) continue;
                    context.currentInjection().orElseThrow().set(method);
                    if (this.internalReflectionHelper.isStatic(method)) {
                        throw new IllegalStateException("@PostConstruct methods must be non-static");
                    }
                    method.trySetAccessible();
                    if (method.getParameterCount() == 2 && method.getParameterTypes()[0].equals(IEventBus.class) && method.getParameterTypes()[1].equals(IEventBus.class)) {
                        boolean isModType = method.getAnnotation(PostConstruct.class).value() == PostConstruct.Bus.MOD;
                        method.invoke(bean, isModType ? modContainer.getEventBus() : NeoForge.EVENT_BUS, isModType ? NeoForge.EVENT_BUS : modContainer.getEventBus());
                        continue;
                    }
                    if (method.getParameterCount() == 1 && method.getParameterTypes()[0].equals(IEventBus.class)) {
                        method.invoke(bean, method.getAnnotation(PostConstruct.class).value() == PostConstruct.Bus.MOD ? modContainer.getEventBus() : NeoForge.EVENT_BUS);
                        continue;
                    }
                    if (method.getParameterCount() != 0) {
                        throw new IllegalStateException("@PostConstruct methods must not have parameters or only have one or two IEventBus parameter(s)");
                    }
                    method.invoke(bean, new Object[0]);
                }
            }
        }
    }
}

