/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.levelgen.structure.Structure;
import twilightforest.init.TFAdvancements;

public class StructureClearedTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, ResourceKey<Structure> structure) {
        this.trigger(player, instance -> instance.test(structure));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, ResourceKey<Structure> structure) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)ResourceKey.codec((ResourceKey)Registries.STRUCTURE).fieldOf("structure").forGetter(TriggerInstance::structure)).apply((Applicative)instance, TriggerInstance::new));

        public static Criterion<TriggerInstance> clearedStructure(ResourceKey<Structure> structure) {
            return ((StructureClearedTrigger)((Object)TFAdvancements.STRUCTURE_CLEARED.get())).createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), structure));
        }

        boolean test(ResourceKey<Structure> structure) {
            return this.structure.equals(structure);
        }
    }
}

