/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import twilightforest.init.TFAdvancements;

public class AddModifierTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, ResourceLocation modifier) {
        this.trigger(player, instance -> instance.test(modifier));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<ResourceLocation> modifier) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)ResourceLocation.CODEC.optionalFieldOf("modifier").forGetter(TriggerInstance::modifier)).apply((Applicative)instance, TriggerInstance::new));

        public static Criterion<TriggerInstance> addedAnyModifier() {
            return ((AddModifierTrigger)((Object)TFAdvancements.ADD_MODIFIER.get())).createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), Optional.empty()));
        }

        public static Criterion<TriggerInstance> addedModifier(ResourceLocation modifier) {
            return ((AddModifierTrigger)((Object)TFAdvancements.ADD_MODIFIER.get())).createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), Optional.of(modifier)));
        }

        boolean test(ResourceLocation modifier) {
            return this.modifier().isEmpty() || this.modifier().get().equals((Object)modifier);
        }
    }
}

