/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.chunkgenerators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;
import org.jetbrains.annotations.NotNull;
import twilightforest.TFRegistries;
import twilightforest.world.components.layer.BiomeDensitySource;

public class TerrainDensityRouter
implements DensityFunction.SimpleFunction {
    public static final MapCodec<TerrainDensityRouter> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)RegistryFileCodec.create(TFRegistries.Keys.BIOME_TERRAIN_DATA, BiomeDensitySource.CODEC, (boolean)false).fieldOf("terrain_source").forGetter(TerrainDensityRouter::biomeDensitySourceHolder), (App)Codec.doubleRange((double)-64.0, (double)0.0).fieldOf("lower_density_bound").forGetter(TerrainDensityRouter::lowerDensityBound), (App)Codec.doubleRange((double)0.0, (double)64.0).fieldOf("upper_density_bound").forGetter(TerrainDensityRouter::upperDensityBound), (App)Codec.doubleRange((double)0.0, (double)32.0).orElse((Object)8.0).fieldOf("depth_scalar").forGetter(TerrainDensityRouter::depthScalar), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("base_factor").forGetter(TerrainDensityRouter::baseFactor), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("base_offset").forGetter(TerrainDensityRouter::baseOffset)).apply((Applicative)inst, TerrainDensityRouter::new));
    public static final KeyDispatchDataCodec<TerrainDensityRouter> KEY_CODEC = KeyDispatchDataCodec.of(CODEC);
    private final Holder<BiomeDensitySource> biomeDensitySourceHolder;
    private final double lowerDensityBound;
    private final double upperDensityBound;
    private final double depthScalar;
    private final DensityFunction baseFactor;
    private final DensityFunction baseOffset;

    public TerrainDensityRouter(Holder<BiomeDensitySource> biomeDensitySource, double lowerDensityBound, double upperDensityBound, double depthScalar, DensityFunction baseFactor, DensityFunction baseOffset) {
        this.biomeDensitySourceHolder = biomeDensitySource;
        this.lowerDensityBound = lowerDensityBound;
        this.upperDensityBound = upperDensityBound;
        this.depthScalar = depthScalar;
        this.baseFactor = baseFactor;
        this.baseOffset = baseOffset;
    }

    public double compute(DensityFunction.FunctionContext context) {
        BiomeDensitySource.DensityData densityData = this.computeTerrain(context);
        double depth = this.baseOffset.compute(context) + densityData.depth * this.baseFactor.compute(context);
        return depth + densityData.depth;
    }

    @NotNull
    public BiomeDensitySource.DensityData computeTerrain(DensityFunction.FunctionContext context) {
        return ((BiomeDensitySource)this.biomeDensitySourceHolder.value()).sampleTerrain(context.blockX(), context.blockZ(), context);
    }

    public double minValue() {
        return this.lowerDensityBound;
    }

    public double maxValue() {
        return this.upperDensityBound;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return KEY_CODEC;
    }

    public Holder<BiomeDensitySource> biomeDensitySourceHolder() {
        return this.biomeDensitySourceHolder;
    }

    public double lowerDensityBound() {
        return this.lowerDensityBound;
    }

    public double upperDensityBound() {
        return this.upperDensityBound;
    }

    public double depthScalar() {
        return this.depthScalar;
    }

    public DensityFunction baseFactor() {
        return this.baseFactor;
    }

    public DensityFunction baseOffset() {
        return this.baseOffset;
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new ChunkCachedDensityRouter(this.biomeDensitySourceHolder, this.lowerDensityBound, this.upperDensityBound, this.depthScalar, this.baseFactor, this.baseOffset));
    }

    public static class ChunkCachedDensityRouter
    extends TerrainDensityRouter {
        private final BiomeDensitySource biomeDensitySource;
        private final BiomeDensitySource.DensityData[] horizontalCache = new BiomeDensitySource.DensityData[256];

        public ChunkCachedDensityRouter(Holder<BiomeDensitySource> biomeDensitySource, double lowerDensityBound, double upperDensityBound, double depthScalar, DensityFunction baseFactor, DensityFunction baseOffset) {
            super(biomeDensitySource, lowerDensityBound, upperDensityBound, depthScalar, baseFactor, baseOffset);
            this.biomeDensitySource = (BiomeDensitySource)biomeDensitySource.value();
        }

        @Override
        @NotNull
        public BiomeDensitySource.DensityData computeTerrain(DensityFunction.FunctionContext context) {
            int xInChunk = SectionPos.sectionRelative((int)context.blockX());
            int zInChunk = SectionPos.sectionRelative((int)context.blockZ());
            int arrayCoord = zInChunk + (xInChunk << 4);
            BiomeDensitySource.DensityData dataColumn = this.horizontalCache[arrayCoord];
            if (dataColumn == null) {
                this.horizontalCache[arrayCoord] = dataColumn = this.biomeDensitySource.sampleTerrain(context.blockX(), context.blockZ(), context);
            }
            return dataColumn;
        }
    }
}

