/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.util.iterators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.jetbrains.annotations.NotNull;
import twilightforest.util.iterators.ZippedIterator;

public class RectangleLatticeIterator<T>
implements Iterator<T>,
Iterable<T> {
    private final int yLevel;
    private final int latticeStartX;
    private final int latticeStartZ;
    private final int latticeCountX;
    private final int latticeCountZ;
    private final float xSpacing;
    private final float zSpacing;
    private final float xOffset;
    private final float zOffset;
    private final TernaryIntegerFunction<T> converter;
    private int latticeX = 0;
    private int latticeZ = 0;

    public static RectangleLatticeIterator<BlockPos.MutableBlockPos> boundedGrid(BoundingBox chunkBounds, int yLevel, float xSpacing, float zSpacing, float xOffset, float zOffset) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        return new RectangleLatticeIterator<BlockPos.MutableBlockPos>(chunkBounds.minX(), chunkBounds.minZ(), chunkBounds.maxX(), chunkBounds.maxZ(), yLevel, xSpacing, zSpacing, xOffset, zOffset, (arg_0, arg_1, arg_2) -> ((BlockPos.MutableBlockPos)mutableBlockPos).set(arg_0, arg_1, arg_2));
    }

    public RectangleLatticeIterator(int minX, int minZ, int maxX, int maxZ, int yLevel, float xSpacing, float zSpacing, float xOffset, float zOffset, TernaryIntegerFunction<T> converter) {
        this.yLevel = yLevel;
        this.xSpacing = xSpacing;
        this.zSpacing = zSpacing;
        this.xOffset = xOffset;
        this.zOffset = zOffset;
        this.latticeStartX = RectangleLatticeIterator.getNearestLatticeIndex(this.xSpacing, (int)((float)minX - this.xOffset));
        this.latticeStartZ = RectangleLatticeIterator.getNearestLatticeIndex(this.zSpacing, (int)((float)minZ - this.zOffset));
        this.latticeCountX = RectangleLatticeIterator.getNearestLatticeIndex(this.xSpacing, (int)((float)(maxX + 1) - this.xOffset)) - this.latticeStartX;
        this.latticeCountZ = RectangleLatticeIterator.getNearestLatticeIndex(this.zSpacing, (int)((float)(maxZ + 1) - this.zOffset)) - this.latticeStartZ;
        this.converter = converter;
    }

    @Override
    public T next() {
        T ret = this.converter.apply(this.generateX(), this.yLevel, this.generateZ());
        if (this.latticeZ + 1 < this.latticeCountZ) {
            ++this.latticeZ;
        } else {
            this.latticeZ = 0;
            ++this.latticeX;
        }
        return ret;
    }

    private int generateX() {
        return (int)(this.xOffset + (float)(this.latticeStartX + this.latticeX) * this.xSpacing);
    }

    private int generateZ() {
        return (int)(this.zOffset + (float)(this.latticeStartZ + this.latticeZ) * this.zSpacing);
    }

    @Override
    public boolean hasNext() {
        return this.latticeX < this.latticeCountX;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this;
    }

    private static int getNearestLatticeIndex(float latticeSpacing, int i) {
        return Mth.floor((float)(((float)i - Mth.positiveModulo((float)i, (float)latticeSpacing)) / latticeSpacing));
    }

    @FunctionalInterface
    public static interface TernaryIntegerFunction<T> {
        public T apply(int var1, int var2, int var3);
    }

    public record TriangularLatticeConfig(float spacing, float xOffset, float zOffset, float xSpacing, float zSpacing) {
        private static final Codec<TriangularLatticeConfig> VERBOSE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)1.0f, (float)32.0f).fieldOf("spacing").forGetter(TriangularLatticeConfig::spacing), (App)Codec.floatRange((float)1.0f, (float)32.0f).fieldOf("x_offset").forGetter(TriangularLatticeConfig::xOffset), (App)Codec.floatRange((float)1.0f, (float)32.0f).fieldOf("z_offset").forGetter(TriangularLatticeConfig::zOffset), (App)Codec.floatRange((float)1.0f, (float)32.0f).fieldOf("x_spacing").forGetter(TriangularLatticeConfig::xSpacing), (App)Codec.floatRange((float)1.0f, (float)32.0f).fieldOf("z_spacing").forGetter(TriangularLatticeConfig::zSpacing)).apply((Applicative)instance, TriangularLatticeConfig::new));
        private static final Codec<TriangularLatticeConfig> OFFSET_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)1.0f, (float)32.0f).fieldOf("spacing").forGetter(TriangularLatticeConfig::spacing), (App)Codec.floatRange((float)1.0f, (float)32.0f).fieldOf("x_offset").forGetter(TriangularLatticeConfig::xOffset), (App)Codec.floatRange((float)1.0f, (float)32.0f).fieldOf("z_offset").forGetter(TriangularLatticeConfig::zOffset)).apply((Applicative)instance, TriangularLatticeConfig::new));
        private static final Codec<TriangularLatticeConfig> SPACING_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)1.0f, (float)32.0f).fieldOf("spacing").forGetter(TriangularLatticeConfig::spacing)).apply((Applicative)instance, TriangularLatticeConfig::new));
        public static final TriangularLatticeConfig DEFAULT = new TriangularLatticeConfig(3.5f);
        public static final Codec<TriangularLatticeConfig> CODEC = Codec.withAlternative(VERBOSE_CODEC, (Codec)Codec.withAlternative(OFFSET_CODEC, (Codec)Codec.withAlternative(SPACING_CODEC, (Codec)Codec.unit((Object)DEFAULT))));

        public TriangularLatticeConfig(float spacing) {
            this(spacing, Mth.cos((float)0.5235988f) * spacing, Mth.sin((float)0.5235988f) * spacing);
        }

        public TriangularLatticeConfig(float spacing, float xOffset, float zOffset) {
            this(spacing, xOffset, zOffset, xOffset * 2.0f, spacing);
        }

        public static TriangularLatticeConfig fromNBT(CompoundTag tag) {
            float zOffset;
            float spacing = tag.getFloat("spacing");
            if ((double)spacing <= 1.0E-7) {
                spacing = 3.5f;
            }
            float xOffset = tag.contains("x_offset", 5) ? tag.getFloat("x_offset") : Mth.cos((float)0.5235988f) * spacing;
            float f = zOffset = tag.contains("z_offset", 5) ? tag.getFloat("z_offset") : Mth.sin((float)0.5235988f) * spacing;
            if (tag.contains("x_spacing", 5) || tag.contains("z_spacing", 5)) {
                return new TriangularLatticeConfig(spacing, xOffset, zOffset, tag.getFloat("x_spacing"), tag.getFloat("z_spacing"));
            }
            return new TriangularLatticeConfig(spacing, xOffset, zOffset);
        }

        public ZippedIterator<BlockPos.MutableBlockPos> boundedGrid(BoundingBox chunkBounds, int yLevel) {
            return new ZippedIterator<BlockPos.MutableBlockPos>(RectangleLatticeIterator.boundedGrid(chunkBounds, yLevel, this.xSpacing, this.zSpacing, 0.0f, 0.0f), RectangleLatticeIterator.boundedGrid(chunkBounds, yLevel, this.xSpacing, this.zSpacing, this.xOffset, this.zOffset));
        }
    }
}

