/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import org.codehaus.plexus.util.StringUtils;
import twilightforest.block.KeepsakeCasketBlock;
import twilightforest.init.TFDataComponents;

public class TFItemStackUtils {
    public static boolean consumeInventoryItem(Player player, ItemLike item, CompoundTag persistentTag, boolean saveItemToTag) {
        return TFItemStackUtils.consumeInventoryItem((NonNullList<ItemStack>)player.getInventory().armor, item, persistentTag, saveItemToTag, (HolderLookup.Provider)player.registryAccess()) || TFItemStackUtils.consumeInventoryItem((NonNullList<ItemStack>)player.getInventory().items, item, persistentTag, saveItemToTag, (HolderLookup.Provider)player.registryAccess()) || TFItemStackUtils.consumeInventoryItem((NonNullList<ItemStack>)player.getInventory().offhand, item, persistentTag, saveItemToTag, (HolderLookup.Provider)player.registryAccess());
    }

    public static boolean consumeInventoryItem(NonNullList<ItemStack> stacks, ItemLike item, CompoundTag persistentTag, boolean saveItemToTag, HolderLookup.Provider provider) {
        for (ItemStack stack : stacks) {
            BlockItemStateProperties blockItemStateProperties;
            if (!stack.is(item.asItem())) continue;
            if (saveItemToTag) {
                persistentTag.put("CharmStack", stack.save(provider));
            }
            if ((blockItemStateProperties = (BlockItemStateProperties)stack.get(DataComponents.BLOCK_STATE)) != null && blockItemStateProperties.properties().containsKey(KeepsakeCasketBlock.BREAKAGE.getName())) {
                String propertyValueString = (String)blockItemStateProperties.properties().get(KeepsakeCasketBlock.BREAKAGE.getName());
                persistentTag.putInt("CasketDamage", StringUtils.isNumeric((String)propertyValueString) ? Integer.parseInt(propertyValueString) : 0);
            } else if (stack.has(TFDataComponents.CASKET_DAMAGE)) {
                persistentTag.putInt("CasketDamage", ((Integer)stack.getOrDefault(TFDataComponents.CASKET_DAMAGE, (Object)0)).intValue());
            }
            stack.shrink(1);
            return true;
        }
        return false;
    }

    public static NonNullList<ItemStack> sortArmorForCasket(Player player) {
        NonNullList armor = player.getInventory().armor;
        Collections.reverse(armor);
        return armor;
    }

    public static NonNullList<ItemStack> sortInvForCasket(Player player) {
        NonNullList inv = player.getInventory().items;
        NonNullList sorted = NonNullList.create();
        sorted.addAll((Collection)inv.subList(9, 36));
        sorted.addAll((Collection)inv.subList(0, 9));
        return sorted;
    }

    public static NonNullList<ItemStack> splitToSize(ItemStack stack) {
        NonNullList result = NonNullList.create();
        int size = stack.getMaxStackSize();
        while (!stack.isEmpty()) {
            result.add((Object)stack.split(size));
        }
        return result;
    }

    public static boolean hasToolMaterial(ItemStack stack, Tier tier) {
        HoeItem hoe;
        SwordItem sword;
        TieredItem tieredItem;
        Item item = stack.getItem();
        if (item instanceof TieredItem && tier.equals((Object)(tieredItem = (TieredItem)item).getTier())) {
            return true;
        }
        if (item instanceof SwordItem && tier.equals((Object)(sword = (SwordItem)item).getTier())) {
            return true;
        }
        return item instanceof HoeItem && tier.equals((Object)(hoe = (HoeItem)item).getTier());
    }

    public static boolean hasInfoTag(ItemStack stack, String key) {
        CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        return customData != null && customData.contains(key);
    }

    public static void addInfoTag(ItemStack stack, String key) {
        CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        CompoundTag nbt = customData == null ? new CompoundTag() : customData.copyTag();
        nbt.putBoolean(key, true);
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)nbt));
    }

    public static void clearInfoTag(ItemStack stack, String key) {
        CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (customData != null) {
            CompoundTag nbt = customData.copyTag();
            nbt.remove(key);
            stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)nbt));
        }
    }

    public static void loadNoClear(RegistryAccess registryAccess, ListTag tag, Inventory inventory) {
        ArrayList<ItemStack> blockedItems = new ArrayList<ItemStack>();
        for (int i = 0; i < tag.size(); ++i) {
            CompoundTag compoundtag = tag.getCompound(i);
            int j = compoundtag.getByte("Slot") & 0xFF;
            ItemStack itemstack = ItemStack.parseOptional((HolderLookup.Provider)registryAccess, (CompoundTag)compoundtag);
            if (itemstack.isEmpty()) continue;
            if (j < inventory.items.size()) {
                if (((ItemStack)inventory.items.get(j)).isEmpty()) {
                    inventory.items.set(j, (Object)itemstack);
                    continue;
                }
                blockedItems.add(itemstack);
                continue;
            }
            if (j >= 100 && j < inventory.armor.size() + 100) {
                if (((ItemStack)inventory.armor.get(j - 100)).isEmpty()) {
                    inventory.armor.set(j - 100, (Object)itemstack);
                    continue;
                }
                blockedItems.add(itemstack);
                continue;
            }
            if (j < 150 || j >= inventory.offhand.size() + 150) continue;
            if (((ItemStack)inventory.offhand.get(j - 150)).isEmpty()) {
                inventory.offhand.set(j - 150, (Object)itemstack);
                continue;
            }
            blockedItems.add(itemstack);
        }
        if (!blockedItems.isEmpty()) {
            blockedItems.forEach(arg_0 -> ((Inventory)inventory).add(arg_0));
        }
    }

    public static void hurtButDontBreak(ItemStack stack, int amount, ServerLevel level, @Nullable LivingEntity entity) {
        if (stack.isDamageableItem()) {
            amount = stack.getItem().damageItem(stack, amount, entity, item -> {});
            if (entity == null || !entity.hasInfiniteMaterials()) {
                if (amount > 0 && (amount = EnchantmentHelper.processDurabilityChange((ServerLevel)level, (ItemStack)stack, (int)amount)) <= 0) {
                    return;
                }
                if (entity instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)entity;
                    if (amount != 0) {
                        CriteriaTriggers.ITEM_DURABILITY_CHANGED.trigger(sp, stack, stack.getDamageValue() + amount);
                    }
                }
                int i = stack.getDamageValue() + amount;
                stack.setDamageValue(i);
            }
        }
    }
}

