/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import twilightforest.components.item.OreScannerComponent;
import twilightforest.components.item.OreScannerData;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.init.TFDataComponents;
import twilightforest.init.TFSounds;

public class OreMeterItem
extends Item {
    public static final int MAX_CHUNK_SEARCH_RANGE = 2;
    public static final int LOAD_TIME = 50;

    public OreMeterItem(Item.Properties properties) {
        super(properties);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean held) {
        if (level.isClientSide() || !stack.has(TFDataComponents.ORE_SCANNING)) {
            return;
        }
        OreScannerComponent newScan = ((OreScannerComponent)stack.get(TFDataComponents.ORE_SCANNING)).tickScan((BlockGetter)level);
        if (newScan.isEmpty()) {
            stack.remove(TFDataComponents.ORE_SCANNING);
            return;
        }
        if (!newScan.isFinished()) {
            stack.set(TFDataComponents.ORE_LOADING, (Object)newScan.getTickProgress());
            stack.set(TFDataComponents.ORE_SCANNING, (Object)newScan);
            return;
        }
        stack.set(TFDataComponents.ORE_DATA, (Object)OreScannerData.create(newScan.getResults((Block)stack.get(TFDataComponents.ORE_FILTER)), newScan.centerChunkPos(), newScan.getVolume((BlockGetter)level), OreMeterItem.getRange(stack)));
        stack.remove(TFDataComponents.ORE_LOADING);
        stack.remove(TFDataComponents.ORE_SCANNING);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.getClass() != ServerPlayer.class) {
            return InteractionResultHolder.fail((Object)stack);
        }
        if (OreMeterItem.isLoading(stack)) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (!player.isSecondaryUseActive()) {
            return OreMeterItem.beginScanning(level, player, stack);
        }
        return OreMeterItem.toggleRange(level, player, stack);
    }

    @NotNull
    private static InteractionResultHolder<ItemStack> beginScanning(Level level, Player player, ItemStack stack) {
        if (!level.isClientSide) {
            int range = OreMeterItem.getRange(stack);
            int scanTime = 50 + range * 25;
            OreScannerComponent data = OreScannerComponent.scanFromCenter(player.blockPosition(), range, scanTime);
            stack.set(TFDataComponents.ORE_SCANNING, (Object)data);
        }
        level.playSound(player, player.blockPosition(), (SoundEvent)TFSounds.ORE_METER_CRACKLE.get(), SoundSource.PLAYERS, 0.5f, level.getRandom().nextFloat() * 0.1f + 0.9f);
        return InteractionResultHolder.pass((Object)stack);
    }

    @NotNull
    private static InteractionResultHolder<ItemStack> toggleRange(Level level, Player player, ItemStack stack) {
        BlockHitResult result = OreMeterItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (result.getType() == HitResult.Type.MISS) {
            if (!level.isClientSide) {
                int newRange = Mth.positiveModulo((int)(OreMeterItem.getRange(stack) + 1), (int)3);
                stack.set(TFDataComponents.ORE_RANGE, (Object)newRange);
                player.displayClientMessage((Component)Component.translatable((String)"misc.twilightforest.ore_meter_new_range", (Object[])new Object[]{newRange}), true);
                level.playSound(null, player.blockPosition(), (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.PLAYERS, 0.25f, 0.75f + (float)newRange * 0.1f);
            }
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockState state;
        ItemStack stack = context.getItemInHand();
        if (context.isSecondaryUseActive() && (state = context.getLevel().getBlockState(context.getClickedPos())).is(BlockTagGenerator.ORE_METER_TARGETABLE)) {
            stack.set(TFDataComponents.ORE_FILTER, (Object)state.getBlock());
            context.getPlayer().displayClientMessage((Component)Component.translatable((String)"misc.twilightforest.ore_meter_set_block", (Object[])new Object[]{Component.translatable((String)state.getBlock().getDescriptionId())}), true);
            context.getLevel().playSound(context.getPlayer(), context.getPlayer().blockPosition(), (SoundEvent)TFSounds.ORE_METER_TARGET_BLOCK.get(), SoundSource.PLAYERS, 0.5f, context.getLevel().getRandom().nextFloat() * 0.1f + 0.9f);
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || newStack.getItem() != oldStack.getItem();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        Block block = (Block)stack.get(TFDataComponents.ORE_FILTER);
        if (block != null) {
            tooltip.add((Component)Component.translatable((String)"misc.twilightforest.ore_meter_targeted_block", (Object[])new Object[]{block.getDescriptionId()}).withStyle(ChatFormatting.GRAY));
        }
        super.appendHoverText(stack, context, tooltip, flag);
    }

    public static boolean isLoading(ItemStack stack) {
        return stack.has(TFDataComponents.ORE_LOADING);
    }

    public static int getLoadProgress(ItemStack stack) {
        return (Integer)stack.getOrDefault(TFDataComponents.ORE_LOADING, (Object)0);
    }

    @NotNull
    public static Integer getRange(ItemStack stack) {
        return (Integer)stack.getOrDefault(TFDataComponents.ORE_RANGE, (Object)1);
    }
}

