/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import twilightforest.entity.projectile.CubeOfAnnihilation;
import twilightforest.init.TFDataComponents;
import twilightforest.init.TFEntities;

public class CubeOfAnnihilationItem
extends Item {
    public CubeOfAnnihilationItem(Item.Properties properties) {
        super(properties);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity holder, int slot, boolean isSelected) {
        if (!level.isClientSide() && stack.get(TFDataComponents.THROWN_PROJECTILE) != null && CubeOfAnnihilationItem.getThrownEntity(level, stack) == null) {
            stack.remove(TFDataComponents.THROWN_PROJECTILE);
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.get(TFDataComponents.THROWN_PROJECTILE) != null) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        if (!level.isClientSide()) {
            CubeOfAnnihilation launchedCube = new CubeOfAnnihilation((EntityType<? extends CubeOfAnnihilation>)((EntityType)TFEntities.CUBE_OF_ANNIHILATION.get()), level, (LivingEntity)player, stack);
            level.addFreshEntity((Entity)launchedCube);
            stack.set(TFDataComponents.THROWN_PROJECTILE, (Object)launchedCube.getUUID());
        }
        player.startUsingItem(hand);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    @Nullable
    private static CubeOfAnnihilation getThrownEntity(Level level, ItemStack stack) {
        if (level instanceof ServerLevel) {
            Entity e;
            ServerLevel server = (ServerLevel)level;
            UUID id = (UUID)stack.get(TFDataComponents.THROWN_PROJECTILE);
            if (id != null && (e = server.getEntity(id)) instanceof CubeOfAnnihilation) {
                return (CubeOfAnnihilation)e;
            }
        }
        return null;
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 72000;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return true;
    }
}

