/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.inventory;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlaceGhostRecipePacket;
import net.minecraft.recipebook.ServerPlaceRecipe;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import org.jetbrains.annotations.Nullable;
import twilightforest.inventory.UncraftingPlaceRecipe;

public class UncrafterPlaceRecipe<I extends RecipeInput, R extends Recipe<I>>
extends ServerPlaceRecipe<I, R>
implements UncraftingPlaceRecipe<Integer> {
    private static final int matrixOffset = 11;

    public UncrafterPlaceRecipe(RecipeBookMenu<I, R> menu) {
        super(menu);
    }

    public void recipeClicked(ServerPlayer player, @Nullable RecipeHolder<R> recipe, boolean placeAll) {
        if (recipe != null && player.getRecipeBook().contains(recipe)) {
            this.inventory = player.getInventory();
            if (this.tryClearGrid() || player.isCreative()) {
                this.stackedContents.clear();
                player.getInventory().fillStackedContents(this.stackedContents);
                this.menu.fillCraftSlotsStackedContents(this.stackedContents);
                if (this.stackedContents.canCraft(recipe.value(), null)) {
                    this.handleRecipeClicked(recipe, placeAll);
                } else {
                    this.clearGrid();
                    player.connection.send((Packet)new ClientboundPlaceGhostRecipePacket(player.containerMenu.containerId, recipe));
                }
                player.getInventory().setChanged();
            }
        }
    }

    protected void handleRecipeClicked(RecipeHolder<R> recipeHolder, boolean placeAll) {
        boolean flag = this.menu.recipeMatches(recipeHolder);
        int i = this.stackedContents.getBiggestCraftableStack(recipeHolder, null);
        if (flag) {
            for (int slot = 0; slot < this.menu.getSize(); ++slot) {
                ItemStack itemstack;
                if (slot == this.menu.getResultSlotIndex() || (itemstack = this.menu.getSlot(slot).getItem()).isEmpty() || Math.min(i, itemstack.getMaxStackSize()) >= itemstack.getCount() + 1) continue;
                return;
            }
        }
        int j1 = this.getStackSize(placeAll, i, flag);
        IntArrayList intlist = new IntArrayList();
        if (this.stackedContents.canCraft(recipeHolder.value(), (IntList)intlist, j1)) {
            int k = j1;
            IntListIterator intListIterator = intlist.iterator();
            while (intListIterator.hasNext()) {
                int l = (Integer)intListIterator.next();
                int i1 = StackedContents.fromStackingIndex((int)l).getMaxStackSize();
                if (i1 >= k) continue;
                k = i1;
            }
            if (this.stackedContents.canCraft(recipeHolder.value(), (IntList)intlist, k)) {
                this.clearGrid();
                this.placeRecipe(this.menu.getGridWidth(), this.menu.getGridHeight(), this.menu.getResultSlotIndex(), recipeHolder, (Iterator)intlist.iterator(), k);
            }
        }
    }

    protected int getStackSize(boolean placeAll, int maxPossible, boolean recipeMatches) {
        int i = 1;
        if (placeAll) {
            i = maxPossible;
        } else if (recipeMatches) {
            i = 64;
            for (int j = 0; j < this.menu.getGridWidth() * this.menu.getGridHeight(); ++j) {
                ItemStack itemStack = this.menu.getSlot(j + 11).getItem();
                if (itemStack.isEmpty() || i <= itemStack.getCount()) continue;
                i = itemStack.getCount();
            }
            if (i < 64) {
                ++i;
            }
        }
        return i;
    }

    private int getAmountOfFreeSlotsInInventory() {
        int i = 0;
        for (ItemStack itemstack : this.inventory.items) {
            if (!itemstack.isEmpty()) continue;
            ++i;
        }
        return i;
    }

    private boolean tryClearGrid() {
        ItemStack itemstack;
        ArrayList list = Lists.newArrayList();
        int i = this.getAmountOfFreeSlotsInInventory();
        if (i > 0 && !(itemstack = this.menu.getSlot(0).getItem().copy()).isEmpty()) {
            list.add(itemstack);
        }
        for (int slotIndex = 0; slotIndex < this.menu.getGridWidth() * this.menu.getGridHeight(); ++slotIndex) {
            ItemStack itemstack2 = this.menu.getSlot(slotIndex + 11).getItem().copy();
            if (itemstack2.isEmpty()) continue;
            int k = this.inventory.getSlotWithRemainingSpace(itemstack2);
            if (k == -1 && list.size() <= i) {
                for (ItemStack itemstack1 : list) {
                    if (!ItemStack.isSameItem((ItemStack)itemstack1, (ItemStack)itemstack2) || itemstack1.getCount() == itemstack1.getMaxStackSize() || itemstack1.getCount() + itemstack2.getCount() > itemstack1.getMaxStackSize()) continue;
                    itemstack1.grow(itemstack2.getCount());
                    itemstack2.setCount(0);
                    break;
                }
                if (itemstack2.isEmpty()) continue;
                if (list.size() >= i) {
                    return false;
                }
                list.add(itemstack2);
                continue;
            }
            if (k != -1) continue;
            return false;
        }
        return true;
    }
}

