/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.dispenser;

import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import twilightforest.block.AbstractSkullCandleBlock;
import twilightforest.block.TrophyBlock;
import twilightforest.dispenser.CandleDispenseBehavior;
import twilightforest.dispenser.CrumbleDispenseBehavior;
import twilightforest.dispenser.DamageableStackDispenseBehavior;
import twilightforest.dispenser.FeatherFanDispenseBehavior;
import twilightforest.dispenser.TransformationDispenseBehavior;
import twilightforest.entity.projectile.MoonwormShot;
import twilightforest.entity.projectile.TwilightWandBolt;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFItems;
import twilightforest.init.TFSounds;

public class TFDispenserBehaviors {
    public static void init() {
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)TFItems.MOONWORM_QUEEN.get()), (DispenseItemBehavior)new DamageableStackDispenseBehavior(){

            @Override
            protected Projectile getProjectileEntity(Level level, Position position, ItemStack stack) {
                return new MoonwormShot(level, position.x(), position.y(), position.z());
            }

            @Override
            protected int getDamageAmount() {
                return 2;
            }

            @Override
            protected SoundEvent getFiredSound() {
                return (SoundEvent)TFSounds.MOONWORM_SQUISH.get();
            }
        });
        OptionalDispenseItemBehavior idispenseitembehavior = new OptionalDispenseItemBehavior(){

            protected ItemStack execute(BlockSource source, ItemStack stack) {
                this.setSuccess(ArmorItem.dispenseArmor((BlockSource)source, (ItemStack)stack));
                return stack;
            }
        };
        DispenserBlock.registerBehavior((ItemLike)((TrophyBlock)((Object)TFBlocks.NAGA_TROPHY.get())).asItem(), (DispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.registerBehavior((ItemLike)((TrophyBlock)((Object)TFBlocks.LICH_TROPHY.get())).asItem(), (DispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.registerBehavior((ItemLike)((TrophyBlock)((Object)TFBlocks.MINOSHROOM_TROPHY.get())).asItem(), (DispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.registerBehavior((ItemLike)((TrophyBlock)((Object)TFBlocks.HYDRA_TROPHY.get())).asItem(), (DispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.registerBehavior((ItemLike)((TrophyBlock)((Object)TFBlocks.KNIGHT_PHANTOM_TROPHY.get())).asItem(), (DispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.registerBehavior((ItemLike)((TrophyBlock)((Object)TFBlocks.UR_GHAST_TROPHY.get())).asItem(), (DispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.registerBehavior((ItemLike)((TrophyBlock)((Object)TFBlocks.ALPHA_YETI_TROPHY.get())).asItem(), (DispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.registerBehavior((ItemLike)((TrophyBlock)((Object)TFBlocks.SNOW_QUEEN_TROPHY.get())).asItem(), (DispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.registerBehavior((ItemLike)((TrophyBlock)((Object)TFBlocks.QUEST_RAM_TROPHY.get())).asItem(), (DispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.registerBehavior((ItemLike)((AbstractSkullCandleBlock)TFBlocks.CREEPER_SKULL_CANDLE.get()).asItem(), (DispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.registerBehavior((ItemLike)((AbstractSkullCandleBlock)TFBlocks.PLAYER_SKULL_CANDLE.get()).asItem(), (DispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.registerBehavior((ItemLike)((AbstractSkullCandleBlock)TFBlocks.SKELETON_SKULL_CANDLE.get()).asItem(), (DispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.registerBehavior((ItemLike)((AbstractSkullCandleBlock)TFBlocks.WITHER_SKELE_SKULL_CANDLE.get()).asItem(), (DispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.registerBehavior((ItemLike)((AbstractSkullCandleBlock)TFBlocks.ZOMBIE_SKULL_CANDLE.get()).asItem(), (DispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.registerBehavior((ItemLike)((Block)TFBlocks.CICADA.get()).asItem(), (DispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.registerBehavior((ItemLike)((Block)TFBlocks.FIREFLY.get()).asItem(), (DispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.registerBehavior((ItemLike)((Block)TFBlocks.MOONWORM.get()).asItem(), (DispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.registerBehavior((ItemLike)((Item)TFItems.PEACOCK_FEATHER_FAN.get()).asItem(), (DispenseItemBehavior)new FeatherFanDispenseBehavior());
        DispenserBlock.registerBehavior((ItemLike)((Item)TFItems.CRUMBLE_HORN.get()).asItem(), (DispenseItemBehavior)new CrumbleDispenseBehavior());
        DispenserBlock.registerBehavior((ItemLike)((Item)TFItems.TRANSFORMATION_POWDER.get()).asItem(), (DispenseItemBehavior)new TransformationDispenseBehavior());
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)TFItems.TWILIGHT_SCEPTER.get()), (DispenseItemBehavior)new DamageableStackDispenseBehavior(){

            @Override
            protected Projectile getProjectileEntity(Level level, Position position, ItemStack stack) {
                return new TwilightWandBolt(level, position.x(), position.y(), position.z());
            }

            @Override
            protected int getDamageAmount() {
                return 1;
            }

            @Override
            protected SoundEvent getFiredSound() {
                return (SoundEvent)TFSounds.TWILIGHT_SCEPTER_USE.get();
            }

            @Override
            protected float getProjectileInaccuracy() {
                return 6.0f;
            }
        });
        DispenserBlock.registerProjectileBehavior((ItemLike)((ItemLike)TFItems.ICE_BOMB.get()));
        DispenserBlock.registerBehavior((ItemLike)Items.CANDLE, (DispenseItemBehavior)new CandleDispenseBehavior());
        DispenserBlock.registerBehavior((ItemLike)Items.BLACK_CANDLE, (DispenseItemBehavior)new CandleDispenseBehavior());
        DispenserBlock.registerBehavior((ItemLike)Items.GRAY_CANDLE, (DispenseItemBehavior)new CandleDispenseBehavior());
        DispenserBlock.registerBehavior((ItemLike)Items.LIGHT_GRAY_CANDLE, (DispenseItemBehavior)new CandleDispenseBehavior());
        DispenserBlock.registerBehavior((ItemLike)Items.WHITE_CANDLE, (DispenseItemBehavior)new CandleDispenseBehavior());
        DispenserBlock.registerBehavior((ItemLike)Items.RED_CANDLE, (DispenseItemBehavior)new CandleDispenseBehavior());
        DispenserBlock.registerBehavior((ItemLike)Items.ORANGE_CANDLE, (DispenseItemBehavior)new CandleDispenseBehavior());
        DispenserBlock.registerBehavior((ItemLike)Items.YELLOW_CANDLE, (DispenseItemBehavior)new CandleDispenseBehavior());
        DispenserBlock.registerBehavior((ItemLike)Items.GREEN_CANDLE, (DispenseItemBehavior)new CandleDispenseBehavior());
        DispenserBlock.registerBehavior((ItemLike)Items.LIME_CANDLE, (DispenseItemBehavior)new CandleDispenseBehavior());
        DispenserBlock.registerBehavior((ItemLike)Items.BLUE_CANDLE, (DispenseItemBehavior)new CandleDispenseBehavior());
        DispenserBlock.registerBehavior((ItemLike)Items.CYAN_CANDLE, (DispenseItemBehavior)new CandleDispenseBehavior());
        DispenserBlock.registerBehavior((ItemLike)Items.LIGHT_BLUE_CANDLE, (DispenseItemBehavior)new CandleDispenseBehavior());
        DispenserBlock.registerBehavior((ItemLike)Items.PURPLE_CANDLE, (DispenseItemBehavior)new CandleDispenseBehavior());
        DispenserBlock.registerBehavior((ItemLike)Items.MAGENTA_CANDLE, (DispenseItemBehavior)new CandleDispenseBehavior());
        DispenserBlock.registerBehavior((ItemLike)Items.PINK_CANDLE, (DispenseItemBehavior)new CandleDispenseBehavior());
        DispenserBlock.registerBehavior((ItemLike)Items.BROWN_CANDLE, (DispenseItemBehavior)new CandleDispenseBehavior());
    }
}

