/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.config;

import java.util.List;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.tuple.Pair;
import twilightforest.config.TFClientConfig;
import twilightforest.config.TFCommonConfig;
import twilightforest.config.TFConfig;
import twilightforest.network.SyncUncraftingTableConfigPacket;

public final class ConfigSetup {
    private static final ModConfigSpec CLIENT_SPEC;
    private static final ModConfigSpec COMMON_SPEC;
    static final TFClientConfig CLIENT_CONFIG;
    static final TFCommonConfig COMMON_CONFIG;

    public static void loadConfigs(ModConfigEvent.Loading event) {
        if (event.getConfig().getSpec() == CLIENT_SPEC) {
            TFConfig.rebakeClientOptions(CLIENT_CONFIG);
        } else if (event.getConfig().getSpec() == COMMON_SPEC) {
            TFConfig.rebakeCommonOptions(COMMON_CONFIG);
        }
    }

    public static void reloadConfigs(ModConfigEvent.Reloading event) {
        if (event.getConfig().getSpec() == CLIENT_SPEC) {
            TFConfig.rebakeClientOptions(CLIENT_CONFIG);
        } else if (event.getConfig().getSpec() == COMMON_SPEC) {
            TFConfig.rebakeCommonOptions(COMMON_CONFIG);
        }
    }

    public static void syncUncraftingConfig(PlayerEvent.PlayerLoggedInEvent event) {
        Player player;
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null && server.isDedicatedServer() && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SyncUncraftingTableConfigPacket((Double)ConfigSetup.COMMON_CONFIG.UNCRAFTING_STUFFS.uncraftingXpCostMultiplier.get(), (Double)ConfigSetup.COMMON_CONFIG.UNCRAFTING_STUFFS.repairingXpCostMultiplier.get(), (Boolean)ConfigSetup.COMMON_CONFIG.UNCRAFTING_STUFFS.allowShapelessUncrafting.get(), (Boolean)ConfigSetup.COMMON_CONFIG.UNCRAFTING_STUFFS.disableIngredientSwitching.get(), (Boolean)ConfigSetup.COMMON_CONFIG.UNCRAFTING_STUFFS.disableUncraftingOnly.get(), (Boolean)ConfigSetup.COMMON_CONFIG.UNCRAFTING_STUFFS.disableEntireTable.get(), (List)ConfigSetup.COMMON_CONFIG.UNCRAFTING_STUFFS.disableUncraftingRecipes.get(), (Boolean)ConfigSetup.COMMON_CONFIG.UNCRAFTING_STUFFS.reverseRecipeBlacklist.get(), (List)ConfigSetup.COMMON_CONFIG.UNCRAFTING_STUFFS.blacklistedUncraftingModIds.get(), (Boolean)ConfigSetup.COMMON_CONFIG.UNCRAFTING_STUFFS.flipUncraftingModIdList.get()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(TFCommonConfig::new);
        COMMON_SPEC = (ModConfigSpec)specPair.getRight();
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON_SPEC);
        COMMON_CONFIG = (TFCommonConfig)specPair.getLeft();
        specPair = new ModConfigSpec.Builder().configure(TFClientConfig::new);
        CLIENT_SPEC = (ModConfigSpec)specPair.getRight();
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_SPEC);
        CLIENT_CONFIG = (TFClientConfig)specPair.getLeft();
    }
}

