/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import twilightforest.client.renderer.entity.TFBipedRenderer;
import twilightforest.entity.monster.UpperGoblinKnight;

public class UpperGoblinKnightRenderer<T extends UpperGoblinKnight, M extends HumanoidModel<T>>
extends TFBipedRenderer<T, M> {
    public UpperGoblinKnightRenderer(EntityRendererProvider.Context context, M model, float shadowSize) {
        super(context, model, shadowSize, "doublegoblin.png");
    }

    protected void setupRotations(T entity, PoseStack stack, float ageInTicks, float rotationYaw, float partialTicks, float scale) {
        super.setupRotations(entity, stack, ageInTicks, rotationYaw, partialTicks, scale);
        if (((UpperGoblinKnight)((Object)entity)).heavySpearTimer > 0) {
            stack.mulPose(Axis.XP.rotationDegrees(this.getPitchForAttack(60.0f - (float)((UpperGoblinKnight)((Object)entity)).heavySpearTimer + partialTicks)));
        }
    }

    private float getPitchForAttack(float attackTime) {
        if (attackTime <= 10.0f) {
            return attackTime * 3.0f;
        }
        if (attackTime > 10.0f && attackTime <= 30.0f) {
            return 30.0f;
        }
        if (attackTime > 30.0f && attackTime <= 33.0f) {
            return (attackTime - 30.0f) * -25.0f + 30.0f;
        }
        if (attackTime > 33.0f && attackTime <= 50.0f) {
            return -45.0f;
        }
        if (attackTime > 50.0f && attackTime <= 60.0f) {
            return (10.0f - (attackTime - 50.0f)) * -4.5f;
        }
        return 0.0f;
    }
}

