/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import twilightforest.TwilightForestMod;
import twilightforest.client.renderer.entity.HydraHeadRenderer;
import twilightforest.client.renderer.entity.TFPartRenderer;
import twilightforest.entity.boss.HydraHeadContainer;
import twilightforest.entity.boss.HydraNeck;
import twilightforest.entity.boss.HydraPart;

public class HydraNeckRenderer<T extends HydraNeck, M extends ListModel<T>>
extends TFPartRenderer<T, M> {
    private static final ResourceLocation TEXTURE = TwilightForestMod.getModelTexture("hydra4.png");

    public HydraNeckRenderer(EntityRendererProvider.Context context, M model) {
        super(context, model);
    }

    @Override
    public void render(T entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int light) {
        HydraHeadContainer headCon = HydraHeadRenderer.getHeadObject(((HydraNeck)((Object)entity)).head);
        if (headCon != null && ((HydraPart)((Object)entity)).isActive()) {
            float yawDiff = entity.getYRot() - ((HydraNeck)((Object)entity)).yRotO;
            if (yawDiff > 180.0f) {
                yawDiff -= 360.0f;
            } else if (yawDiff < -180.0f) {
                yawDiff += 360.0f;
            }
            float yaw2 = ((HydraNeck)((Object)entity)).yRotO + yawDiff * partialTicks;
            stack.mulPose(Axis.YN.rotationDegrees(yaw2 + 180.0f));
            super.render(entity, entityYaw, partialTicks, stack, buffer, light);
        }
    }

    @Override
    protected float getFlipDegrees(T entity) {
        return 0.0f;
    }

    public ResourceLocation getTextureLocation(T entity) {
        return TEXTURE;
    }
}

