/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.event;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.apache.commons.lang3.tuple.Pair;
import twilightforest.block.CloudBlock;
import twilightforest.client.renderer.TFWeatherRenderer;
import twilightforest.config.TFConfig;
import twilightforest.util.Vec2i;

public class CloudEvents {
    private static final List<PrecipitationRenderHelper> RENDER_HELPER = new ArrayList<PrecipitationRenderHelper>();

    protected static void tickWeatherEffects(ClientTickEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        if (!mc.isPaused() && mc.level != null && TFConfig.getClientCloudBlockPrecipitationDistance() > 0) {
            Vec3 vec3 = mc.gameRenderer.getMainCamera().getPosition();
            if (mc.level.getGameTime() % 10L == 0L) {
                RENDER_HELPER.clear();
                double camX = vec3.x();
                double camY = vec3.y();
                double camZ = vec3.z();
                int floorX = Mth.floor((double)camX);
                int floorY = Mth.floor((double)camY);
                int floorZ = Mth.floor((double)camZ);
                int renderDistance = Minecraft.useFancyGraphics() ? 10 : 5;
                int precipitationDistance = TFConfig.getClientCloudBlockPrecipitationDistance();
                BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
                for (int roofZ = floorZ - renderDistance; roofZ <= floorZ + renderDistance; ++roofZ) {
                    for (int roofX = floorX - renderDistance; roofX <= floorX + renderDistance; ++roofX) {
                        int lastBadYLevel = Integer.MIN_VALUE;
                        for (int roofY = floorY - renderDistance; roofY < floorY + precipitationDistance + renderDistance; ++roofY) {
                            CloudBlock cloudBlock;
                            Pair<Biome.Precipitation, Float> precipitationRainLevelPair;
                            Block block;
                            boolean skipLoop = roofY == lastBadYLevel + 1;
                            pos.set(roofX, roofY, roofZ);
                            if (Heightmap.Types.MOTION_BLOCKING.isOpaque().test(mc.level.getBlockState((BlockPos)pos))) {
                                lastBadYLevel = roofY;
                            }
                            if (skipLoop || !((block = mc.level.getBlockState((BlockPos)pos).getBlock()) instanceof CloudBlock) || (precipitationRainLevelPair = (cloudBlock = (CloudBlock)block).getCurrentPrecipitation((BlockPos)pos, (Level)mc.level, mc.level.getRainLevel(1.0f))).getLeft() == Biome.Precipitation.NONE) continue;
                            int highestRainyBlock = roofY;
                            int y = roofY - 1;
                            while (y > roofY - precipitationDistance && !Heightmap.Types.MOTION_BLOCKING.isOpaque().test(mc.level.getBlockState(pos.atY(y)))) {
                                highestRainyBlock = y--;
                            }
                            if (highestRainyBlock == roofY) continue;
                            RENDER_HELPER.add(new PrecipitationRenderHelper(pos.immutable(), (Biome.Precipitation)precipitationRainLevelPair.getLeft(), ((Float)precipitationRainLevelPair.getRight()).floatValue(), highestRainyBlock));
                        }
                    }
                }
            }
            if (!RENDER_HELPER.isEmpty()) {
                RandomSource randomsource = RandomSource.create((long)((long)mc.levelRenderer.getTicks() * 312987231L));
                BlockPos particlePos = null;
                int particleCount = 100 / (mc.options.particles().get() == ParticleStatus.DECREASED ? 2 : 1);
                boolean yetToMakeASound = true;
                BlockPos camPos = BlockPos.containing((Position)vec3);
                ArrayList<Vec2i> particleChecks = new ArrayList<Vec2i>();
                for (int i = 0; i < particleCount; ++i) {
                    particleChecks.add(new Vec2i(randomsource.nextInt(21) - 10 + camPos.getX(), randomsource.nextInt(21) - 10 + camPos.getZ()));
                }
                block5: for (PrecipitationRenderHelper helper : RENDER_HELPER) {
                    if (helper.precipitation() != Biome.Precipitation.RAIN) continue;
                    for (Vec2i vec2 : particleChecks) {
                        if (vec2.x != helper.cloudPos().getX() || vec2.z != helper.cloudPos().getZ()) continue;
                        BlockPos highestRainyPos = helper.cloudPos().atY(helper.rainOnY());
                        if (!Heightmap.Types.MOTION_BLOCKING.isOpaque().test(mc.level.getBlockState(highestRainyPos.below()))) continue;
                        if (yetToMakeASound && particlePos != null && randomsource.nextInt(3) < mc.levelRenderer.rainSoundTime++) {
                            mc.levelRenderer.rainSoundTime = 0;
                            if (particlePos.getY() > camPos.getY() + 1 && mc.level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, camPos).getY() > Mth.floor((float)camPos.getY())) {
                                mc.level.playLocalSound(particlePos, SoundEvents.WEATHER_RAIN_ABOVE, SoundSource.WEATHER, 0.1f, 0.5f, false);
                            } else {
                                mc.level.playLocalSound(particlePos, SoundEvents.WEATHER_RAIN, SoundSource.WEATHER, 0.2f, 1.0f, false);
                            }
                            yetToMakeASound = false;
                        }
                        if (highestRainyPos.getY() <= mc.level.getMinBuildHeight() || highestRainyPos.getY() > camPos.getY() + 10 || highestRainyPos.getY() < camPos.getY() - 10) continue;
                        particlePos = highestRainyPos.below();
                        if (mc.options.particles().get() == ParticleStatus.MINIMAL) continue block5;
                        double particleX = randomsource.nextDouble();
                        double particleZ = randomsource.nextDouble();
                        BlockState blockstate = mc.level.getBlockState(particlePos);
                        FluidState fluidstate = mc.level.getFluidState(particlePos);
                        VoxelShape voxelshape = blockstate.getCollisionShape((BlockGetter)mc.level, particlePos);
                        double voxelMax = voxelshape.max(Direction.Axis.Y, particleX, particleZ);
                        double fluidMax = fluidstate.getHeight((BlockGetter)mc.level, particlePos);
                        double particleY = Math.max(voxelMax, fluidMax);
                        SimpleParticleType particleoptions = !fluidstate.is(FluidTags.LAVA) && !blockstate.is(Blocks.MAGMA_BLOCK) && !CampfireBlock.isLitCampfire((BlockState)blockstate) ? ParticleTypes.RAIN : ParticleTypes.SMOKE;
                        mc.level.addParticle((ParticleOptions)particleoptions, (double)particlePos.getX() + particleX, (double)particlePos.getY() + particleY, (double)particlePos.getZ() + particleZ, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
    }

    protected static void renderPrecipitation(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_WEATHER && TFConfig.getClientCloudBlockPrecipitationDistance() > 0 && !RENDER_HELPER.isEmpty()) {
            Minecraft minecraft = Minecraft.getInstance();
            if (minecraft.level == null) {
                return;
            }
            float partialTick = minecraft.getTimer().getGameTimeDeltaPartialTick(false);
            LightTexture lightTexture = minecraft.gameRenderer.lightTexture();
            int ticks = minecraft.levelRenderer.getTicks();
            lightTexture.turnOnLightLayer();
            Vec3 vec3 = event.getCamera().getPosition();
            double camX = vec3.x();
            double camY = vec3.y();
            double camZ = vec3.z();
            int floorX = Mth.floor((double)camX);
            int floorY = Mth.floor((double)camY);
            int floorZ = Mth.floor((double)camZ);
            Tesselator tesselator = Tesselator.getInstance();
            BufferBuilder bufferbuilder = null;
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)Minecraft.useShaderTransparency());
            int renderDistance = Minecraft.useFancyGraphics() ? 10 : 5;
            int tesselatorCheck = -1;
            float fullTick = (float)ticks + partialTick;
            RenderSystem.setShader(GameRenderer::getParticleShader);
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            for (PrecipitationRenderHelper helper : RENDER_HELPER) {
                BlockPos pos = helper.cloudPos();
                int roofX = pos.getX();
                int roofZ = pos.getZ();
                int botY = Math.max(helper.rainOnY(), floorY - renderDistance);
                int topY = Math.min(pos.getY(), floorY + renderDistance);
                if (topY - botY <= 0) continue;
                int rainS = Mth.clamp((int)((roofZ - floorZ + 16) * 32 + roofX - floorX + 16), (int)0, (int)1023);
                double rainX = (double)TFWeatherRenderer.rainxs[rainS] * 0.5;
                double rainZ = (double)TFWeatherRenderer.rainzs[rainS] * 0.5;
                mutableBlockPos.set((double)roofX, camY, (double)roofZ);
                RandomSource random = RandomSource.create((long)((long)roofX * (long)roofX * 3121L + (long)roofX * 45238971L ^ (long)roofZ * (long)roofZ * 418711L + (long)roofZ * 13761L));
                if (helper.precipitation() == Biome.Precipitation.RAIN) {
                    if (tesselatorCheck != 0) {
                        if (tesselatorCheck >= 0) {
                            BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
                        }
                        tesselatorCheck = 0;
                        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TFWeatherRenderer.RAIN_TEXTURES);
                        bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
                    }
                    int offset = ticks + roofX * roofX * 3121 + roofX * 45238971 + roofZ * roofZ * 418711 + roofZ * 13761 & 0x1F;
                    float uvOffset = -((float)offset + partialTick) / 32.0f * (3.0f + random.nextFloat());
                    double xDiff = (double)roofX + 0.5 - camX;
                    double zDiff = (double)roofZ + 0.5 - camZ;
                    float distance = (float)Math.sqrt(xDiff * xDiff + zDiff * zDiff) / (float)renderDistance;
                    float alpha = ((1.0f - distance * distance) * 0.5f + 0.5f) * helper.precipitationLevel();
                    mutableBlockPos.set(roofX, Math.max(helper.rainOnY(), floorY), roofZ);
                    int lightColor = LevelRenderer.getLightColor((BlockAndTintGetter)minecraft.level, (BlockPos)mutableBlockPos);
                    bufferbuilder.addVertex((float)((double)roofX - camX - rainX + 0.5), (float)((double)topY - camY), (float)((double)roofZ - camZ - rainZ + 0.5)).setUv(0.0f, (float)botY * 0.25f + uvOffset).setColor(1.0f, 1.0f, 1.0f, alpha).setLight(lightColor);
                    bufferbuilder.addVertex((float)((double)roofX - camX + rainX + 0.5), (float)((double)topY - camY), (float)((double)roofZ - camZ + rainZ + 0.5)).setUv(1.0f, (float)botY * 0.25f + uvOffset).setColor(1.0f, 1.0f, 1.0f, alpha).setLight(lightColor);
                    bufferbuilder.addVertex((float)((double)roofX - camX + rainX + 0.5), (float)((double)botY - camY), (float)((double)roofZ - camZ + rainZ + 0.5)).setUv(1.0f, (float)topY * 0.25f + uvOffset).setColor(1.0f, 1.0f, 1.0f, alpha).setLight(lightColor);
                    bufferbuilder.addVertex((float)((double)roofX - camX - rainX + 0.5), (float)((double)botY - camY), (float)((double)roofZ - camZ - rainZ + 0.5)).setUv(0.0f, (float)topY * 0.25f + uvOffset).setColor(1.0f, 1.0f, 1.0f, alpha).setLight(lightColor);
                    continue;
                }
                if (helper.precipitation() != Biome.Precipitation.SNOW) continue;
                if (tesselatorCheck != 1) {
                    if (tesselatorCheck == 0) {
                        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
                    }
                    tesselatorCheck = 1;
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)TFWeatherRenderer.SNOW_TEXTURES);
                    bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
                }
                float offset = -((float)(ticks & 0x1FF) + partialTick) / 512.0f;
                float uOffset = (float)(random.nextDouble() + (double)fullTick * 0.01 * (double)((float)random.nextGaussian()));
                float vOffset = (float)(random.nextDouble() + (double)(fullTick * (float)random.nextGaussian()) * 0.001);
                double xDiff = (double)roofX + 0.5 - camX;
                double zDiff = (double)roofZ + 0.5 - camZ;
                float distance = (float)Math.sqrt(xDiff * xDiff + zDiff * zDiff) / (float)renderDistance;
                float alpha = ((1.0f - distance * distance) * 0.3f + 0.5f) * helper.precipitationLevel();
                mutableBlockPos.set(roofX, Math.max(helper.rainOnY(), floorY), roofZ);
                int lightColor = LevelRenderer.getLightColor((BlockAndTintGetter)minecraft.level, (BlockPos)mutableBlockPos);
                int v = lightColor >> 16 & 0xFFFF;
                int u = lightColor & 0xFFFF;
                v = (v * 3 + 240) / 4;
                u = (u * 3 + 240) / 4;
                bufferbuilder.addVertex((float)((double)roofX - camX - rainX + 0.5), (float)((double)topY - camY), (float)((double)roofZ - camZ - rainZ + 0.5)).setUv(0.0f + uOffset, (float)botY * 0.25f + offset + vOffset).setColor(1.0f, 1.0f, 1.0f, alpha).setUv2(u, v);
                bufferbuilder.addVertex((float)((double)roofX - camX + rainX + 0.5), (float)((double)topY - camY), (float)((double)roofZ - camZ + rainZ + 0.5)).setUv(1.0f + uOffset, (float)botY * 0.25f + offset + vOffset).setColor(1.0f, 1.0f, 1.0f, alpha).setUv2(u, v);
                bufferbuilder.addVertex((float)((double)roofX - camX + rainX + 0.5), (float)((double)botY - camY), (float)((double)roofZ - camZ + rainZ + 0.5)).setUv(1.0f + uOffset, (float)topY * 0.25f + offset + vOffset).setColor(1.0f, 1.0f, 1.0f, alpha).setUv2(u, v);
                bufferbuilder.addVertex((float)((double)roofX - camX - rainX + 0.5), (float)((double)botY - camY), (float)((double)roofZ - camZ - rainZ + 0.5)).setUv(0.0f + uOffset, (float)topY * 0.25f + offset + vOffset).setColor(1.0f, 1.0f, 1.0f, alpha).setUv2(u, v);
            }
            if (tesselatorCheck >= 0) {
                BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
            }
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            lightTexture.turnOffLightLayer();
        }
    }

    record PrecipitationRenderHelper(BlockPos cloudPos, Biome.Precipitation precipitation, float precipitationLevel, int rainOnY) {
    }
}

