/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFItems;
import twilightforest.init.TFSounds;
import twilightforest.init.TFStats;

public class TrollRootBlock
extends Block {
    protected static final VoxelShape AABB = Shapes.create((AABB)new AABB(0.1, 0.0, 0.1, 0.9, 1.0, 0.9));

    public TrollRootBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public static boolean canPlaceRootBelow(LevelReader reader, BlockPos pos) {
        BlockState state = reader.getBlockState(pos);
        return state.is(BlockTags.BASE_STONE_OVERWORLD) || state.is(TFBlocks.TROLLVIDR) || state.is(TFBlocks.TROLLBER) || state.is(TFBlocks.UNRIPE_TROLLBER);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        if (state.is(TFBlocks.TROLLBER)) {
            level.setBlock(pos, ((Block)TFBlocks.TROLLVIDR.get()).defaultBlockState(), 2);
            level.playSound(null, pos, (SoundEvent)TFSounds.PICKED_TORCHBERRIES.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            ItemEntity torchberries = new ItemEntity(level, (double)((float)pos.getX() + 0.5f), (double)pos.getY(), (double)((float)pos.getZ() + 0.5f), new ItemStack((ItemLike)TFItems.TORCHBERRIES.get()));
            level.addFreshEntity((Entity)torchberries);
            if (player instanceof ServerPlayer) {
                player.awardStat((ResourceLocation)TFStats.TORCHBERRIES_HARVESTED.get());
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useWithoutItem(state, level, pos, player, result);
    }

    public boolean canSurvive(BlockState state, LevelReader reader, BlockPos pos) {
        return TrollRootBlock.canPlaceRootBelow(reader, pos.above());
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return AABB;
    }

    public BlockState updateShape(BlockState state, Direction dirToNeighbor, BlockState neighborState, LevelAccessor accessor, BlockPos pos, BlockPos neighborPos) {
        if (dirToNeighbor == Direction.UP) {
            return this.canSurvive(state, (LevelReader)accessor, pos) ? state : Blocks.AIR.defaultBlockState();
        }
        return state;
    }
}

