/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import twilightforest.block.SpecialMagicLogBlock;
import twilightforest.config.TFConfig;
import twilightforest.data.tags.EntityTagGenerator;
import twilightforest.init.TFParticleType;
import twilightforest.network.ParticlePacket;
import twilightforest.util.BlockCapabilityDirectionalCache;
import twilightforest.util.WorldUtil;

public class SortLogCoreBlock
extends SpecialMagicLogBlock {
    private final BlockCapabilityDirectionalCache<IItemHandler> capabilityCache = new BlockCapabilityDirectionalCache();

    public SortLogCoreBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public boolean doesCoreFunction() {
        return !TFConfig.disableSortingCore;
    }

    @Override
    void performTreeEffect(ServerLevel level, BlockPos pos, RandomSource rand) {
        HashMap<Object, Vec3> inputMap = new HashMap<Object, Vec3>();
        HashMap<IItemHandler, Vec3> outputMap = new HashMap<IItemHandler, Vec3>();
        for (BlockPos blockPos : WorldUtil.getAllAround(pos, TFConfig.sortingCoreRange)) {
            BlockEntity blockEntity;
            if (blockPos.equals((Object)pos) || (blockEntity = level.getBlockEntity(blockPos)) == null) continue;
            if (Math.abs(blockPos.getX() - pos.getX()) <= 2 && Math.abs(blockPos.getY() - pos.getY()) <= 2 && Math.abs(blockPos.getZ() - pos.getZ()) <= 2) {
                ArrayList handlers = new ArrayList();
                Direction[] directionArray = Direction.values();
                int n = directionArray.length;
                for (int i = 0; i < n; ++i) {
                    Direction side = directionArray[i];
                    IItemHandler handler = this.capabilityCache.get((BlockCapability<IItemHandler, Direction>)Capabilities.ItemHandler.BLOCK, level, blockPos, side);
                    if (handler == null) continue;
                    handlers.add(handler);
                }
                if (handlers.isEmpty()) continue;
                inputMap.put(handlers, Vec3.upFromBottomCenterOf((Vec3i)blockPos, (double)1.9));
                continue;
            }
            for (Direction side : Direction.values()) {
                IItemHandler handler = this.capabilityCache.get((BlockCapability<IItemHandler, Direction>)Capabilities.ItemHandler.BLOCK, level, blockPos, side);
                if (handler == null) continue;
                outputMap.put(handler, Vec3.upFromBottomCenterOf((Vec3i)blockPos, (double)1.9));
            }
        }
        ArrayList alreadyUsedForInput = new ArrayList();
        level.getEntities((Entity)null, new AABB(pos).inflate(2.0), entity -> entity.isAlive() && entity.getType().is(EntityTagGenerator.SORTABLE_ENTITIES)).forEach(entity -> {
            ArrayList<IItemHandler> handlers = new ArrayList<IItemHandler>();
            for (Direction side : Direction.values()) {
                IItemHandler handler = (IItemHandler)entity.getCapability(Capabilities.ItemHandler.ENTITY_AUTOMATION, (Object)side);
                if (handler == null) continue;
                handlers.add(handler);
            }
            if (!handlers.isEmpty()) {
                inputMap.put(handlers, entity.position().add(0.0, (double)entity.getBbHeight() + 0.9, 0.0));
                alreadyUsedForInput.add(entity);
            }
        });
        if (inputMap.isEmpty()) {
            return;
        }
        level.getEntities((Entity)null, new AABB(pos).inflate(16.0), entity -> entity.isAlive() && !alreadyUsedForInput.contains(entity) && entity.getType().is(EntityTagGenerator.SORTABLE_ENTITIES)).forEach(entity -> {
            for (Direction side : Direction.values()) {
                IItemHandler handler = (IItemHandler)entity.getCapability(Capabilities.ItemHandler.ENTITY_AUTOMATION, (Object)side);
                if (handler == null) continue;
                outputMap.put(handler, entity.position().add(0.0, (double)entity.getBbHeight() + 0.9, 0.0));
            }
        });
        if (outputMap.isEmpty()) {
            return;
        }
        block3: for (Map.Entry inputHandlers : inputMap.entrySet()) {
            boolean transferred = false;
            for (IItemHandler inputIItemHandler : (List)inputHandlers.getKey()) {
                for (int i = 0; i < inputIItemHandler.getSlots(); ++i) {
                    ItemStack inputStack = inputIItemHandler.extractItem(i, 1, true);
                    if (!inputStack.isEmpty()) {
                        HashMap<Integer, IItemHandler> outputsByCount = new HashMap<Integer, IItemHandler>();
                        for (IItemHandler outputIItemHandler : outputMap.keySet()) {
                            int count = 0;
                            for (int j = 0; j < outputIItemHandler.getSlots(); ++j) {
                                ItemStack stack = outputIItemHandler.getStackInSlot(j);
                                if (!stack.is(inputStack.getItem())) continue;
                                count += stack.getCount();
                            }
                            if (count <= 0) continue;
                            outputsByCount.put(count, outputIItemHandler);
                        }
                        for (Integer count : outputsByCount.keySet().stream().sorted(Comparator.comparingInt(Integer::intValue).reversed()).toList()) {
                            ItemStack newStack;
                            IItemHandler outputIItemHandler = (IItemHandler)outputsByCount.get(count);
                            int firstProperStack = -1;
                            for (int j = 0; j < outputIItemHandler.getSlots(); ++j) {
                                if (!outputIItemHandler.isItemValid(j, inputStack)) continue;
                                ItemStack outputStack = outputIItemHandler.getStackInSlot(j);
                                if (firstProperStack == -1 && outputStack.isEmpty()) {
                                    firstProperStack = j;
                                    continue;
                                }
                                if (!ItemStack.isSameItemSameComponents((ItemStack)inputStack, (ItemStack)outputStack) || outputStack.getCount() >= outputStack.getMaxStackSize() || outputStack.getCount() >= outputIItemHandler.getSlotLimit(j)) continue;
                                firstProperStack = j;
                                break;
                            }
                            if (firstProperStack == -1 || (newStack = inputIItemHandler.extractItem(i, 1, false)).isEmpty() || !outputIItemHandler.insertItem(firstProperStack, newStack, true).isEmpty()) continue;
                            outputIItemHandler.insertItem(firstProperStack, newStack, false);
                            transferred = true;
                            Vec3 xyz = (Vec3)outputMap.get(outputIItemHandler);
                            Vec3 diff = ((Vec3)inputHandlers.getValue()).subtract(xyz);
                            ParticlePacket particlePacket = new ParticlePacket();
                            double x = diff.x - 0.25 + rand.nextDouble() * 0.5;
                            double y = diff.y - 1.75 + rand.nextDouble() * 0.5;
                            double z = diff.z - 0.25 + rand.nextDouble() * 0.5;
                            particlePacket.queueParticle((ParticleOptions)TFParticleType.SORTING_PARTICLE.get(), false, xyz, new Vec3(x, y, z).scale(1.0 / diff.length()));
                            PacketDistributor.sendToPlayersNear((ServerLevel)level, null, (double)xyz.x(), (double)xyz.y(), (double)xyz.z(), (double)64.0, (CustomPacketPayload)particlePacket, (CustomPacketPayload[])new CustomPacketPayload[0]);
                            break;
                        }
                    }
                    if (transferred) break;
                }
                if (!transferred) continue;
                continue block3;
            }
        }
    }
}

