/*
 * Decompiled with CFR 0.152.
 */
package trofers.neoforge.datagen.providers.trophies;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import trofers.Trofers;
import trofers.neoforge.datagen.providers.trophies.TrophyProvider;
import trofers.trophy.builder.EntityTrophyBuilder;
import trofers.trophy.builder.ItemTrophyBuilder;
import trofers.trophy.builder.TrophyBuilder;

public abstract class EntityTrophyProvider
extends TrophyProvider {
    private static final String AMBIENT = "ambient";
    private static final String HURT = "hurt";
    private static final String ATTACK = "attack";
    private final List<LootTableProvider.SubProviderEntry> lootTables = new ArrayList<LootTableProvider.SubProviderEntry>();
    private final String modId;
    private final Map<ResourceLocation, ResourceLocation> entityDrops = new HashMap<ResourceLocation, ResourceLocation>();
    private final Map<ResourceLocation, ResourceLocation> advancementDrops = new HashMap<ResourceLocation, ResourceLocation>();

    public EntityTrophyProvider(String modId) {
        this.modId = modId;
    }

    @Override
    public String getModId() {
        return this.modId;
    }

    public Map<ResourceLocation, ResourceLocation> getEntityDrops() {
        return new HashMap<ResourceLocation, ResourceLocation>(this.entityDrops);
    }

    public Map<ResourceLocation, ResourceLocation> getAdvancementDrops() {
        return new HashMap<ResourceLocation, ResourceLocation>(this.advancementDrops);
    }

    @Override
    public List<LootTableProvider.SubProviderEntry> getLootTables() {
        return this.lootTables;
    }

    protected void addTrophy(ResourceLocation id, TrophyBuilder<?> builder, ResourceLocation entityTypeId) {
        this.entityDrops.put(entityTypeId, id);
        this.addTrophy(id, builder);
    }

    public void addExtraEntityDrops(Map<String, Map<ResourceLocation, ResourceLocation>> trophies) {
    }

    protected ResourceLocation getEntitySound(String entityName, String entitySoundName) {
        return this.id("entity.%s.%s".formatted(entityName, entitySoundName));
    }

    protected String getDefaultSoundName() {
        return AMBIENT;
    }

    protected int getDefaultLootCooldown() {
        return 480;
    }

    protected EntityTrophyWithLootBuilder builder(String entityName) {
        return this.builder(this.id(entityName));
    }

    protected EntityTrophyWithLootBuilder builder(EntityType<?> entityType) {
        return this.builder(BuiltInRegistries.ENTITY_TYPE.getKey(entityType));
    }

    protected EntityTrophyWithLootBuilder builder(ResourceLocation entityType) {
        EntityTrophyWithLootBuilder builder = new EntityTrophyWithLootBuilder(entityType);
        this.addTrophy(this.createEntityTrophyId(entityType), builder, entityType);
        return builder;
    }

    protected ItemTrophyBuilder itemTrophyBuilder(EntityType<?> entityType) {
        ResourceLocation entityTypeId = BuiltInRegistries.ENTITY_TYPE.getKey(entityType);
        ItemTrophyBuilder builder = new ItemTrophyBuilder();
        this.addTrophy(this.createEntityTrophyId(entityTypeId), builder, entityTypeId);
        this.defaultTrophySettings(builder, entityTypeId);
        return builder;
    }

    protected ItemTrophyBuilder itemTrophyBuilder(ResourceLocation entityType) {
        ItemTrophyBuilder builder = new ItemTrophyBuilder();
        this.addTrophy(this.createEntityTrophyId(entityType), builder, entityType);
        this.defaultTrophySettings(builder, entityType);
        return builder;
    }

    protected ResourceLocation createEntityTrophyId(ResourceLocation entityId) {
        Object folder = "";
        if (!entityId.getNamespace().equals("minecraft")) {
            folder = entityId.getNamespace() + "/";
        }
        return Trofers.id((String)folder + entityId.getPath());
    }

    public static Component getEntityDescription(ResourceLocation entityId) {
        return Component.translatable((String)Util.makeDescriptionId((String)"entity", (ResourceLocation)entityId));
    }

    protected void defaultTrophySettings(TrophyBuilder<?> builder, ResourceLocation entityId) {
        builder.baseColor(0x606060);
        builder.scale(0.25);
        builder.requiresMod(this.modId);
        this.defaultSound(builder, entityId);
    }

    protected void defaultSound(TrophyBuilder<?> builder, ResourceLocation entityId) {
        builder.sound(this.getEntitySound(entityId.getPath(), this.getDefaultSoundName()));
    }

    protected void dropsFromAdvancement(EntityType<?> entityType, ResourceLocation advancementId) {
        this.dropsFromAdvancement(BuiltInRegistries.ENTITY_TYPE.getKey(entityType), advancementId);
    }

    protected void dropsFromAdvancement(ResourceLocation entityId, ResourceLocation advancementId) {
        if (!this.entityDrops.containsKey(entityId)) {
            throw new IllegalStateException();
        }
        this.advancementDrops.put(advancementId, this.entityDrops.get(entityId));
        this.entityDrops.remove(entityId);
    }

    public class EntityTrophyWithLootBuilder
    extends EntityTrophyBuilder<EntityTrophyWithLootBuilder> {
        protected EntityTrophyWithLootBuilder(ResourceLocation entityId) {
            super(entityId);
            EntityTrophyProvider.this.defaultTrophySettings(this, entityId);
        }

        public EntityTrophyWithLootBuilder entitySound(String entitySoundName) {
            return (EntityTrophyWithLootBuilder)this.sound(EntityTrophyProvider.this.getEntitySound(this.getEntityId().getPath(), entitySoundName));
        }

        public EntityTrophyWithLootBuilder ambientSound() {
            return this.entitySound(EntityTrophyProvider.AMBIENT);
        }

        public EntityTrophyWithLootBuilder hurtSound() {
            return this.entitySound(EntityTrophyProvider.HURT);
        }

        public EntityTrophyWithLootBuilder attackSound() {
            return this.entitySound(EntityTrophyProvider.ATTACK);
        }

        @Override
        public EntityTrophyWithLootBuilder lootTable(Optional<ResourceKey<LootTable>> lootTable) {
            this.cooldown(EntityTrophyProvider.this.getDefaultLootCooldown());
            return (EntityTrophyWithLootBuilder)super.lootTable(lootTable);
        }

        public EntityTrophyWithLootBuilder loot(LootTable.Builder lootTable) {
            String modId = this.getEntityId().getNamespace().equals("minecraft") ? "" : EntityTrophyProvider.this.getModId() + "/";
            ResourceKey location = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)Trofers.id(String.format("trophies/%s", modId + this.getEntityId().getPath())));
            EntityTrophyProvider.this.lootTables.add(new LootTableProvider.SubProviderEntry(provider -> builder -> builder.accept(location, lootTable), LootContextParamSets.ALL_PARAMS));
            this.lootTable(Optional.of(location));
            return this;
        }

        public EntityTrophyWithLootBuilder loot(LootPoolEntryContainer.Builder<?> entry) {
            return this.loot(LootTable.lootTable().withPool(LootPool.lootPool().add(entry)));
        }

        public EntityTrophyWithLootBuilder loot(Item item) {
            return this.loot((LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)item));
        }

        @Override
        public EntityTrophyWithLootBuilder color(int baseColor, int accentColor) {
            this.name(this.getTrophyName(this.getEntityId(), accentColor));
            return (EntityTrophyWithLootBuilder)super.color(baseColor, accentColor);
        }

        protected Component getTrophyName(ResourceLocation entityId, int color) {
            return ComponentUtils.mergeStyles((MutableComponent)Component.translatable((String)"trophy.trofers.composed", (Object[])new Object[]{EntityTrophyProvider.getEntityDescription(entityId)}), (Style)Style.EMPTY.withColor(TextColor.fromRgb((int)color)));
        }
    }
}

