/*
 * Decompiled with CFR 0.152.
 */
package trofers.item;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import trofers.block.TrophyBlock;
import trofers.block.entity.TrophyBlockEntityRenderer;
import trofers.trophy.Trophy;

public class TrophyItemRenderer {
    public static void render(ItemStack stack, ItemDisplayContext itemDisplayContext, PoseStack poseStack, MultiBufferSource multiBufferSource, int light, int overlay) {
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        TrophyItemRenderer.renderBlockModel(stack, poseStack, multiBufferSource, light, overlay);
        TrophyItemRenderer.renderTrophy(stack, poseStack, multiBufferSource, light, overlay);
        poseStack.popPose();
    }

    private static void renderBlockModel(ItemStack stack, PoseStack poseStack, MultiBufferSource multiBufferSource, int light, int overlay) {
        ItemRenderer renderer = Minecraft.getInstance().getItemRenderer();
        BakedModel model = Minecraft.getInstance().getBlockRenderer().getBlockModel(((BlockItem)stack.getItem()).getBlock().defaultBlockState());
        renderer.render(stack, ItemDisplayContext.NONE, false, poseStack, multiBufferSource, light, overlay, model);
    }

    private static void renderTrophy(ItemStack stack, PoseStack poseStack, MultiBufferSource multiBufferSource, int light, int overlay) {
        Trophy trophy = Trophy.getTrophy(stack);
        if (trophy == null || Minecraft.getInstance().player == null) {
            return;
        }
        poseStack.translate(0.0, -0.5, 0.0);
        float partialTicks = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
        float ticks = (float)Minecraft.getInstance().player.tickCount + partialTicks;
        int trophyHeight = ((TrophyBlock)((BlockItem)stack.getItem()).getBlock()).getHeight();
        TrophyBlockEntityRenderer.render(trophy, ticks, trophyHeight, poseStack, multiBufferSource, light, overlay);
    }
}

