/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.transmog.inventory;

import com.hidoni.transmog.TransmogUtils;
import com.hidoni.transmog.registry.ModBlocks;
import com.hidoni.transmog.registry.ModDataComponents;
import com.hidoni.transmog.registry.ModItemTags;
import com.hidoni.transmog.registry.ModMenus;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class TransmogMenu
extends AbstractContainerMenu {
    public static final int ITEM_TO_TRANSMOG_SLOT = 0;
    public static final int APPEARANCE_ITEM_SLOT = 1;
    public static final int FUEL_ITEM_SLOT = 2;
    public static final int OUTPUT_SLOT = 3;
    private static final int INVENTORY_START = 4;
    private static final int INVENTORY_END = 40;
    private static final int HOTBAR_START = 31;
    public static final int CONTAINER_DATA_SLOT_COUNT = 1;
    private final Container inputContainer = new SimpleContainer(3){

        public void setChanged() {
            super.setChanged();
            TransmogMenu.this.slotsChanged((Container)this);
        }
    };
    private final ResultContainer resultContainer = new ResultContainer(){

        public void setChanged() {
            TransmogMenu.this.slotsChanged((Container)this);
            super.setChanged();
        }
    };
    private final ContainerLevelAccess access;
    private final ContainerData transmogBlockData;

    public TransmogMenu(int i, Inventory inventory) {
        this(i, inventory, ContainerLevelAccess.NULL, (ContainerData)new SimpleContainerData(1));
    }

    public TransmogMenu(int i, Inventory inventory, ContainerLevelAccess access, ContainerData transmogBlockData) {
        super((MenuType)ModMenus.TRANSMOG_MENU.get(), i);
        int j;
        TransmogMenu.checkContainerDataCount((ContainerData)transmogBlockData, (int)1);
        this.access = access;
        this.transmogBlockData = transmogBlockData;
        this.addSlot(new Slot(this.inputContainer, 0, 38, 41));
        this.addSlot(new Slot(this, this.inputContainer, 1, 87, 41){

            public int getMaxStackSize() {
                return 1;
            }
        });
        this.addSlot(new Slot(this, this.inputContainer, 2, 11, 17){

            public boolean mayPlace(@NotNull ItemStack itemStack) {
                return itemStack.is(ModItemTags.TRANSMOG_FUELS);
            }
        });
        this.addSlot(new Slot((Container)this.resultContainer, 3, 145, 41){

            public boolean mayPlace(@NotNull ItemStack stack) {
                return false;
            }

            public void onTake(@NotNull Player player, @NotNull ItemStack stack) {
                super.onTake(player, stack);
                if (TransmogMenu.this.hasFuel()) {
                    TransmogMenu.this.consumeFuel();
                }
                TransmogMenu.this.getSlot(0).remove(1);
                TransmogMenu.this.broadcastChanges();
            }
        });
        this.addDataSlots(transmogBlockData);
        for (j = 0; j < 3; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot((Container)inventory, k + j * 9 + 9, 8 + k * 18, 84 + j * 18));
            }
        }
        for (j = 0; j < 9; ++j) {
            this.addSlot(new Slot((Container)inventory, j, 8 + j * 18, 142));
        }
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        Slot slot = this.getSlot(index);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack item = slot.getItem();
        ItemStack returnStack = item.copy();
        if (index < 4) {
            boolean isOutputSlot;
            boolean bl = isOutputSlot = index == 3;
            if (!this.moveItemStackTo(item, 4, 40, isOutputSlot)) {
                return ItemStack.EMPTY;
            }
            if (isOutputSlot) {
                slot.onQuickCraft(item, returnStack);
            }
        } else {
            boolean move = true;
            if (item.is(ModItemTags.TRANSMOG_FUELS)) {
                move = this.moveItemStackTo(item, 2, 3, false);
            }
            if (move && !this.moveItemStackTo(item, 0, 3, false) && (index < 31 ? !this.moveItemStackTo(item, 31, 40, false) : !this.moveItemStackTo(item, 4, 31, false))) {
                return ItemStack.EMPTY;
            }
        }
        if (item.isEmpty()) {
            slot.setByPlayer(ItemStack.EMPTY);
        }
        slot.setChanged();
        if (item.getCount() == returnStack.getCount()) {
            return ItemStack.EMPTY;
        }
        slot.onTake(player, item);
        this.broadcastChanges();
        return returnStack;
    }

    public void slotsChanged(@NotNull Container container) {
        if (this.getFuel() == 0 && this.getSlot(2).hasItem()) {
            this.refuel();
            this.getSlot(2).remove(1);
        }
        if (this.canTransmogItem()) {
            this.setupResultSlot();
        } else {
            this.resultContainer.removeItemNoUpdate(3);
        }
    }

    private boolean canTransmogItem() {
        return this.getSlot(0).hasItem() && this.hasFuel();
    }

    private void setupResultSlot() {
        this.access.execute((level, pos) -> {
            if (!this.getSlot(1).hasItem()) {
                if (TransmogUtils.isItemStackTransmogged(this.getSlot(0).getItem())) {
                    this.outputRemovedTransmog();
                } else {
                    this.resultContainer.removeItemNoUpdate(3);
                }
            } else {
                this.outputTransmoggedItem();
            }
        });
    }

    private void outputRemovedTransmog() {
        ItemStack item = this.getSlot(0).getItem().copyWithCount(1);
        item.remove((DataComponentType)ModDataComponents.TRANSMOG_APPEARANCE_ITEM.get());
        this.resultContainer.setItem(3, item);
        this.broadcastChanges();
    }

    private void outputTransmoggedItem() {
        ItemStack originalItemToTransmog = this.getSlot(0).getItem().copyWithCount(1);
        ItemStack itemToTransmog = this.createTransmoggedItem(originalItemToTransmog);
        if (ItemStack.matches((ItemStack)itemToTransmog, (ItemStack)originalItemToTransmog)) {
            this.resultContainer.removeItemNoUpdate(3);
        } else {
            this.resultContainer.setItem(3, itemToTransmog);
            this.broadcastChanges();
        }
    }

    @NotNull
    public ItemStack createTransmoggedItem(ItemStack itemToTransmog) {
        ItemStack itemCopy = itemToTransmog.copyWithCount(1);
        ItemStack appearanceItem = TransmogUtils.getAppearanceItemStack(this.getSlot(1).getItem(), true).copyWithCount(1);
        TransmogUtils.transmogAppearanceOntoItemStack(appearanceItem, itemCopy);
        return itemCopy;
    }

    private void refuel() {
        this.transmogBlockData.set(0, 3);
    }

    private void consumeFuel() {
        this.transmogBlockData.set(0, this.getFuel() - 1);
    }

    public int getFuel() {
        return this.transmogBlockData.get(0);
    }

    public boolean hasFuel() {
        return this.getFuel() > 0;
    }

    public boolean stillValid(@NotNull Player player) {
        return TransmogMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)ModBlocks.TRANSMOGRIFICATION_TABLE.get()));
    }

    public void removed(@NotNull Player player) {
        super.removed(player);
        this.resultContainer.removeItemNoUpdate(3);
        this.access.execute(($$1, $$2) -> this.clearContainer(player, this.inputContainer));
    }
}

