/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.transmog.config;

import net.minecraft.util.OptionEnum;
import org.jetbrains.annotations.NotNull;

public enum TransmogRenderOption implements OptionEnum
{
    OFF(0, "transmog.config.render.off", false, false),
    IN_WORLD(1, "transmog.config.render.in_world", true, false),
    EVERYWHERE(2, "transmog.config.render.everywhere", true, true);

    private final int id;
    private final String translationKey;
    public final boolean renderInWorld;
    public final boolean renderInInventory;

    private TransmogRenderOption(int id, String translationKey, boolean renderInWorld, boolean renderInInventory) {
        this.id = id;
        this.translationKey = translationKey;
        this.renderInWorld = renderInWorld;
        this.renderInInventory = renderInInventory;
    }

    public int getId() {
        return this.id;
    }

    public static TransmogRenderOption fromId(int id) {
        return switch (id) {
            case 0 -> OFF;
            case 2 -> EVERYWHERE;
            default -> IN_WORLD;
        };
    }

    @NotNull
    public String getKey() {
        return this.translationKey;
    }

    @NotNull
    public String getTooltipKey() {
        return this.translationKey + ".tooltip";
    }
}

