/*
 * Decompiled with CFR 0.152.
 */
package dev.nolij.toomanyrecipeviewers.impl.widget;

import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.Widget;
import mezz.jei.api.gui.placement.IPlaceable;
import mezz.jei.common.Internal;
import mezz.jei.common.util.ImmutableRect2i;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;

public class ScrollBarWidget
extends Widget
implements IPlaceable<ScrollBarWidget> {
    private ImmutableRect2i rect;
    private ImmutableRect2i upRect;
    private ImmutableRect2i downRect;
    private ImmutableRect2i midRect;
    private ImmutableRect2i scrollRect;
    private ImmutableRect2i dragRect;
    private int scroll = 0;
    private final int maxScroll;
    private final Runnable onScroll;

    public ScrollBarWidget(ImmutableRect2i rect, int rows, int visibleRows, Runnable onScroll) {
        this.setRect(rect);
        this.maxScroll = rows - visibleRows;
        this.onScroll = onScroll;
    }

    private boolean canScroll(int newScroll) {
        return this.scroll != Mth.clamp((int)newScroll, (int)0, (int)this.maxScroll);
    }

    private boolean scroll(int newScroll) {
        int clamped = Mth.clamp((int)newScroll, (int)0, (int)this.maxScroll);
        if (this.scroll == clamped) {
            return false;
        }
        this.scroll = clamped;
        this.updateDragRect();
        this.onScroll.run();
        return true;
    }

    private void updateDragRect() {
        if (this.maxScroll == 0) {
            return;
        }
        double increment = (double)this.scrollRect.height() / ((double)this.maxScroll + 1.0);
        this.dragRect = this.scrollRect.keepTop((int)increment).addOffset(0, (int)(increment * (double)this.scroll));
    }

    public int getScroll() {
        return this.scroll;
    }

    public void setRect(ImmutableRect2i rect) {
        this.rect = rect;
        this.upRect = rect.keepTop(rect.width());
        this.downRect = rect.keepBottom(rect.width());
        this.midRect = rect.cropTop(this.upRect.height()).cropBottom(this.downRect.height());
        this.scrollRect = this.midRect.insetBy(1);
        this.updateDragRect();
    }

    @Override
    public ScrollBarWidget setPosition(int x, int y) {
        this.setRect(this.rect.setPosition(x, y));
        return this;
    }

    @Override
    public int getWidth() {
        return this.rect.width();
    }

    @Override
    public int getHeight() {
        return this.rect.height();
    }

    public Bounds getBounds() {
        return new Bounds(this.rect.x(), this.rect.y(), this.rect.width(), this.rect.height());
    }

    public void render(GuiGraphics draw, int mouseX, int mouseY, float delta) {
        Internal.getTextures().getButtonForState(false, this.canScroll(this.scroll - 1), this.upRect.contains(mouseX, mouseY)).draw(draw, this.upRect);
        Internal.getTextures().getButtonForState(false, this.canScroll(this.scroll + 1), this.downRect.contains(mouseX, mouseY)).draw(draw, this.downRect);
        Internal.getTextures().getButtonForState(false, false, false).draw(draw, this.midRect);
        Internal.getTextures().getButtonForState(false, true, this.dragRect.contains(mouseX, mouseY)).draw(draw, this.dragRect);
    }

    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (!this.rect.contains(mouseX, mouseY)) {
            return false;
        }
        if (this.upRect.contains(mouseX, mouseY)) {
            return this.scroll(this.scroll - 1);
        }
        if (this.downRect.contains(mouseX, mouseY)) {
            return this.scroll(this.scroll + 1);
        }
        if (this.midRect.contains(mouseX, mouseY)) {
            return this.scroll((int)((double)(mouseY - this.scrollRect.y()) / (double)this.scrollRect.height() * ((double)this.maxScroll + 1.0)));
        }
        return false;
    }
}

