/*
 * Decompiled with CFR 0.152.
 */
package dev.nolij.toomanyrecipeviewers.impl.recipe;

import com.mojang.blaze3d.platform.InputConstants;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import dev.emi.emi.jemi.impl.JemiTooltipBuilder;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.screen.EmiScreenManager;
import dev.nolij.toomanyrecipeviewers.TooManyRecipeViewers;
import dev.nolij.toomanyrecipeviewers.impl.jei.api.gui.builder.RecipeLayoutBuilder;
import dev.nolij.toomanyrecipeviewers.impl.jei.api.gui.builder.RecipeSlotBuilder;
import dev.nolij.toomanyrecipeviewers.impl.jei.api.gui.widgets.ScrollGridWidget;
import dev.nolij.toomanyrecipeviewers.impl.jei.api.recipe.RecipeManager;
import dev.nolij.toomanyrecipeviewers.impl.widget.DeferredPlaceableWidget;
import dev.nolij.toomanyrecipeviewers.impl.widget.DrawableWidget;
import dev.nolij.toomanyrecipeviewers.impl.widget.FillingFlameWidget;
import dev.nolij.toomanyrecipeviewers.impl.widget.TextWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawablesView;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.inputs.IJeiGuiEventListener;
import mezz.jei.api.gui.inputs.IJeiInputHandler;
import mezz.jei.api.gui.placement.IPlaceable;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import mezz.jei.api.gui.widgets.IScrollBoxWidget;
import mezz.jei.api.gui.widgets.IScrollGridWidget;
import mezz.jei.api.gui.widgets.ISlottedRecipeWidget;
import mezz.jei.api.gui.widgets.ITextWidget;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.gui.input.InputType;
import mezz.jei.gui.input.UserInput;
import mezz.jei.library.focus.FocusGroup;
import mezz.jei.library.gui.widgets.ScrollBoxRecipeWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class TMRVRecipe<T>
implements EmiRecipe {
    private final TooManyRecipeViewers runtime;
    private final RecipeManager.Category<T> category;
    private final IRecipeCategory<T> jeiCategory;
    private final T jeiRecipe;
    public ResourceLocation originalId;
    public ResourceLocation id;
    private final List<EmiIngredient> inputs;
    private final List<EmiIngredient> catalysts;
    private final List<EmiStack> outputs;
    private final boolean supportsRecipeTree;

    public TMRVRecipe(TooManyRecipeViewers runtime, RecipeManager.Category<T> category, T jeiRecipe, ResourceLocation id) {
        this.runtime = runtime;
        this.category = category;
        this.jeiCategory = Objects.requireNonNull(category.getJEICategory());
        this.jeiRecipe = jeiRecipe;
        this.originalId = this.jeiCategory.getRegistryName(jeiRecipe);
        this.id = id;
        RecipeLayoutBuilder builder = new RecipeLayoutBuilder(runtime.ingredientManager);
        this.jeiCategory.setRecipe(builder, jeiRecipe, FocusGroup.EMPTY);
        RecipeLayoutBuilder.ExtractedEMIRecipeData recipeData = builder.extractEMIRecipeData();
        this.inputs = recipeData.inputs();
        this.catalysts = recipeData.catalysts();
        this.outputs = recipeData.outputs();
        this.supportsRecipeTree = recipeData.supportsRecipeTree();
    }

    public EmiRecipeCategory getCategory() {
        return this.category.getEMICategory();
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiIngredient> getCatalysts() {
        return this.catalysts;
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public int getDisplayWidth() {
        return this.jeiCategory.getWidth();
    }

    public int getDisplayHeight() {
        return this.jeiCategory.getHeight();
    }

    public boolean supportsRecipeTree() {
        return this.supportsRecipeTree;
    }

    public void addWidgets(WidgetHolder widgets) {
        RecipeLayoutBuilder builder = new RecipeLayoutBuilder(this.runtime.ingredientManager);
        this.jeiCategory.setRecipe(builder, this.jeiRecipe, FocusGroup.EMPTY);
        RecipeSlotsView slotsView = new RecipeSlotsView();
        RecipeSlotDrawablesView slotDrawablesView = new RecipeSlotDrawablesView();
        RootWidget rootWidget = (RootWidget)widgets.add((Widget)new RootWidget(widgets, slotsView, slotDrawablesView));
        for (RecipeSlotBuilder slot : builder.getSlots()) {
            if (!slot.isVisible()) continue;
            SlotWidget widget = (SlotWidget)widgets.add((Widget)slot.build());
            slotsView.slots.add((IRecipeSlotView)widget);
            slotDrawablesView.slots.add((IRecipeSlotDrawable)widget);
            if (slot.role != RecipeIngredientRole.OUTPUT) continue;
            widget.recipeContext((EmiRecipe)this);
        }
        this.jeiCategory.createRecipeExtras(rootWidget, this.jeiRecipe, FocusGroup.EMPTY);
    }

    private static class RecipeSlotsView
    implements IRecipeSlotsView {
        private final List<IRecipeSlotView> slots = new ArrayList<IRecipeSlotView>();

        private RecipeSlotsView() {
        }

        @Override
        public @Unmodifiable List<IRecipeSlotView> getSlotViews() {
            return this.slots;
        }
    }

    private static class RecipeSlotDrawablesView
    implements IRecipeSlotDrawablesView {
        private final List<IRecipeSlotDrawable> slots = new ArrayList<IRecipeSlotDrawable>();

        private RecipeSlotDrawablesView() {
        }

        @Override
        public @Unmodifiable List<IRecipeSlotDrawable> getSlots() {
            return this.slots;
        }
    }

    private class RootWidget
    extends Widget
    implements IRecipeExtrasBuilder {
        private final WidgetHolder widgets;
        private final IRecipeSlotsView slotsView;
        private final IRecipeSlotDrawablesView slotDrawablesView;
        private final Bounds bounds;
        private final ArrayList<IRecipeWidget> recipeWidgets = new ArrayList();
        private final ArrayList<IJeiInputHandler> inputHandlers = new ArrayList();
        private final ArrayList<IJeiGuiEventListener> guiEventListeners = new ArrayList();

        private RootWidget(WidgetHolder widgets, IRecipeSlotsView slotsView, IRecipeSlotDrawablesView slotDrawablesView) {
            this.widgets = widgets;
            this.slotsView = slotsView;
            this.slotDrawablesView = slotDrawablesView;
            this.bounds = new Bounds(0, 0, TMRVRecipe.this.getDisplayWidth(), TMRVRecipe.this.getDisplayHeight());
        }

        public Bounds getBounds() {
            return this.bounds;
        }

        public void render(GuiGraphics draw, int mouseX, int mouseY, float delta) {
            EmiDrawContext context = EmiDrawContext.wrap((GuiGraphics)draw);
            context.push();
            context.matrices().translate(0.0f, 0.0f, 0.0f);
            IDrawable categoryBackground = TMRVRecipe.this.jeiCategory.getBackground();
            if (categoryBackground != null) {
                categoryBackground.draw(context.raw());
            }
            TMRVRecipe.this.jeiCategory.draw(TMRVRecipe.this.jeiRecipe, this.slotsView, context.raw(), mouseX, mouseY);
            context.resetColor();
            context.pop();
            for (IRecipeWidget recipeWidget : this.recipeWidgets) {
                context.push();
                ScreenPosition position = recipeWidget.getPosition();
                context.matrices().translate((float)position.x(), (float)position.y(), 0.0f);
                recipeWidget.drawWidget(context.raw(), mouseX - position.x(), mouseY - position.y());
                context.resetColor();
                context.pop();
            }
        }

        public List<ClientTooltipComponent> getTooltip(int mouseX, int mouseY) {
            JemiTooltipBuilder tooltipBuilder = new JemiTooltipBuilder();
            TMRVRecipe.this.jeiCategory.getTooltip((ITooltipBuilder)tooltipBuilder, TMRVRecipe.this.jeiRecipe, this.slotsView, mouseX, mouseY);
            for (IRecipeWidget recipeWidget : this.recipeWidgets) {
                ScreenPosition position = recipeWidget.getPosition();
                recipeWidget.getTooltip((ITooltipBuilder)tooltipBuilder, mouseX - position.x(), mouseY - position.y());
            }
            return tooltipBuilder.tooltip;
        }

        public boolean mouseClicked(int mouseX, int mouseY, int button) {
            return this.handleInput(mouseX, mouseY, InputConstants.Type.MOUSE.getOrCreate(button), 0);
        }

        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            return this.handleInput(EmiScreenManager.lastMouseX, EmiScreenManager.lastMouseY, InputConstants.getKey((int)keyCode, (int)scanCode), modifiers);
        }

        private static boolean containsPoint(ScreenRectangle area, int x, int y) {
            return area.top() <= y && y <= area.bottom() && area.left() <= x && x <= area.right();
        }

        private boolean handleInput(int mouseX, int mouseY, InputConstants.Key key, int modifiers) {
            ScreenPosition position;
            ScreenRectangle area;
            UserInput input = new UserInput(key, mouseX, mouseY, modifiers, InputType.IMMEDIATE);
            for (IJeiInputHandler inputHandler : this.inputHandlers) {
                area = inputHandler.getArea();
                if (!RootWidget.containsPoint(area, mouseX, mouseY) || !inputHandler.handleInput(mouseX - (position = area.position()).x(), mouseY - position.y(), input)) continue;
                return true;
            }
            block5: for (IJeiGuiEventListener guiEventListener : this.guiEventListeners) {
                area = guiEventListener.getArea();
                if (!RootWidget.containsPoint(area, mouseX, mouseY)) continue;
                position = area.position();
                int x = mouseX - position.x();
                int y = mouseY - position.y();
                switch (key.getType()) {
                    case MOUSE: {
                        if (!guiEventListener.mouseReleased(x, y, key.getValue())) continue block5;
                        break;
                    }
                    case KEYSYM: {
                        if (!guiEventListener.keyPressed(x, y, key.getValue(), 0, modifiers)) continue block5;
                        break;
                    }
                    default: {
                        continue block5;
                    }
                }
                return true;
            }
            return TMRVRecipe.this.jeiCategory.handleInput(TMRVRecipe.this.jeiRecipe, mouseX, mouseY, key);
        }

        @Override
        public IRecipeSlotDrawablesView getRecipeSlots() {
            return this.slotDrawablesView;
        }

        @Override
        public void addDrawable(IDrawable drawable, int x, int y) {
            this.widgets.add((Widget)new DrawableWidget(drawable, x, y));
        }

        @Override
        public IPlaceable<?> addDrawable(IDrawable drawable) {
            return (IPlaceable)this.widgets.add((Widget)new DrawableWidget(drawable));
        }

        @Override
        public void addWidget(IRecipeWidget recipeWidget) {
            this.recipeWidgets.add(recipeWidget);
        }

        @Override
        public void addSlottedWidget(ISlottedRecipeWidget slottedRecipeWidget, List<IRecipeSlotDrawable> slots) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addInputHandler(IJeiInputHandler inputHandler) {
            this.inputHandlers.add(inputHandler);
        }

        @Override
        public void addGuiEventListener(IJeiGuiEventListener listener) {
            this.guiEventListeners.add(listener);
        }

        @Override
        public IScrollBoxWidget addScrollBoxWidget(int width, int height, int x, int y) {
            ScrollBoxRecipeWidget widget = new ScrollBoxRecipeWidget(width, height, x, y);
            this.addWidget(widget);
            this.addInputHandler(widget);
            return widget;
        }

        @Override
        public IScrollGridWidget addScrollGridWidget(List<IRecipeSlotDrawable> slots, int columns, int visibleRows) {
            return new ScrollGridWidget(this.widgets, slots, columns, visibleRows);
        }

        private DeferredPlaceableWidget addTexture(EmiTexture texture) {
            return new DeferredPlaceableWidget((x, y) -> this.widgets.addTexture(texture, x, y), texture.width, texture.height);
        }

        @Override
        public IPlaceable<?> addRecipeArrow() {
            return this.addTexture(EmiTexture.EMPTY_ARROW);
        }

        @Override
        public IPlaceable<?> addRecipePlusSign() {
            return this.addTexture(EmiTexture.PLUS);
        }

        @Override
        public IPlaceable<?> addAnimatedRecipeArrow(int cookTime) {
            return new DeferredPlaceableWidget((x, y) -> this.widgets.addFillingArrow(x, y, cookTime), EmiTexture.EMPTY_ARROW.width, EmiTexture.EMPTY_ARROW.height);
        }

        @Override
        public IPlaceable<?> addAnimatedRecipeFlame(int cookTime) {
            return new DeferredPlaceableWidget((x, y) -> this.widgets.add((Widget)new FillingFlameWidget(x, y, cookTime)), EmiTexture.EMPTY_FLAME.width, EmiTexture.EMPTY_FLAME.height);
        }

        @Override
        public ITextWidget addText(List<FormattedText> lines, int maxWidth, int maxHeight) {
            return (ITextWidget)this.widgets.add((Widget)new TextWidget(lines, maxWidth, maxHeight));
        }
    }
}

