/*
 * Decompiled with CFR 0.152.
 */
package dev.nolij.toomanyrecipeviewers.libnolij.util;

import dev.nolij.toomanyrecipeviewers.libnolij.refraction.Refraction;
import dev.nolij.toomanyrecipeviewers.libnolij.util.UnsafeUtil;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.List;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.extensibility.IMixinConfig;
import org.spongepowered.asm.mixin.transformer.IMixinTransformer;
import org.spongepowered.asm.service.IClassProvider;
import org.spongepowered.asm.service.MixinService;

public final class MixinUtil {
    private static final Class<?> MIXIN_TRANSFORMER_CLASS = Refraction.unsafe().getClassOrNull("org.spongepowered.asm.mixin.transformer.MixinTransformer");
    private static final Class<?> MIXIN_PROCESSOR_CLASS = Refraction.unsafe().getClassOrNull("org.spongepowered.asm.mixin.transformer.MixinProcessor");
    private static final MethodHandle GET_PROCESSOR = Refraction.unsafe().getGetterOrNull(MIXIN_TRANSFORMER_CLASS, "processor", MIXIN_PROCESSOR_CLASS, MethodType.methodType(Object.class, IMixinTransformer.class));
    private static final MethodHandle GET_CONFIGS = Refraction.unsafe().getGetterOrNull(MIXIN_PROCESSOR_CLASS, "configs", List.class, MethodType.methodType(List.class, Object.class));

    private MixinUtil() {
    }

    public static void audit() throws Throwable {
        MixinEnvironment env = MixinEnvironment.getCurrentEnvironment();
        Object object = env.getActiveTransformer();
        if (object instanceof IMixinTransformer) {
            IMixinTransformer transformer = (IMixinTransformer)object;
            Object processor = GET_PROCESSOR.invokeExact(transformer);
            List configs = GET_CONFIGS.invokeExact(processor);
            IClassProvider provider = MixinService.getService().getClassProvider();
            for (IMixinConfig config : configs) {
                for (String target : config.getTargets()) {
                    try {
                        provider.findClass(target, false);
                    }
                    catch (Throwable t) {
                        System.err.println("Failed to load " + target);
                        throw t;
                    }
                }
            }
        }
    }

    public static void auditAndExit() {
        int exitCode = 0;
        try {
            MixinUtil.audit();
        }
        catch (Throwable t) {
            t.printStackTrace();
            exitCode = 1;
        }
        UnsafeUtil.exit(exitCode);
    }
}

